/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import javax.validation.metadata.Scope;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.jsr303.DefaultMessageInterpolator;
import org.apache.bval.jsr303.util.TestUtils;

public class BeanDescriptorTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    private Validator getValidator() {
        return factory.getValidator();
    }

    public void testMandatoryAttributesPresentInConstraintDescriptor() {
        Validator validator = this.getValidator();
        Set nameDescriptors = validator.getConstraintsForClass(Form.class).getConstraintsForProperty("name").getConstraintDescriptors();
        Assert.assertEquals((String)"Incorrect number of descriptors", (int)1, (int)nameDescriptors.size());
        ConstraintDescriptor nameDescriptor = (ConstraintDescriptor)nameDescriptors.iterator().next();
        Assert.assertTrue((String)"groups attribute not present", (boolean)nameDescriptor.getAttributes().containsKey("groups"));
        Assert.assertTrue((String)"payload attribute not present", (boolean)nameDescriptor.getAttributes().containsKey("payload"));
        Assert.assertTrue((String)"message attribute not present", (boolean)nameDescriptor.getAttributes().containsKey("message"));
    }

    public void testCorrectValueForInheritedGroupsAttribute() {
        Validator validator = this.getValidator();
        Set passwordDescriptors = validator.getConstraintsForClass(Account.class).getConstraintsForProperty("password").getConstraintDescriptors();
        Assert.assertEquals((String)"Incorrect number of descriptors", (int)1, (int)passwordDescriptors.size());
        ConstraintDescriptor passwordDescriptor = (ConstraintDescriptor)passwordDescriptors.iterator().next();
        Assert.assertEquals((String)"Incorrect number of composing constraints", (int)1, (int)passwordDescriptor.getComposingConstraints().size());
        ConstraintDescriptor notNullDescriptor = (ConstraintDescriptor)passwordDescriptor.getComposingConstraints().iterator().next();
        Class[] notNullGroups = (Class[])notNullDescriptor.getAttributes().get("groups");
        boolean found = false;
        for (Class group : notNullGroups) {
            if (group != Group1.class) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)"Group1 not present in groups attribute", (boolean)found);
    }

    public void testImplicitGroupIsPresent() {
        Validator validator = this.getValidator();
        Set nameDescriptors = validator.getConstraintsForClass(Woman.class).getConstraintsForProperty("name").getConstraintDescriptors();
        Assert.assertEquals((String)"Incorrect number of descriptors", (int)1, (int)nameDescriptors.size());
        ConstraintDescriptor notNullDescriptor = (ConstraintDescriptor)nameDescriptors.iterator().next();
        Class[] notNullGroups = (Class[])notNullDescriptor.getAttributes().get("groups");
        Assert.assertEquals((String)"Incorrect number of groups", (int)2, (int)notNullGroups.length);
        Assert.assertTrue((String)"Default group not present", (notNullGroups[0].equals(Default.class) || notNullGroups[1].equals(Default.class) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Implicit group not present", (notNullGroups[0].equals(Person.class) || notNullGroups[1].equals(Person.class) ? 1 : 0) != 0);
    }

    public void testNoImplicitGroupWhenQueryingInterfaceDirectly() {
        Validator validator = this.getValidator();
        Set nameDescriptors = validator.getConstraintsForClass(Person.class).getConstraintsForProperty("name").getConstraintDescriptors();
        Assert.assertEquals((String)"Incorrect number of descriptors", (int)1, (int)nameDescriptors.size());
        ConstraintDescriptor notNullDescriptor = (ConstraintDescriptor)nameDescriptors.iterator().next();
        Class[] notNullGroups = (Class[])notNullDescriptor.getAttributes().get("groups");
        Assert.assertEquals((String)"Incorrect number of groups", (int)1, (int)notNullGroups.length);
        Assert.assertTrue((String)"Default group not present", (boolean)notNullGroups[0].equals(Default.class));
    }

    public void testElementDescriptorGetElementClass() {
        Validator validator = this.getValidator();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Person.class);
        Assert.assertEquals((String)"Incorrect class returned", Person.class, (Object)beanDescriptor.getElementClass());
        PropertyDescriptor nameDescriptor = beanDescriptor.getConstraintsForProperty("name");
        Assert.assertEquals((String)"Incorrect class returned", String.class, (Object)nameDescriptor.getElementClass());
    }

    public void testConstraintFinderLookingAt() {
        Validator validator = this.getValidator();
        PropertyDescriptor nameDescriptor = validator.getConstraintsForClass(Woman.class).getConstraintsForProperty("name");
        Set constraints = nameDescriptor.findConstraints().lookingAt(Scope.HIERARCHY).getConstraintDescriptors();
        Assert.assertEquals((String)"Incorrect number of descriptors", (int)1, (int)constraints.size());
        constraints = nameDescriptor.findConstraints().lookingAt(Scope.LOCAL_ELEMENT).getConstraintDescriptors();
        Assert.assertEquals((String)"Incorrect number of descriptors", (int)0, (int)constraints.size());
        TestUtils.failOnModifiable(constraints, "constraintFinder constraintDescriptors");
        constraints = nameDescriptor.getConstraintDescriptors();
        Assert.assertEquals((String)"Incorrect number of descriptors", (int)1, (int)constraints.size());
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }

    public static interface Person {
        @NotNull
        public String getName();
    }

    public static class Woman
    implements Person {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static interface Group1 {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotNull(groups={})
    @Constraint(validatedBy={})
    @Documented
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Password {
        public String message() default "Invalid password";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    public static class Account {
        @Password(groups={Group1.class})
        public String password;
    }

    public static class Form {
        @NotNull
        public String name;
    }
}

