/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import javax.validation.Validator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.bval.constraints.Email;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.example.Customer;

public class EmailValidatorTest
extends TestCase {
    private Validator validator;

    public EmailValidatorTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.validator = ApacheValidatorFactory.getDefault().getValidator();
    }

    public void testEmail() {
        Customer customer = new Customer();
        customer.setCustomerId("id-1");
        customer.setFirstName("Mary");
        customer.setLastName("Do");
        customer.setPassword("12345");
        Assert.assertEquals((int)0, (int)this.validator.validate((Object)customer, new Class[0]).size());
        customer.setEmailAddress("some@invalid@address");
        Assert.assertEquals((int)1, (int)this.validator.validate((Object)customer, new Class[0]).size());
        customer.setEmailAddress("some.valid-012345@address_at-test.org");
        Assert.assertEquals((int)0, (int)this.validator.validate((Object)customer, new Class[0]).size());
    }

    public void testEmailCharSequence() {
        EmailAddressBuilder emailAddressBuilder = new EmailAddressBuilder();
        Assert.assertEquals((int)0, (int)this.validator.validate((Object)emailAddressBuilder, new Class[0]).size());
        emailAddressBuilder.getBuffer().append("foo");
        Assert.assertEquals((int)1, (int)this.validator.validate((Object)emailAddressBuilder, new Class[0]).size());
        emailAddressBuilder.getBuffer().append('@');
        Assert.assertEquals((int)1, (int)this.validator.validate((Object)emailAddressBuilder, new Class[0]).size());
        emailAddressBuilder.getBuffer().append("bar");
        Assert.assertEquals((int)0, (int)this.validator.validate((Object)emailAddressBuilder, new Class[0]).size());
        emailAddressBuilder.getBuffer().append('.');
        Assert.assertEquals((int)1, (int)this.validator.validate((Object)emailAddressBuilder, new Class[0]).size());
        emailAddressBuilder.getBuffer().append("baz");
        Assert.assertEquals((int)0, (int)this.validator.validate((Object)emailAddressBuilder, new Class[0]).size());
    }

    public static Test suite() {
        return new TestSuite(EmailValidatorTest.class);
    }

    public static class EmailAddressBuilder {
        @Email
        private StringBuilder buffer = new StringBuilder();

        public StringBuilder getBuffer() {
            return this.buffer;
        }
    }
}

