/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.guice;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.bval.guice.Validate;
import org.apache.bval.jsr303.extensions.MethodValidator;

public final class ValidateMethodInterceptor
implements MethodInterceptor {
    @Inject
    private Validator validator;

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Validate validate = invocation.getMethod().getAnnotation(Validate.class);
        MethodValidator methodValidator = (MethodValidator)this.validator.unwrap(MethodValidator.class);
        HashSet constraintViolations = new HashSet();
        Class<?> clazz = invocation.getMethod().getDeclaringClass();
        Method method = invocation.getMethod();
        Object[] arguments = invocation.getArguments();
        Class[] groups = validate.groups();
        constraintViolations.addAll(methodValidator.validateParameters(clazz, method, arguments, groups));
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException("Validation error when calling method '" + method + "' with arguments " + Arrays.deepToString(arguments), constraintViolations);
        }
        Object returnedValue = invocation.proceed();
        if (validate.validateReturnedValue()) {
            constraintViolations.addAll(methodValidator.validateReturnedValue(clazz, method, returnedValue, groups));
            if (!constraintViolations.isEmpty()) {
                throw new ConstraintViolationException("Method '" + method + "' returned a not valid value " + returnedValue, constraintViolations);
            }
        }
        return returnedValue;
    }
}

