/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.xml;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.bval.model.Validation;
import org.apache.bval.xml.XMLMetaBean;
import org.apache.bval.xml.XMLMetaValidator;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="beanInfos")
public class XMLMetaBeanInfos {
    @XStreamAsAttribute
    private String id;
    @XStreamAsAttribute
    private String version;
    @XStreamImplicit
    private List<XMLMetaValidator> validators;
    @XStreamImplicit
    private List<XMLMetaBean> beans;
    @XStreamOmitField
    private Map<String, XMLMetaBean> beanLookup;
    @XStreamOmitField
    private Map<String, XMLMetaValidator> validationLookup;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<XMLMetaValidator> getValidators() {
        return this.validators;
    }

    public void setValidators(List<XMLMetaValidator> validators) {
        this.validators = validators;
    }

    public List<XMLMetaBean> getBeans() {
        return this.beans;
    }

    public void setBeans(List<XMLMetaBean> beans) {
        this.beans = beans;
    }

    public XMLMetaBean getBean(String id) {
        if (this.beans == null) {
            return null;
        }
        if (this.beanLookup == null) {
            this.initBeanLookup();
        }
        return this.beanLookup.get(id);
    }

    private void initBeanLookup() {
        this.beanLookup = new FastHashMap();
        for (XMLMetaBean bean : this.beans) {
            this.beanLookup.put(bean.getId(), bean);
        }
        ((FastHashMap)this.beanLookup).setFast(true);
    }

    private void initValidationLookup() throws Exception {
        this.validationLookup = new FastHashMap();
        for (XMLMetaValidator xv : this.validators) {
            if (xv.getJava() == null) continue;
            Validation validation = (Validation)ClassUtils.getClass((String)xv.getJava()).newInstance();
            xv.setValidation(validation);
            this.validationLookup.put(xv.getId(), xv);
        }
        ((FastHashMap)this.validationLookup).setFast(true);
    }

    public void addBean(XMLMetaBean bean) {
        if (this.beans == null) {
            this.beans = new ArrayList<XMLMetaBean>();
        }
        this.beans.add(bean);
    }

    public XMLMetaValidator getValidator(String id) throws Exception {
        if (this.validators == null) {
            return null;
        }
        if (this.validationLookup == null) {
            this.initValidationLookup();
        }
        return this.validationLookup.get(id);
    }

    public void addValidator(XMLMetaValidator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList<XMLMetaValidator>();
        }
        this.validators.add(validator);
    }
}

