/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.routines;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bval.model.Validation;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMailValidation
implements Validation {
    private static String ATOM = "[^\\x00-\\x1F^\\(^\\)^\\<^\\>^\\@^\\,^\\;^\\:^\\\\^\\\"^\\.^\\[^\\]^\\s]";
    private static String DOMAIN = "(" + ATOM + "+(\\." + ATOM + "+)*";
    private static String IP_DOMAIN = "\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]";
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("^" + ATOM + "+(\\." + ATOM + "+)*@" + DOMAIN + "|" + IP_DOMAIN + ")$", 2);
    private Pattern pattern = DEFAULT_PATTERN;

    @Override
    public <T extends ValidationListener> void validate(ValidationContext<T> context) {
        if (context.getPropertyValue() == null) {
            return;
        }
        if (!EMailValidation.isValid(context.getPropertyValue(), this.pattern)) {
            context.getListener().addError("emailAddress", context);
        }
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public static boolean isValid(Object value) {
        return EMailValidation.isValid(value, DEFAULT_PATTERN);
    }

    private static boolean isValid(Object value, Pattern aPattern) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String string = (String)value;
        if (string.length() == 0) {
            return true;
        }
        Matcher m = aPattern.matcher(string);
        return m.matches();
    }
}

