/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.bval.IntrospectorMetaBeanFactory;
import org.apache.bval.MetaBeanFactory;
import org.apache.bval.model.MetaBean;
import org.apache.bval.xml.XMLMetaBean;
import org.apache.bval.xml.XMLMetaBeanFactory;
import org.apache.bval.xml.XMLMetaBeanInfos;
import org.apache.bval.xml.XMLMetaBeanLoader;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaBeanBuilder {
    private static final Log log = LogFactory.getLog(MetaBeanBuilder.class);
    private MetaBeanFactory[] factories;
    private XMLMetaBeanFactory xmlFactory;

    public MetaBeanBuilder() {
        this(new MetaBeanFactory[]{new IntrospectorMetaBeanFactory(), new XMLMetaBeanFactory()});
    }

    public MetaBeanBuilder(MetaBeanFactory[] factories) {
        this.setFactories(factories);
    }

    public MetaBeanFactory[] getFactories() {
        return this.factories;
    }

    public void setFactories(MetaBeanFactory[] factories) {
        this.factories = factories;
        this.updateXmlFactory();
    }

    private void updateXmlFactory() {
        for (MetaBeanFactory each : this.factories) {
            if (!(each instanceof XMLMetaBeanFactory)) continue;
            this.xmlFactory = (XMLMetaBeanFactory)each;
            return;
        }
        this.xmlFactory = null;
    }

    public XMLMetaBeanFactory getXmlFactory() {
        return this.xmlFactory;
    }

    public void addLoader(XMLMetaBeanLoader loader) {
        this.assertXmlFactory();
        this.xmlFactory.addLoader(loader);
    }

    public Map<String, MetaBean> buildAll() throws Exception {
        final HashMap<String, MetaBean> all = new HashMap<String, MetaBean>();
        if (this.xmlFactory != null) {
            this.xmlFactory.visitXMLBeanMeta(null, new XMLMetaBeanFactory.Visitor(){

                public void visit(XMLMetaBean empty, XMLMetaBeanInfos xmlInfos) throws Exception {
                    if (xmlInfos.getBeans() == null) {
                        return;
                    }
                    XMLMetaBeanFactory.XMLResult carrier = new XMLMetaBeanFactory.XMLResult(null, xmlInfos);
                    for (XMLMetaBean xmlMeta : xmlInfos.getBeans()) {
                        MetaBean meta = (MetaBean)all.get(xmlMeta.getId());
                        if (meta == null) {
                            meta = MetaBeanBuilder.this.createMetaBean(xmlMeta);
                            all.put(xmlMeta.getId(), meta);
                        }
                        carrier.xmlMeta = xmlMeta;
                        MetaBeanBuilder.this.xmlFactory.enrichMetaBean(meta, carrier);
                    }
                }

                public MetaBean getMetaBean() {
                    return null;
                }
            });
        }
        return all;
    }

    public Map<String, MetaBean> enrichCopies(Map<String, MetaBean> all, XMLMetaBeanInfos ... infosArray) throws Exception {
        this.assertXmlFactory();
        HashMap<String, MetaBean> copies = new HashMap<String, MetaBean>(all.size());
        boolean nothing = true;
        XMLMetaBeanFactory.XMLResult carrier = new XMLMetaBeanFactory.XMLResult();
        XMLMetaBeanInfos[] arr$ = infosArray;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            XMLMetaBeanInfos xmlMetaBeanInfos;
            carrier.xmlInfos = xmlMetaBeanInfos = arr$[i$];
            if (xmlMetaBeanInfos == null) continue;
            try {
                for (XMLMetaBean xmlMeta : xmlMetaBeanInfos.getBeans()) {
                    nothing = false;
                    MetaBean copy = (MetaBean)copies.get(xmlMeta.getId());
                    if (copy == null) {
                        MetaBean meta = all.get(xmlMeta.getId());
                        copy = meta == null ? this.createMetaBean(xmlMeta) : (MetaBean)meta.copy();
                        copies.put(xmlMeta.getId(), copy);
                    }
                    carrier.xmlMeta = xmlMeta;
                    this.xmlFactory.enrichMetaBean(copy, carrier);
                }
                continue;
            }
            catch (IOException e) {
                this.xmlFactory.handleLoadException(xmlMetaBeanInfos, e);
            }
        }
        if (nothing) {
            return all;
        }
        for (Map.Entry<String, MetaBean> entry : all.entrySet()) {
            if (copies.containsKey(entry.getKey())) continue;
            if (entry.getValue().hasRelationships()) {
                copies.put(entry.getKey(), (MetaBean)entry.getValue().copy());
                continue;
            }
            copies.put(entry.getKey(), entry.getValue());
        }
        return copies;
    }

    private void assertXmlFactory() {
        if (this.xmlFactory == null) {
            throw new IllegalStateException("no xmlFactory available");
        }
    }

    public MetaBean buildForId(String beanInfoId) throws Exception {
        this.assertXmlFactory();
        XMLMetaBeanFactory.Visitor v = new XMLMetaBeanFactory.Visitor(){
            private MetaBean meta;

            public MetaBean getMetaBean() {
                return this.meta;
            }

            public void visit(XMLMetaBean xmlMeta, XMLMetaBeanInfos xmlInfos) throws Exception {
                if (this.meta == null) {
                    this.meta = MetaBeanBuilder.this.createMetaBean(xmlMeta);
                }
                MetaBeanBuilder.this.xmlFactory.enrichMetaBean(this.meta, new XMLMetaBeanFactory.XMLResult(xmlMeta, xmlInfos));
            }
        };
        this.xmlFactory.visitXMLBeanMeta(beanInfoId, v);
        if (v.getMetaBean() == null) {
            throw new IllegalArgumentException("MetaBean " + beanInfoId + " not found");
        }
        return v.getMetaBean();
    }

    private MetaBean createMetaBean(XMLMetaBean xmlMeta) throws Exception {
        return this.buildForClass(this.findLocalClass(xmlMeta.getImpl()));
    }

    protected Class<?> findLocalClass(String className) {
        if (className != null) {
            try {
                return ClassUtils.getClass((String)className);
            }
            catch (ClassNotFoundException e) {
                log.trace((Object)("class not found: " + className), (Throwable)e);
            }
        }
        return null;
    }

    public MetaBean buildForClass(Class<?> clazz) throws Exception {
        MetaBean meta = new MetaBean();
        if (clazz != null) {
            meta.setBeanClass(clazz);
            meta.setId(clazz.getName());
        }
        for (MetaBeanFactory factory : this.factories) {
            factory.buildMetaBean(meta);
        }
        return meta;
    }
}

