/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.bval.BeanValidator;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.MetaBeanManagerFactory;
import org.apache.bval.ValidationResults;
import org.apache.bval.example.BusinessObject;
import org.apache.bval.example.BusinessObjectAddress;
import org.apache.bval.model.MetaBean;
import org.apache.bval.xml.XMLMetaBeanLoader;
import org.apache.bval.xml.XMLMetaBeanURLLoader;

public class BeanValidatorTest
extends TestCase {
    public BeanValidatorTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testValidateMapAsBean() {
        MetaBeanManagerFactory.getRegistry().addLoader((XMLMetaBeanLoader)new XMLMetaBeanURLLoader(BusinessObject.class.getResource("test-beanInfos.xml")));
        MetaBean mb = MetaBeanManagerFactory.getFinder().findForId("org.apache.bval.example.Address");
        BusinessObjectAddress adr = new BusinessObjectAddress();
        BeanValidator validator = new BeanValidator();
        ValidationResults results = (ValidationResults)validator.validate((Object)adr, mb);
        BeanValidatorTest.assertEquals((int)2, (int)((List)results.getErrorsByReason().get("mandatory")).size());
        validator.setTreatMapsLikeBeans(true);
        results = (ValidationResults)validator.validate(new HashMap(), mb);
        BeanValidatorTest.assertFalse((boolean)results.isEmpty());
        BeanValidatorTest.assertEquals((int)2, (int)((List)results.getErrorsByReason().get("mandatory")).size());
        validator.setTreatMapsLikeBeans(false);
        results = (ValidationResults)validator.validate(new HashMap(), mb);
        BeanValidatorTest.assertTrue((boolean)results.isEmpty());
    }

    public void testValidate() {
        MetaBeanFinder finder = MetaBeanManagerFactory.getFinder();
        MetaBeanManagerFactory.getRegistry().addLoader((XMLMetaBeanLoader)new XMLMetaBeanURLLoader(BusinessObject.class.getResource("test-beanInfos.xml")));
        MetaBean info = finder.findForClass(BusinessObject.class);
        BusinessObject object = new BusinessObject();
        object.setAddress(new BusinessObjectAddress());
        object.getAddress().setOwner(object);
        BeanValidator validator = new BeanValidator();
        ValidationResults results = (ValidationResults)validator.validate((Object)object, info);
        BeanValidatorTest.assertTrue((boolean)results.hasErrorForReason("mandatory"));
        BeanValidatorTest.assertTrue((boolean)results.hasError((Object)object, null));
        BeanValidatorTest.assertTrue((boolean)results.hasError((Object)object.getAddress(), null));
        BeanValidatorTest.assertTrue((boolean)((ValidationResults)validator.validateProperty((Object)object, info.getProperty("firstName"))).hasError((Object)object, "firstName"));
        object.setUserId(1L);
        object.setFirstName("Hans");
        object.setLastName("Tester");
        object.setAddress(new BusinessObjectAddress());
        object.getAddress().setOwner(object);
        BeanValidatorTest.assertFalse((boolean)((ValidationResults)validator.validate((Object)object, info)).isEmpty());
        object.getAddress().setCountry("0123456789012345678");
        BeanValidatorTest.assertFalse((boolean)((ValidationResults)validator.validate((Object)object, info)).isEmpty());
        object.getAddress().setCountry("Germany");
        object.setAddresses(new ArrayList<BusinessObjectAddress>());
        object.getAddresses().add(object.getAddress());
        object.getAddresses().add(object.getAddress());
        object.getAddresses().add(object.getAddress());
        BeanValidatorTest.assertTrue((boolean)((ValidationResults)validator.validate((Object)object, info)).isEmpty());
        object.getAddresses().add(object.getAddress());
        BeanValidatorTest.assertFalse((boolean)((ValidationResults)validator.validate((Object)object, info)).isEmpty());
    }

    public static Test suite() {
        return new TestSuite(BeanValidatorTest.class);
    }
}

