/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.brooklyn.rest.resources;

import java.net.URI;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.entity.stock.BasicApplication;
import org.apache.brooklyn.rest.testing.BrooklynRestResourceTest;
import org.apache.brooklyn.rest.testing.mocks.RestMockSimpleEntity;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.http.HttpAsserts;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.net.Urls;
import org.apache.http.client.HttpClient;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;

public class SensorResourceIntegrationTest extends BrooklynRestResourceTest {

    private ManagementContext mgmt;
    private BasicApplication app;

    @BeforeClass(alwaysRun = true)
    protected void setUp() {
        mgmt = getManagementContext();
        app = mgmt.getEntityManager().createEntity(EntitySpec.create(BasicApplication.class).displayName("simple-app")
            .child(EntitySpec.create(Entity.class, RestMockSimpleEntity.class).displayName("simple-ent")));
        mgmt.getEntityManager().manage(app);
        app.start(MutableList.of(mgmt.getLocationRegistry().getLocationManaged("localhost")));
    }

    // marked integration because of time
    @Test(groups = "Integration")
    public void testSensorBytes() throws Exception {
        EntityInternal entity = (EntityInternal) Iterables.find(mgmt.getEntityManager().getEntities(), EntityPredicates.displayNameEqualTo("simple-ent"));
        SensorResourceTest.addAmphibianSensor(entity);

        String baseUri = getEndpointAddress();
        URI url = URI.create(Urls.mergePaths(baseUri, SensorResourceTest.SENSORS_ENDPOINT, SensorResourceTest.SENSOR_NAME));

        // Uses explicit "application/json" because failed on jenkins as though "text/plain" was the default on Ubuntu jenkins!
        HttpClient client = HttpTool.httpClientBuilder().uri(baseUri).build();
        HttpToolResponse response = HttpTool.httpGet(client, url, ImmutableMap.<String, String>of("Accept", "application/json"));
        HttpAsserts.assertHealthyStatusCode(response.getResponseCode());
        Assert.assertEquals(response.getContentAsString(), "\"12345 frogs\"");
    }

}
