/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.qa.longevity;

import brooklyn.util.http.HttpTool;
import brooklyn.util.http.HttpToolResponse;
import brooklyn.util.stream.StreamGobbler;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MonitorUtils.class);
    private static volatile int ownPid = -1;

    public static boolean isUrlUp(URL url) {
        try {
            HttpToolResponse result = HttpTool.httpGet((HttpClient)HttpTool.httpClientBuilder().trustAll().build(), (URI)URI.create(url.toString()), (Map)ImmutableMap.of());
            int statuscode = result.getResponseCode();
            if (statuscode != 200) {
                LOG.info("Error reading URL {}: {}, {}", new Object[]{url, statuscode, result.getReasonPhrase()});
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOG.info("Error reading URL {}: {}", (Object)url, (Object)e);
            return false;
        }
    }

    public static boolean isPidRunning(int pid) {
        return MonitorUtils.isPidRunning(pid, null);
    }

    public static boolean isPidRunning(int pid, String regex) {
        Process process = MonitorUtils.exec("ps -p " + pid);
        String out = MonitorUtils.waitFor(process);
        if (process.exitValue() > 0) {
            String err = MonitorUtils.toString(process.getErrorStream());
            LOG.info(String.format("pid %s not running: %s", pid, err));
            return false;
        }
        if (regex != null) {
            String regex2 = "^\\s*" + pid + ".*" + regex;
            boolean found = false;
            for (String line : out.split("\n")) {
                if (!MonitorUtils.hasAtLeastOneMatch(line, regex2)) continue;
                found = true;
                break;
            }
            if (!found) {
                String txt = MonitorUtils.toString(process.getInputStream());
                LOG.info("process did not match regular expression: " + txt);
                return false;
            }
        }
        return true;
    }

    private static boolean hasAtLeastOneMatch(String line, String regex) {
        return Pattern.matches(".*" + regex + ".*", line);
    }

    private static String toString(InputStream in) {
        try {
            byte[] bytes = ByteStreams.toByteArray((InputStream)in);
            return new String(bytes);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static List<Integer> getRunningPids(String regex) {
        return MonitorUtils.getRunningPids(regex, null);
    }

    public static List<Integer> getRunningPids(String regex, String excludingRegex) {
        Process process = MonitorUtils.exec("ps ax");
        String out = MonitorUtils.waitFor(process);
        LinkedList<Integer> result = new LinkedList<Integer>();
        for (String line : out.split("\n")) {
            if (excludingRegex != null && MonitorUtils.hasAtLeastOneMatch(line, excludingRegex) || !MonitorUtils.hasAtLeastOneMatch(line, regex)) continue;
            String[] linesplit = line.trim().split("\\s+");
            result.add(Integer.parseInt(linesplit[0]));
        }
        return result;
    }

    public static MemoryUsage getMemoryUsage(int pid) {
        return MonitorUtils.getMemoryUsage(pid, null, 0);
    }

    public static MemoryUsage getMemoryUsage(int pid, String clazzRegexOfInterest, int minInstancesOfInterest) {
        Process process = MonitorUtils.exec(String.format("jmap -histo %s", pid));
        String out = MonitorUtils.waitFor(process);
        LinkedHashMap instanceCounts = Maps.newLinkedHashMap();
        long totalInstances = 0L;
        long totalMemoryBytes = 0L;
        for (String line : out.split("\n")) {
            String[] parts;
            if (clazzRegexOfInterest != null && MonitorUtils.hasAtLeastOneMatch(line, clazzRegexOfInterest)) {
                parts = line.trim().split("\\s+");
                String clazz = parts[3];
                int instanceCount = Integer.parseInt(parts[1]);
                if (instanceCount >= minInstancesOfInterest) {
                    instanceCounts.put(clazz, instanceCount);
                }
            }
            if (!MonitorUtils.hasAtLeastOneMatch(line, "^Total.*")) continue;
            parts = line.split("\\s+");
            totalInstances = Long.parseLong(parts[1]);
            totalMemoryBytes = Long.parseLong(parts[2]);
        }
        return new MemoryUsage(totalInstances, totalMemoryBytes, instanceCounts);
    }

    public static List<String> searchLog(File file, String grepOfInterest) {
        return MonitorUtils.searchLog(file, grepOfInterest, new LinkedHashSet<String>());
    }

    public static List<String> searchLog(File file, String grepOfInterest, Set<String> grepExclusions) {
        Process process = MonitorUtils.exec(String.format("grep -E %s %s", grepOfInterest, file.getAbsoluteFile()));
        String out = MonitorUtils.waitFor(process);
        if (out.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String line : out.trim().split("\n")) {
            boolean excluded = false;
            for (String exclusion : grepExclusions) {
                if (Strings.isNullOrEmpty((String)exclusion) || !MonitorUtils.hasAtLeastOneMatch(line, exclusion)) continue;
                excluded = true;
            }
            if (excluded) continue;
            result.add(line);
        }
        return result;
    }

    public static Process exec(String cmd) {
        LOG.info("executing cmd: " + cmd);
        try {
            return Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String waitFor(Process process) {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        StreamGobbler gobblerOut = new StreamGobbler(process.getInputStream(), (OutputStream)bytesOut, null);
        gobblerOut.start();
        ByteArrayOutputStream bytesErr = new ByteArrayOutputStream();
        StreamGobbler gobblerErr = new StreamGobbler(process.getErrorStream(), (OutputStream)bytesErr, null);
        gobblerErr.start();
        try {
            process.waitFor();
            gobblerOut.blockUntilFinished();
            gobblerErr.blockUntilFinished();
            if (bytesErr.size() > 0) {
                throw new ProcessHasStderr(bytesErr.toByteArray());
            }
            String string = new String(bytesOut.toByteArray());
            return string;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            if (gobblerOut.isAlive()) {
                gobblerOut.interrupt();
            }
            if (gobblerErr.isAlive()) {
                gobblerErr.interrupt();
            }
        }
    }

    public static int findOwnPid() throws IOException {
        if (ownPid >= 0) {
            return ownPid;
        }
        String[] cmd = new String[]{"bash", "-c", "echo $PPID"};
        Process process = Runtime.getRuntime().exec(cmd);
        String out = MonitorUtils.waitFor(process);
        ownPid = Integer.parseInt(out.trim());
        return ownPid;
    }

    public static class ProcessHasStderr
    extends IllegalStateException {
        private static final long serialVersionUID = -937871002993888405L;
        byte[] stderrBytes;

        public ProcessHasStderr(byte[] stderrBytes) {
            this("Process printed to stderr: " + new String(stderrBytes), stderrBytes);
        }

        public ProcessHasStderr(String message, byte[] stderrBytes) {
            super(message);
            this.stderrBytes = stderrBytes;
        }
    }

    public static class MemoryUsage {
        final long totalInstances;
        final long totalMemoryBytes;
        final Map<String, Integer> instanceCounts;

        MemoryUsage(long totalInstances, long totalMemoryBytes, Map<String, Integer> instanceCounts) {
            this.totalInstances = totalInstances;
            this.totalMemoryBytes = totalMemoryBytes;
            this.instanceCounts = instanceCounts;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("totalInstances", this.totalInstances).add("totalMemoryBytes", this.totalMemoryBytes).add("instanceCounts", this.instanceCounts).toString();
        }

        public long getTotalInstances() {
            return this.totalInstances;
        }

        public long getTotalMemoryBytes() {
            return this.totalMemoryBytes;
        }

        public Map<String, Integer> getInstanceCounts() {
            return this.instanceCounts;
        }
    }
}

