/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.qa.longevity;

import brooklyn.qa.longevity.MonitorListener;
import brooklyn.qa.longevity.MonitorPrefs;
import brooklyn.qa.longevity.MonitorUtils;
import brooklyn.qa.longevity.StatusRecorder;
import brooklyn.util.collections.TimeWindowedList;
import brooklyn.util.collections.TimestampedValue;
import brooklyn.util.time.Duration;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor {
    private static final Logger LOG = LoggerFactory.getLogger(Monitor.class);
    private static final int checkPeriodMs = 1000;
    private static final OptionParser parser = new OptionParser(){
        {
            this.acceptsAll((Collection)ImmutableList.of((Object)"help", (Object)"?", (Object)"h"), "show help");
            this.accepts("webUrl", "Web-app url").withRequiredArg().ofType(URL.class);
            this.accepts("brooklynPid", "Brooklyn pid").withRequiredArg().ofType(Integer.class);
            this.accepts("logFile", "Brooklyn log file").withRequiredArg().ofType(File.class);
            this.accepts("logGrep", "Grep in log file (defaults to 'SEVERE|ERROR|WARN|Exception|Error'").withRequiredArg().ofType(String.class);
            this.accepts("logGrepExclusionsFile", "File of expressions to be ignored in log file").withRequiredArg().ofType(File.class);
            this.accepts("webProcesses", "Name (for `ps ax | grep` of web-processes").withRequiredArg().ofType(String.class);
            this.accepts("numWebProcesses", "Number of web-processes expected (e.g. 1 or 1-3)").withRequiredArg().ofType(String.class);
            this.accepts("webProcessesCyclingPeriod", "The period (in seconds) for cycling through the range of numWebProcesses").withRequiredArg().ofType(Integer.class);
            this.accepts("outFile", "File to write monitor status info").withRequiredArg().ofType(File.class);
            this.accepts("abortOnError", "Exit the JVM on error, with exit code 1").withRequiredArg().ofType(Boolean.class);
        }
    };
    private final MonitorPrefs prefs;
    private final StatusRecorder recorder;
    private final MonitorListener listener;

    public static void main(String[] argv) throws InterruptedException, IOException {
        OptionSet options = Monitor.parse(argv);
        if (options == null || options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        MonitorPrefs prefs = new MonitorPrefs();
        prefs.webUrl = options.hasArgument("webUrl") ? (URL)options.valueOf("webUrl") : null;
        prefs.brooklynPid = options.hasArgument("brooklynPid") ? (Integer)options.valueOf("brooklynPid") : -1;
        prefs.logFile = options.hasArgument("logFile") ? (File)options.valueOf("logFile") : null;
        prefs.logGrep = options.hasArgument("logGrep") ? (String)options.valueOf("logGrep") : "SEVERE|ERROR|WARN|Exception|Error";
        prefs.logGrepExclusionsFile = options.hasArgument("logGrepExclusionsFile") ? (File)options.valueOf("logGrepExclusionsFile") : null;
        prefs.webProcessesRegex = options.hasArgument("webProcesses") ? (String)options.valueOf("webProcesses") : null;
        prefs.numWebProcesses = options.hasArgument("numWebProcesses") ? Monitor.parseRange((String)options.valueOf("numWebProcesses")) : null;
        prefs.webProcessesCyclingPeriod = options.hasArgument("webProcessesCyclingPeriod") ? (Integer)options.valueOf("webProcessesCyclingPeriod") : -1;
        prefs.outFile = options.hasArgument("outFile") ? (File)options.valueOf("outFile") : null;
        prefs.abortOnError = options.hasArgument("abortOnError") ? (Boolean)options.valueOf("abortOnError") : false;
        Monitor main = new Monitor(prefs, MonitorListener.NOOP);
        main.start();
    }

    private static Range<Integer> parseRange(String range) {
        if (range.contains("-")) {
            String[] parts = range.split("-");
            return Range.closed((Comparable)Integer.valueOf(Integer.parseInt(parts[0])), (Comparable)Integer.valueOf(Integer.parseInt(parts[1])));
        }
        return Range.singleton((Comparable)Integer.valueOf(Integer.parseInt(range)));
    }

    private static OptionSet parse(String ... argv) {
        try {
            return parser.parse(argv);
        }
        catch (Exception e) {
            System.out.println("Error in parsing options: " + e.getMessage());
            return null;
        }
    }

    public Monitor(MonitorPrefs prefs, MonitorListener listener) {
        this.prefs = prefs;
        this.listener = listener;
        this.recorder = StatusRecorder.Factory.chain(StatusRecorder.Factory.toLog(LOG), prefs.outFile != null ? StatusRecorder.Factory.toFile(prefs.outFile) : StatusRecorder.Factory.noop());
    }

    private void start() throws IOException {
        LOG.info("Monitoring: " + this.prefs);
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        AtomicReference previousLogLines = new AtomicReference(Collections.emptyList());
        TimeWindowedList numWebProcessesHistory = new TimeWindowedList((Map)ImmutableMap.of((Object)"timePeriod", (Object)Duration.seconds((Number)this.prefs.webProcessesCyclingPeriod), (Object)"minExpiredVals", (Object)1));
        ImmutableSet logGrepExclusions = ImmutableSet.copyOf((Collection)Files.readLines((File)this.prefs.logGrepExclusionsFile, (Charset)Charsets.UTF_8));
        executor.scheduleAtFixedRate(new Runnable((Set)logGrepExclusions, previousLogLines, numWebProcessesHistory){
            final /* synthetic */ Set val$logGrepExclusions;
            final /* synthetic */ AtomicReference val$previousLogLines;
            final /* synthetic */ TimeWindowedList val$numWebProcessesHistory;
            {
                this.val$logGrepExclusions = set;
                this.val$previousLogLines = atomicReference;
                this.val$numWebProcessesHistory = timeWindowedList;
            }

            @Override
            public void run() {
                StatusRecorder.Record record = new StatusRecorder.Record();
                StringBuilder failureMsg = new StringBuilder();
                try {
                    if (((Monitor)Monitor.this).prefs.brooklynPid > 0) {
                        boolean pidRunning = MonitorUtils.isPidRunning(((Monitor)Monitor.this).prefs.brooklynPid, "java");
                        MonitorUtils.MemoryUsage memoryUsage = MonitorUtils.getMemoryUsage(((Monitor)Monitor.this).prefs.brooklynPid, ".*brooklyn.*", 1000);
                        record.put("pidRunning", pidRunning);
                        record.put("totalMemoryBytes", memoryUsage.getTotalMemoryBytes());
                        record.put("totalMemoryInstances", memoryUsage.getTotalInstances());
                        record.put("instanceCounts", memoryUsage.getInstanceCounts());
                        if (!pidRunning) {
                            failureMsg.append("pid " + ((Monitor)Monitor.this).prefs.brooklynPid + " is not running" + "\n");
                        }
                    }
                    if (((Monitor)Monitor.this).prefs.webUrl != null) {
                        boolean webUrlUp = MonitorUtils.isUrlUp(((Monitor)Monitor.this).prefs.webUrl);
                        record.put("webUrlUp", webUrlUp);
                        if (!webUrlUp) {
                            failureMsg.append("web URL " + ((Monitor)Monitor.this).prefs.webUrl + " is not available" + "\n");
                        }
                    }
                    if (((Monitor)Monitor.this).prefs.logFile != null) {
                        List<String> logLines = MonitorUtils.searchLog(((Monitor)Monitor.this).prefs.logFile, ((Monitor)Monitor.this).prefs.logGrep, this.val$logGrepExclusions);
                        List newLogLines = Monitor.getAdditions((List)this.val$previousLogLines.get(), logLines);
                        this.val$previousLogLines.set(logLines);
                        record.put("logLines", newLogLines);
                        if (newLogLines.size() > 0) {
                            failureMsg.append("Log contains warnings/errors: " + newLogLines + "\n");
                        }
                    }
                    if (((Monitor)Monitor.this).prefs.webProcessesRegex != null) {
                        List<Integer> pids = MonitorUtils.getRunningPids(((Monitor)Monitor.this).prefs.webProcessesRegex, "--webProcesses");
                        pids.remove((Object)MonitorUtils.findOwnPid());
                        record.put("webPids", pids);
                        record.put("numWebPids", pids.size());
                        this.val$numWebProcessesHistory.add((Object)pids.size());
                        if (((Monitor)Monitor.this).prefs.numWebProcesses != null) {
                            boolean numWebPidsInRange = ((Monitor)Monitor.this).prefs.numWebProcesses.apply((Comparable)Integer.valueOf(pids.size()));
                            record.put("numWebPidsInRange", numWebPidsInRange);
                            if (!numWebPidsInRange) {
                                failureMsg.append("num web processes out-of-range: pids=" + pids + "; size=" + pids.size() + "; expected=" + ((Monitor)Monitor.this).prefs.numWebProcesses);
                            }
                            if (((Monitor)Monitor.this).prefs.webProcessesCyclingPeriod > 0) {
                                List values = this.val$numWebProcessesHistory.getValues();
                                long valuesTimeRange = ((TimestampedValue)values.get(values.size() - 1)).getTimestamp() - ((TimestampedValue)values.get(0)).getTimestamp();
                                if (values.size() > 0 && valuesTimeRange > TimeUnit.SECONDS.toMillis(((Monitor)Monitor.this).prefs.webProcessesCyclingPeriod)) {
                                    int min = -1;
                                    int max = -1;
                                    for (TimestampedValue val : values) {
                                        min = min < 0 ? (Integer)val.getValue() : Math.min((Integer)val.getValue(), min);
                                        max = Math.max((Integer)val.getValue(), max);
                                    }
                                    record.put("minWebSizeInPeriod", min);
                                    record.put("maxWebSizeInPeriod", max);
                                    if (min > (Integer)((Monitor)Monitor.this).prefs.numWebProcesses.lowerEndpoint() || max < (Integer)((Monitor)Monitor.this).prefs.numWebProcesses.upperEndpoint()) {
                                        failureMsg.append("num web processes not increasing/decreasing correctly: pids=" + pids + "; size=" + pids.size() + "; cyclePeriod=" + ((Monitor)Monitor.this).prefs.webProcessesCyclingPeriod + "; expectedRange=" + ((Monitor)Monitor.this).prefs.numWebProcesses + "; min=" + min + "; max=" + max + "; history=" + values);
                                    }
                                } else {
                                    int numVals = values.size();
                                    long startTime = numVals > 0 ? ((TimestampedValue)values.get(0)).getTimestamp() : 0L;
                                    long endTime = numVals > 0 ? ((TimestampedValue)values.get(values.size() - 1)).getTimestamp() : 0L;
                                    LOG.info("Insufficient vals in time-window to determine cycling behaviour over period (" + ((Monitor)Monitor.this).prefs.webProcessesCyclingPeriod + "secs): " + "numVals=" + numVals + "; startTime=" + startTime + "; endTime=" + endTime + "; periodCovered=" + (endTime - startTime) / 1000L);
                                }
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.error("Error during periodic checks", t);
                    throw Throwables.propagate((Throwable)t);
                }
                try {
                    Monitor.this.recorder.record(record);
                    Monitor.this.listener.onRecord(record);
                    if (failureMsg.length() > 0) {
                        Monitor.this.listener.onFailure(record, failureMsg.toString());
                        if (((Monitor)Monitor.this).prefs.abortOnError) {
                            LOG.error("Aborting on error: " + failureMsg);
                            System.exit(1);
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.warn("Error recording monitor info (" + record + ")", t);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    private static List<String> getAdditions(List<String> prev, List<String> next) {
        ArrayList result = Lists.newArrayList(next);
        result.removeAll(prev);
        return result;
    }
}

