/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.qa.load;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.Enrichers;
import brooklyn.enricher.HttpLatencyDetector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractApplication;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.StartableApplication;
import brooklyn.entity.database.mysql.MySqlNode;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.java.JavaEntityMethods;
import brooklyn.entity.proxy.nginx.NginxController;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Startable;
import brooklyn.entity.webapp.ControlledDynamicWebAppCluster;
import brooklyn.entity.webapp.DynamicWebAppCluster;
import brooklyn.entity.webapp.JavaWebAppService;
import brooklyn.entity.webapp.WebAppService;
import brooklyn.entity.webapp.WebAppServiceConstants;
import brooklyn.entity.webapp.jboss.JBoss7Server;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.basic.DependentConfiguration;
import brooklyn.launcher.BrooklynLauncher;
import brooklyn.location.basic.PortRanges;
import brooklyn.policy.Policy;
import brooklyn.policy.autoscaling.AutoScalerPolicy;
import brooklyn.qa.load.SimulatedJBoss7ServerImpl;
import brooklyn.qa.load.SimulatedMySqlNodeImpl;
import brooklyn.qa.load.SimulatedNginxControllerImpl;
import brooklyn.util.CommandLineUtil;
import brooklyn.util.collections.MutableSet;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SimulatedTheeTierApp
extends AbstractApplication {
    public static final ConfigKey<Boolean> SIMULATE_ENTITY = ConfigKeys.newBooleanConfigKey((String)"simulateEntity", (String)"", (Boolean)true);
    public static final ConfigKey<Boolean> SIMULATE_EXTERNAL_MONITORING = ConfigKeys.newBooleanConfigKey((String)"simulateExternalMonitoring", (String)"", (Boolean)true);
    public static final ConfigKey<Boolean> SKIP_SSH_ON_START = ConfigKeys.newBooleanConfigKey((String)"skipSshOnStart", (String)"", (Boolean)false);
    public static final String WAR_PATH = "classpath://hello-world.war";
    public static final String DB_TABLE = "visitors";
    public static final String DB_USERNAME = "brooklyn";
    public static final String DB_PASSWORD = "br00k11n";
    public static final boolean USE_HTTPS = false;

    public void init() {
        MySqlNode mysql = (MySqlNode)this.addChild(EntitySpec.create(MySqlNode.class).impl(SimulatedMySqlNodeImpl.class));
        ControlledDynamicWebAppCluster web = (ControlledDynamicWebAppCluster)this.addChild(EntitySpec.create(ControlledDynamicWebAppCluster.class).configure((ConfigKey.HasConfigKey)ControlledDynamicWebAppCluster.MEMBER_SPEC, (Object)EntitySpec.create(JBoss7Server.class).impl(SimulatedJBoss7ServerImpl.class)).configure((ConfigKey.HasConfigKey)ControlledDynamicWebAppCluster.CONTROLLER_SPEC, (Object)EntitySpec.create(NginxController.class).impl(SimulatedNginxControllerImpl.class)).configure((ConfigKey.HasConfigKey)WebAppService.HTTP_PORT, (Object)PortRanges.fromString((String)"8080+")).configure(JavaWebAppService.ROOT_WAR, (Object)WAR_PATH).configure(JavaEntityMethods.javaSysProp((String)"brooklyn.example.db.url"), DependentConfiguration.formatString((String)"jdbc:%s%s?user=%s\\&password=%s", (Object[])new Object[]{DependentConfiguration.attributeWhenReady((Entity)mysql, (AttributeSensor)MySqlNode.DATASTORE_URL), DB_TABLE, DB_USERNAME, DB_PASSWORD})).configure((ConfigKey)DynamicCluster.INITIAL_SIZE, (Object)2).configure((ConfigKey.HasConfigKey)WebAppService.ENABLED_PROTOCOLS, (Object)ImmutableSet.of((Object)"http")));
        web.getCluster().addPolicy((Policy)AutoScalerPolicy.builder().metric(DynamicWebAppCluster.REQUESTS_PER_SECOND_IN_WINDOW_PER_NODE).metricRange((Number)10, (Number)100).sizeRange(2, 5).build());
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{Attributes.MAIN_URI, WebAppServiceConstants.ROOT_URL, DynamicWebAppCluster.REQUESTS_PER_SECOND_IN_WINDOW, HttpLatencyDetector.REQUEST_LATENCY_IN_SECONDS_IN_WINDOW}).from((Entity)web)).build());
        this.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(Startable.SERVICE_UP).publishing(Startable.SERVICE_UP).fromHardcodedProducers((Iterable)ImmutableList.of((Object)web, (Object)mysql))).computing((Function)new Function<Collection<Boolean>, Boolean>(){

            public Boolean apply(Collection<Boolean> input) {
                return input != null && input.size() == 2 && MutableSet.copyOf(input).equals((Object)ImmutableSet.of((Object)true));
            }
        })).build());
    }

    public static void main(String[] argv) {
        ArrayList args = Lists.newArrayList((Object[])argv);
        String port = CommandLineUtil.getCommandLineOption((List)args, (String)"--port", (String)"8081+");
        String location = CommandLineUtil.getCommandLineOption((List)args, (String)"--location", (String)"localhost");
        BrooklynLauncher launcher = BrooklynLauncher.newInstance().application((EntitySpec)EntitySpec.create(StartableApplication.class, SimulatedTheeTierApp.class).displayName("Brooklyn WebApp Cluster with Database example")).webconsolePort(port).location(location).start();
        Entities.dumpInfo((Iterable)launcher.getApplications());
    }
}

