/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.qa.load;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Group;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.proxy.nginx.NginxControllerImpl;
import brooklyn.entity.proxy.nginx.NginxSshDriver;
import brooklyn.entity.proxy.nginx.UrlMapping;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.event.feed.function.FunctionFeed;
import brooklyn.event.feed.function.FunctionPollConfig;
import brooklyn.event.feed.http.HttpFeed;
import brooklyn.event.feed.http.HttpPollConfig;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.policy.PolicySpec;
import brooklyn.qa.load.SimulatedTheeTierApp;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Networking;
import com.google.common.base.Functions;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;

public class SimulatedNginxControllerImpl
extends NginxControllerImpl {
    public static final ConfigKey<Boolean> SIMULATE_ENTITY = SimulatedTheeTierApp.SIMULATE_ENTITY;
    public static final ConfigKey<Boolean> SIMULATE_EXTERNAL_MONITORING = SimulatedTheeTierApp.SIMULATE_EXTERNAL_MONITORING;
    public static final ConfigKey<Boolean> SKIP_SSH_ON_START = SimulatedTheeTierApp.SKIP_SSH_ON_START;
    private HttpFeed httpFeed;
    private FunctionFeed functionFeed;

    public Class<?> getDriverInterface() {
        return SimulatedNginxSshDriver.class;
    }

    public void connectSensors() {
        boolean simulateEntity = (Boolean)this.getConfig(SIMULATE_ENTITY);
        boolean simulateExternalMonitoring = (Boolean)this.getConfig(SIMULATE_EXTERNAL_MONITORING);
        if (!simulateEntity && !simulateExternalMonitoring) {
            super.connectSensors();
            return;
        }
        if (this.getUrl() == null) {
            this.setAttribute(MAIN_URI, URI.create(this.inferUrl()));
            this.setAttribute(ROOT_URL, this.inferUrl());
        }
        this.addServerPoolMemberTrackingPolicy();
        ConfigToAttributes.apply((EntityLocal)this);
        if (!simulateExternalMonitoring) {
            String uriToPoll = simulateEntity ? "http://localhost:8081" : ((URI)this.getAttribute(MAIN_URI)).toString();
            this.httpFeed = HttpFeed.builder().entity((EntityLocal)this).period(((Long)this.getConfig(HTTP_POLL_PERIOD)).longValue()).baseUri(uriToPoll).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(SERVICE_UP).onSuccess(Functions.constant((Object)true))).onFailureOrException(Functions.constant((Object)true))).build();
        }
        this.functionFeed = FunctionFeed.builder().entity((EntityLocal)this).period(((Long)this.getConfig(HTTP_POLL_PERIOD)).longValue()).poll(new FunctionPollConfig(SERVICE_UP).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return true;
            }
        })).build();
        Group urlMappings = (Group)this.getConfig(URL_MAPPINGS);
        if (urlMappings != null) {
            this.subscribeToMembers(urlMappings, (Sensor)UrlMapping.TARGET_ADDRESSES, (SensorEventListener)new SensorEventListener<Collection<String>>(){

                public void onEvent(SensorEvent<Collection<String>> event) {
                    SimulatedNginxControllerImpl.this.updateNeeded();
                }
            });
            this.urlMappingsMemberTrackerPolicy = (NginxControllerImpl.UrlMappingsMemberTrackerPolicy)this.addPolicy(PolicySpec.create(NginxControllerImpl.UrlMappingsMemberTrackerPolicy.class).configure((CharSequence)"group", (Object)urlMappings));
        }
    }

    protected void disconnectSensors() {
        super.disconnectSensors();
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        if (this.functionFeed != null) {
            this.functionFeed.stop();
        }
    }

    public static class SimulatedNginxSshDriver
    extends NginxSshDriver {
        public SimulatedNginxSshDriver(SimulatedNginxControllerImpl entity, SshMachineLocation machine) {
            super((NginxControllerImpl)entity, machine);
        }

        public void install() {
            if (!((Boolean)this.entity.getConfig(SKIP_SSH_ON_START)).booleanValue()) {
                super.install();
            }
        }

        public void customize() {
            if (!((Boolean)this.entity.getConfig(SKIP_SSH_ON_START)).booleanValue()) {
                super.customize();
            }
        }

        public void launch() {
            if (!((Boolean)this.entity.getConfig(SIMULATE_ENTITY)).booleanValue()) {
                super.launch();
                return;
            }
            Networking.checkPortsValid((Map)MutableMap.of((Object)"httpPort", (Object)this.getPort()));
            if (((Boolean)this.entity.getConfig(SKIP_SSH_ON_START)).booleanValue()) {
                this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), (String)"launching").body.append(new CharSequence[]{String.format("mkdir -p %s/logs", this.getRunDir()), String.format("nohup sleep 100000 > %s 2>&1 < /dev/null &", this.getLogFileLocation())}).execute();
            } else {
                this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append(new CharSequence[]{String.format("cd %s", this.getRunDir()), "echo skipping exec of requireExecutable ./sbin/nginx", SimulatedNginxSshDriver.sudoBashCIfPrivilegedPort((int)this.getPort(), (String)String.format("echo skipping exec of nohup ./sbin/nginx -p %s/ -c conf/server.conf > %s 2>&1 &", this.getRunDir(), this.getLogFileLocation())), String.format("nohup sleep 100000 > %s 2>&1 < /dev/null &", this.getLogFileLocation()), String.format("echo $! > " + this.getPidFile(), new Object[0]), String.format("for i in {1..10}\ndo\n    test -f %1$s && ps -p `cat %1$s` && exit\n    sleep 1\ndone\necho \"No explicit error launching nginx but couldn't find process by pid; continuing but may subsequently fail\"\ncat %2$s | tee /dev/stderr", this.getPidFile(), this.getLogFileLocation())}).execute();
            }
        }

        public void stop() {
            this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "stopping").execute();
        }
    }
}

