/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.qa.load;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.database.mysql.MySqlNode;
import brooklyn.entity.database.mysql.MySqlNodeImpl;
import brooklyn.entity.database.mysql.MySqlSshDriver;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.function.FunctionFeed;
import brooklyn.event.feed.function.FunctionPollConfig;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.TaskFactory;
import brooklyn.qa.load.SimulatedTheeTierApp;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.time.CountdownTimer;
import brooklyn.util.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;

public class SimulatedMySqlNodeImpl
extends MySqlNodeImpl {
    public static final ConfigKey<Boolean> SIMULATE_ENTITY = SimulatedTheeTierApp.SIMULATE_ENTITY;
    public static final ConfigKey<Boolean> SIMULATE_EXTERNAL_MONITORING = SimulatedTheeTierApp.SIMULATE_EXTERNAL_MONITORING;
    public static final ConfigKey<Boolean> SKIP_SSH_ON_START = SimulatedTheeTierApp.SKIP_SSH_ON_START;
    private FunctionFeed feed;

    public Class<?> getDriverInterface() {
        return SimulatedMySqlSshDriver.class;
    }

    protected void connectSensors() {
        boolean simulateExternalMonitoring = (Boolean)this.getConfig(SIMULATE_EXTERNAL_MONITORING);
        if (simulateExternalMonitoring) {
            this.setAttribute(DATASTORE_URL, String.format("mysql://%s:%s/", this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)MYSQL_PORT)));
            this.feed = FunctionFeed.builder().entity((EntityLocal)this).period(Duration.FIVE_SECONDS).poll((FunctionPollConfig)new FunctionPollConfig(SERVICE_UP).callable((Callable)new Callable<Boolean>(){
                private int counter = 0;

                @Override
                public Boolean call() {
                    SimulatedMySqlNodeImpl.this.setAttribute(MySqlNode.QUERIES_PER_SECOND_FROM_MYSQL, this.counter++ % 100);
                    return true;
                }
            }).setOnFailureOrException((Object)false)).build();
        } else {
            super.connectSensors();
        }
    }

    public static class SimulatedMySqlSshDriver
    extends MySqlSshDriver {
        private int counter = 0;

        public SimulatedMySqlSshDriver(SimulatedMySqlNodeImpl entity, SshMachineLocation machine) {
            super((MySqlNodeImpl)entity, machine);
        }

        public String getStatusCmd() {
            if (((Boolean)this.entity.getConfig(SIMULATE_ENTITY)).booleanValue()) {
                return "echo Uptime: 2427  Threads: 1  Questions: 581  Slow queries: 0  Opens: 53  Flush tables: 1  Open tables: 35  Queries per second avg: " + this.counter++ % 100;
            }
            return super.getStatusCmd();
        }

        public void install() {
            if (!((Boolean)this.entity.getConfig(SKIP_SSH_ON_START)).booleanValue()) {
                super.install();
            }
        }

        public void customize() {
            if (!((Boolean)this.entity.getConfig(SIMULATE_ENTITY)).booleanValue()) {
                super.customize();
                return;
            }
            if (!((Boolean)this.entity.getConfig(SKIP_SSH_ON_START)).booleanValue()) {
                this.copyDatabaseConfigScript();
                this.newScript((String)"customizing").updateTaskAndFailOnNonZeroResultCode().body.append(new CharSequence[]{"chmod 600 " + this.getConfigFile(), this.getBaseDir() + "/scripts/mysql_install_db " + "--basedir=" + this.getBaseDir() + " --datadir=" + this.getDataDir() + " " + "--defaults-file=" + this.getConfigFile()}).execute();
                this.launch();
                CountdownTimer timer = Duration.seconds((Number)20).countdownTimer();
                boolean hasCreationScript = this.copyDatabaseCreationScript();
                timer.waitForExpiryUnchecked();
                DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd " + this.getRunDir(), "echo skipping exec of " + this.getBaseDir() + "/bin/mysqladmin --defaults-file=" + this.getConfigFile() + " --password= password " + this.getPassword()}).summary("setting password"));
                if (hasCreationScript) {
                    this.executeScriptFromInstalledFileAsync("creation-script.sql");
                }
                this.stop();
            }
        }

        public void launch() {
            if (!((Boolean)this.entity.getConfig(SIMULATE_ENTITY)).booleanValue()) {
                super.launch();
                return;
            }
            this.entity.setAttribute(MySqlNode.PID_FILE, (Object)(this.getRunDir() + "/" + "pid.txt"));
            if (((Boolean)this.entity.getConfig(SKIP_SSH_ON_START)).booleanValue()) {
                this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)true)), (String)"launching").body.append((CharSequence)String.format("nohup sleep 100000 > %s 2>&1 < /dev/null &", this.getLogFile())).execute();
            } else {
                this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)true)), (String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)String.format((String)"echo skipping normal exec of nohup %s/bin/mysqld --defaults-file=%s --user=`whoami` > %s 2>&1 < /dev/null &", (Object[])new Object[]{this.getBaseDir(), this.getConfigFile(), this.getLogFile()})).body.append((CharSequence)String.format("nohup sleep 100000 > %s 2>&1 < /dev/null &", this.getLogFile())).execute();
            }
        }

        public ProcessTaskWrapper<Integer> executeScriptFromInstalledFileAsync(String filenameAlreadyInstalledAtServer) {
            return (ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd " + this.getRunDir(), "echo skipping exec of " + this.getBaseDir() + "/bin/mysql --defaults-file=" + this.getConfigFile() + " < " + filenameAlreadyInstalledAtServer}).summary("executing datastore script " + filenameAlreadyInstalledAtServer));
        }
    }
}

