/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.qa.load;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.Enrichers;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.webapp.WebAppServiceMetrics;
import brooklyn.entity.webapp.jboss.JBoss7ServerImpl;
import brooklyn.entity.webapp.jboss.JBoss7SshDriver;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.function.FunctionFeed;
import brooklyn.event.feed.function.FunctionPollConfig;
import brooklyn.event.feed.http.HttpFeed;
import brooklyn.event.feed.http.HttpPollConfig;
import brooklyn.event.feed.http.HttpValueFunctions;
import brooklyn.location.access.BrooklynAccessUtils;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.qa.load.SimulatedTheeTierApp;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.guava.Functionals;
import brooklyn.util.os.Os;
import com.google.common.base.Function;
import com.google.common.net.HostAndPort;
import java.util.Map;
import java.util.concurrent.Callable;

public class SimulatedJBoss7ServerImpl
extends JBoss7ServerImpl {
    public static final ConfigKey<Boolean> SIMULATE_ENTITY = SimulatedTheeTierApp.SIMULATE_ENTITY;
    public static final ConfigKey<Boolean> SIMULATE_EXTERNAL_MONITORING = SimulatedTheeTierApp.SIMULATE_EXTERNAL_MONITORING;
    public static final ConfigKey<Boolean> SKIP_SSH_ON_START = SimulatedTheeTierApp.SKIP_SSH_ON_START;
    private HttpFeed httpFeed;
    private FunctionFeed functionFeed;

    public Class<?> getDriverInterface() {
        return SimulatedJBoss7SshDriver.class;
    }

    protected void connectSensors() {
        boolean simulateEntity = (Boolean)this.getConfig(SIMULATE_ENTITY);
        boolean simulateExternalMonitoring = (Boolean)this.getConfig(SIMULATE_EXTERNAL_MONITORING);
        if (!simulateEntity && !simulateExternalMonitoring) {
            super.connectSensors();
            return;
        }
        HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)((Integer)this.getAttribute((AttributeSensor)MANAGEMENT_HTTP_PORT) + (Integer)this.getConfig(PORT_INCREMENT)));
        String managementUri = String.format("http://%s:%s/management/subsystem/web/connector/http/read-resource", hp.getHostText(), hp.getPort());
        this.setAttribute(MANAGEMENT_URL, managementUri);
        if (simulateExternalMonitoring) {
            this.setAttribute(SERVICE_PROCESS_IS_RUNNING, true);
        } else {
            String uriToPoll = simulateEntity ? "http://localhost:8081" : managementUri;
            this.httpFeed = HttpFeed.builder().entity((EntityLocal)this).period(200L).baseUri(uriToPoll).credentials((String)this.getConfig(MANAGEMENT_USER), (String)this.getConfig(MANAGEMENT_PASSWORD)).poll((HttpPollConfig)new HttpPollConfig(MANAGEMENT_STATUS).onSuccess(HttpValueFunctions.responseCode())).build();
            this.connectServiceUpIsRunning();
        }
        this.functionFeed = FunctionFeed.builder().entity((EntityLocal)this).period(5000L).poll(new FunctionPollConfig(MANAGEMENT_URL_UP).callable((Callable)new Callable<Boolean>(){
            private int counter = 0;

            @Override
            public Boolean call() {
                SimulatedJBoss7ServerImpl.this.setAttribute(WebAppServiceMetrics.REQUEST_COUNT, this.counter++ % 100);
                SimulatedJBoss7ServerImpl.this.setAttribute((AttributeSensor)WebAppServiceMetrics.ERROR_COUNT, this.counter++ % 100);
                SimulatedJBoss7ServerImpl.this.setAttribute(WebAppServiceMetrics.TOTAL_PROCESSING_TIME, this.counter++ % 100);
                SimulatedJBoss7ServerImpl.this.setAttribute(WebAppServiceMetrics.MAX_PROCESSING_TIME, this.counter++ % 100);
                SimulatedJBoss7ServerImpl.this.setAttribute(WebAppServiceMetrics.BYTES_RECEIVED, this.counter++ % 100);
                SimulatedJBoss7ServerImpl.this.setAttribute(WebAppServiceMetrics.BYTES_SENT, this.counter++ % 100);
                return true;
            }
        })).build();
        this.addEnricher(((Enrichers.UpdatingMapBuilder)Enrichers.builder().updatingMap(Attributes.SERVICE_NOT_UP_INDICATORS).from(MANAGEMENT_URL_UP).computing((Function)Functionals.ifNotEquals((Object)true).value((Object)"Management URL not reachable"))).build());
    }

    protected void disconnectSensors() {
        super.disconnectSensors();
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        if (this.functionFeed != null) {
            this.functionFeed.stop();
        }
    }

    public static class SimulatedJBoss7SshDriver
    extends JBoss7SshDriver {
        public SimulatedJBoss7SshDriver(SimulatedJBoss7ServerImpl entity, SshMachineLocation machine) {
            super((JBoss7ServerImpl)entity, machine);
        }

        public boolean isRunning() {
            if (((Boolean)this.entity.getConfig(SKIP_SSH_ON_START)).booleanValue()) {
                return true;
            }
            return super.isRunning();
        }

        public void install() {
            if (!((Boolean)this.entity.getConfig(SKIP_SSH_ON_START)).booleanValue()) {
                super.install();
            }
        }

        public void customize() {
            if (!((Boolean)this.entity.getConfig(SKIP_SSH_ON_START)).booleanValue()) {
                super.customize();
            }
        }

        public void launch() {
            if (!((Boolean)this.entity.getConfig(SIMULATE_ENTITY)).booleanValue()) {
                super.launch();
                return;
            }
            String pidFile = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "pid.txt"});
            if (((Boolean)this.entity.getConfig(SKIP_SSH_ON_START)).booleanValue()) {
                this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)pidFile), (String)"launching").body.append((CharSequence)String.format("nohup sleep 100000 > %s/console 2>&1 < /dev/null &", this.getRunDir())).execute();
            } else {
                this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append(new CharSequence[]{"export LAUNCH_JBOSS_IN_BACKGROUND=true", String.format("export JBOSS_HOME=%s", this.getExpandedInstallDir()), String.format("export JBOSS_PIDFILE=%s/%s", this.getRunDir(), "pid.txt"), String.format("echo skipping exec of %s/bin/%s.sh ", this.getExpandedInstallDir(), "standalone") + String.format("--server-config %s ", "standalone-brooklyn.xml") + String.format("-Djboss.server.base.dir=%s/%s ", this.getRunDir(), "standalone") + String.format("\"-Djboss.server.base.url=file://%s/%s\" ", this.getRunDir(), "standalone") + "-Djava.net.preferIPv4Stack=true " + "-Djava.net.preferIPv6Addresses=false " + String.format(" >> %s/console 2>&1 </dev/null &", this.getRunDir()), String.format("nohup sleep 100000 > %s/console 2>&1 < /dev/null &", this.getRunDir()), String.format("echo $! > " + pidFile, new Object[0]), String.format("echo starting > %s/console", this.getRunDir()), "for i in {1..10}\ndo\n    grep -i 'starting' " + this.getRunDir() + "/console && exit\n" + "    sleep 1\n" + "done\n" + "echo \"Couldn't determine if process is running (console output does not contain 'starting'); continuing but may subsequently fail\""}).execute();
            }
        }
    }
}

