/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.qa.longevity.webcluster;

import brooklyn.config.BrooklynProperties;
import brooklyn.enricher.Enrichers;
import brooklyn.entity.basic.AbstractApplication;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.StartableApplication;
import brooklyn.entity.proxy.nginx.NginxController;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.webapp.ControlledDynamicWebAppCluster;
import brooklyn.entity.webapp.jboss.JBoss7Server;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.launcher.BrooklynLauncher;
import brooklyn.policy.EnricherSpec;
import brooklyn.policy.Policy;
import brooklyn.policy.autoscaling.AutoScalerPolicy;
import brooklyn.qa.longevity.webcluster.SinusoidalLoadGenerator;
import brooklyn.util.CommandLineUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class WebClusterApp
extends AbstractApplication {
    static BrooklynProperties config = BrooklynProperties.Factory.newDefault();
    public static final String WAR_PATH = "classpath://hello-world.war";
    private static final long loadCyclePeriodMs = 120000L;

    public void initApp() {
        AttributeSensor sinusoidalLoad = Sensors.newDoubleSensor((String)"brooklyn.qa.sinusoidalLoad", (String)"Sinusoidal server load");
        AttributeSensor averageLoad = Sensors.newDoubleSensor((String)"brooklyn.qa.averageLoad", (String)"Average load in cluster");
        NginxController nginxController = (NginxController)this.addChild(EntitySpec.create(NginxController.class).configure((CharSequence)"port", (Object)"8000+"));
        EntitySpec jbossSpec = EntitySpec.create(JBoss7Server.class).configure((CharSequence)"httpPort", (Object)"8080+").configure((CharSequence)"war", (Object)WAR_PATH).enricher(EnricherSpec.create(SinusoidalLoadGenerator.class).configure(SinusoidalLoadGenerator.TARGET, (Object)sinusoidalLoad).configure(SinusoidalLoadGenerator.PUBLISH_PERIOD_MS, (Object)500L).configure(SinusoidalLoadGenerator.SIN_PERIOD_MS, (Object)120000L).configure(SinusoidalLoadGenerator.SIN_AMPLITUDE, (Object)1.0));
        ControlledDynamicWebAppCluster web = (ControlledDynamicWebAppCluster)this.addChild(((EntitySpec)EntitySpec.create(ControlledDynamicWebAppCluster.class).displayName("WebApp cluster")).configure((CharSequence)"controller", (Object)nginxController).configure((CharSequence)"initialSize", (Object)1).configure((CharSequence)"memberSpec", (Object)jbossSpec));
        web.getCluster().addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(sinusoidalLoad).publishing(averageLoad).fromMembers()).computingAverage()).build());
        web.getCluster().addPolicy((Policy)AutoScalerPolicy.builder().metric(averageLoad).sizeRange(1, 3).metricRange((Number)0.3, (Number)0.7).build());
    }

    public static void main(String[] argv) {
        ArrayList args = Lists.newArrayList((Object[])argv);
        String port = CommandLineUtil.getCommandLineOption((List)args, (String)"--port", (String)"8081+");
        String location = CommandLineUtil.getCommandLineOption((List)args, (String)"--location", (String)"localhost");
        BrooklynLauncher launcher = BrooklynLauncher.newInstance().application((EntitySpec)EntitySpec.create(StartableApplication.class, WebClusterApp.class).displayName("Brooklyn WebApp Cluster example")).webconsolePort(port).location(location).start();
        Entities.dumpInfo((Iterable)launcher.getApplications());
    }
}

