/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.qa.longevity.webcluster;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.AttributeSensor;
import com.google.common.base.Throwables;
import com.google.common.reflect.TypeToken;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinusoidalLoadGenerator
extends AbstractEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(SinusoidalLoadGenerator.class);
    public static final ConfigKey<AttributeSensor<Double>> TARGET = ConfigKeys.newConfigKey((TypeToken)new TypeToken<AttributeSensor<Double>>(){}, (String)"target");
    public static final ConfigKey<Long> PUBLISH_PERIOD_MS = ConfigKeys.newLongConfigKey((String)"publishPeriodMs");
    public static final ConfigKey<Long> SIN_PERIOD_MS = ConfigKeys.newLongConfigKey((String)"sinPeriodMs");
    public static final ConfigKey<Double> SIN_AMPLITUDE = ConfigKeys.newDoubleConfigKey((String)"sinAmplitude");
    private final ScheduledExecutorService executor;

    public SinusoidalLoadGenerator() {
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public SinusoidalLoadGenerator(AttributeSensor<Double> target, long publishPeriodMs, long sinPeriodMs, double sinAmplitude) {
        this.config().set(TARGET, target);
        this.config().set(PUBLISH_PERIOD_MS, (Object)publishPeriodMs);
        this.config().set(SIN_PERIOD_MS, (Object)sinPeriodMs);
        this.config().set(SIN_AMPLITUDE, (Object)sinAmplitude);
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public void setEntity(final EntityLocal entity) {
        super.setEntity(entity);
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    long time = System.currentTimeMillis();
                    double val = (Double)SinusoidalLoadGenerator.this.getRequiredConfig(SIN_AMPLITUDE) * (1.0 + Math.sin(1.0 * (double)time / (double)((Long)SinusoidalLoadGenerator.this.getRequiredConfig(SIN_PERIOD_MS)).longValue() * Math.PI * 2.0 - 1.5707963267948966)) / 2.0;
                    entity.setAttribute((AttributeSensor)SinusoidalLoadGenerator.this.getRequiredConfig(TARGET), (Object)val);
                }
                catch (Throwable t) {
                    LOG.warn("Error generating sinusoidal-load metric", t);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        }, 0L, (Long)this.getRequiredConfig(PUBLISH_PERIOD_MS), TimeUnit.MILLISECONDS);
    }

    public void destroy() {
        this.executor.shutdownNow();
    }
}

