/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.qa.longevity;

import brooklyn.qa.longevity.MonitorUtils;
import brooklyn.util.os.Os;
import brooklyn.util.text.Strings;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MonitorUtilsTest {
    @Test(enabled=false, timeOut=1000L)
    public void testExecuteAndWaitFor() throws Exception {
        Process process = this.createDumpingProcess(false);
        process.waitFor();
        Assert.fail((String)"Should block while waiting to consume process output");
    }

    @Test(enabled=false, timeOut=1000L)
    public void testExecuteAndWaitForErr() throws Exception {
        Process process = this.createDumpingProcess(true);
        process.waitFor();
        Assert.fail((String)"Should block while waiting to consume process output");
    }

    @Test(timeOut=1000L)
    public void testExecuteAndWaitForConsumingOutputStream() throws Exception {
        Process process = this.createDumpingProcess(false);
        String out = MonitorUtils.waitFor((Process)process);
        Assert.assertTrue((out.length() > 100000 ? 1 : 0) != 0, (String)("out.size=" + out.length()));
    }

    @Test(timeOut=1000L, expectedExceptions={IllegalStateException.class})
    public void testExecuteAndWaitForConsumingErrorStream() throws Exception {
        Process process = this.createDumpingProcess(true);
        MonitorUtils.waitFor((Process)process);
    }

    private Process createDumpingProcess(boolean writeToErr) throws IOException {
        String errSuffix = writeToErr ? " >&2" : "";
        String bigstr = Strings.repeat((String)"a", (int)8000);
        String bigcmd = Strings.repeat((String)(this.getSilentPrefix() + "echo " + bigstr + errSuffix + Os.LINE_SEPARATOR), (int)15);
        File file = Os.newTempFile((String)"test-consume", (String)".bat");
        file.setExecutable(true);
        Files.write((CharSequence)bigcmd, (File)file, (Charset)Charsets.UTF_8);
        Process process = MonitorUtils.exec((String)file.getAbsolutePath());
        return process;
    }

    @Test(groups={"UNIX"})
    public void testFindOwnPid() throws Exception {
        int ownpid = MonitorUtils.findOwnPid();
        Assert.assertTrue((ownpid > 0 ? 1 : 0) != 0, (String)"ownpid=$ownpid");
        Assert.assertTrue((boolean)MonitorUtils.isPidRunning((int)ownpid, (String)"java"), (String)"java is not running");
    }

    @Test(groups={"UNIX"})
    public void testIsPidRunning() throws Exception {
        int usedPid = MonitorUtils.findOwnPid();
        String[] cmd = new String[]{"bash", "-c", "echo $$"};
        Process process = Runtime.getRuntime().exec(cmd);
        String out = MonitorUtils.waitFor((Process)process);
        int unusedPid = Integer.parseInt(out.trim());
        Assert.assertTrue((boolean)MonitorUtils.isPidRunning((int)usedPid));
        Assert.assertFalse((boolean)MonitorUtils.isPidRunning((int)unusedPid));
        try {
            Assert.assertFalse((boolean)MonitorUtils.isPidRunning((int)1234567));
        }
        catch (MonitorUtils.ProcessHasStderr e) {
            // empty catch block
        }
    }

    @Test(groups={"UNIX"})
    public void testGetRunningPids() throws Exception {
        int ownpid = MonitorUtils.findOwnPid();
        List javapids = MonitorUtils.getRunningPids((String)"java");
        Assert.assertTrue((boolean)javapids.contains(ownpid), (String)("javapids=" + javapids + "; ownpid=" + ownpid));
    }

    @Test
    public void testIsUrlUp() throws Exception {
        Assert.assertFalse((boolean)MonitorUtils.isUrlUp((URL)new URL("http://localhost/thispathdoesnotexist")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"UNIX"})
    public void testSearchLog() throws Exception {
        String fileContents = "line1\nline2\nline3\n";
        File file = File.createTempFile("monitorUtilsTest.testSearchLog", ".txt");
        Files.write((CharSequence)fileContents, (File)file, (Charset)Charsets.UTF_8);
        try {
            Assert.assertEquals((Collection)MonitorUtils.searchLog((File)file, (String)"line1"), Arrays.asList("line1"));
            Assert.assertEquals((Collection)MonitorUtils.searchLog((File)file, (String)"line1|line2"), Arrays.asList("line1", "line2"));
            Assert.assertEquals((Collection)MonitorUtils.searchLog((File)file, (String)"textnotthere"), Collections.emptyList());
            Assert.assertEquals((Collection)MonitorUtils.searchLog((File)file, (String)"line"), Arrays.asList("line1", "line2", "line3"));
        }
        finally {
            file.delete();
        }
    }

    @Test(groups={"Integration"})
    public void testMemoryUsage() throws Exception {
        int ownpid = MonitorUtils.findOwnPid();
        MonitorUtils.MemoryUsage memUsage = MonitorUtils.getMemoryUsage((int)ownpid);
        Assert.assertTrue((memUsage.totalInstances > 0L ? 1 : 0) != 0, (String)memUsage.toString());
        Assert.assertTrue((memUsage.totalMemoryBytes > 0L ? 1 : 0) != 0, (String)memUsage.toString());
        Assert.assertEquals((Map)memUsage.getInstanceCounts(), Collections.emptyMap());
        MonitorUtils.MemoryUsage memUsage2 = MonitorUtils.getMemoryUsage((int)ownpid, (String)MonitorUtilsTest.class.getCanonicalName(), (int)0);
        Assert.assertEquals((Map)memUsage2.getInstanceCounts(), (Map)ImmutableMap.of((Object)MonitorUtilsTest.class.getCanonicalName(), (Object)1));
        MonitorUtils.MemoryUsage memUsage3 = MonitorUtils.getMemoryUsage((int)ownpid, (String)MonitorUtilsTest.class.getCanonicalName(), (int)2);
        Assert.assertEquals((Map)memUsage3.getInstanceCounts(), Collections.emptyMap());
    }

    private String getSilentPrefix() {
        if (Os.isMicrosoftWindows()) {
            return "@";
        }
        return "";
    }
}

