/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.qa.load;

import brooklyn.entity.Application;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.StartableApplication;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.rebind.persister.PersistMode;
import brooklyn.entity.trait.Startable;
import brooklyn.launcher.BrooklynLauncher;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.management.ha.HighAvailabilityMode;
import brooklyn.management.internal.LocalManagementContext;
import brooklyn.qa.load.SimulatedTheeTierApp;
import brooklyn.test.PerformanceTestUtils;
import brooklyn.util.os.Os;
import brooklyn.util.time.Duration;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LoadTest {
    private static final Logger LOG = LoggerFactory.getLogger(LoadTest.class);
    private File persistenceDir;
    private BrooklynLauncher launcher;
    private String webServerUrl;
    private ManagementContext managementContext;
    private ListeningExecutorService executor;
    private Future<?> cpuFuture;
    private Location localhost;
    List<Duration> provisioningTimes;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.persistenceDir = Files.createTempDir();
        this.launcher = BrooklynLauncher.newInstance().persistMode(PersistMode.CLEAN).highAvailabilityMode(HighAvailabilityMode.MASTER).persistenceDir(this.persistenceDir).start();
        this.webServerUrl = this.launcher.getServerDetails().getWebServerUrl();
        this.managementContext = this.launcher.getServerDetails().getManagementContext();
        this.localhost = this.managementContext.getLocationRegistry().resolve("localhost");
        this.provisioningTimes = Collections.synchronizedList(Lists.newArrayList());
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        this.executor.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    while (true) {
                        LoadTest.this.managementContext.getExecutionManager();
                        String usage = ((LocalManagementContext)LoadTest.this.managementContext).getGarbageCollector().getUsageString();
                        LOG.info("LoadTest using " + usage);
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    LOG.error("Error getting usage info", (Throwable)e);
                }
                return null;
            }
        });
        this.cpuFuture = PerformanceTestUtils.sampleProcessCpuTime((Duration)Duration.ONE_SECOND, (String)"during testProvisionAppsConcurrently");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cpuFuture != null) {
            this.cpuFuture.cancel(true);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.launcher != null) {
            this.launcher.terminate();
        }
        if (this.persistenceDir != null) {
            Os.deleteRecursively((File)this.persistenceDir);
        }
    }

    @Test(groups={"Acceptance"})
    public void testLocalhostProvisioningAppsConcurrently() throws Exception {
        int NUM_CONCURRENT_APPS_PROVISIONING = 20;
        ArrayList futures = Lists.newArrayList();
        for (int i = 0; i < 20; ++i) {
            ListenableFuture future = this.executor.submit(this.newProvisionAppTask(this.managementContext, (EntitySpec)EntitySpec.create(StartableApplication.class, SimulatedTheeTierApp.class).configure(SimulatedTheeTierApp.SIMULATE_EXTERNAL_MONITORING, (Object)true).displayName("Simulated app " + i)));
            futures.add(future);
        }
        List apps = (List)Futures.allAsList((Iterable)futures).get();
        for (StartableApplication app : apps) {
            Assert.assertEquals((Object)app.getAttribute(Startable.SERVICE_UP), (Object)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Acceptance"})
    public void testLocalhostManyApps() throws Exception {
        int NUM_APPS = 630;
        int NUM_APPS_PER_BATCH = 10;
        int SLEEP_BETWEEN_BATCHES = 10000;
        boolean SKIP_SSH_ON_START = true;
        int counter = 0;
        for (int i = 0; i < 63; ++i) {
            ArrayList futures = Lists.newArrayList();
            for (int j = 0; j < 10; ++j) {
                ListenableFuture future = this.executor.submit(this.newProvisionAppTask(this.managementContext, (EntitySpec)EntitySpec.create(StartableApplication.class, SimulatedTheeTierApp.class).configure(SimulatedTheeTierApp.SIMULATE_EXTERNAL_MONITORING, (Object)true).configure(SimulatedTheeTierApp.SKIP_SSH_ON_START, (Object)true).displayName("Simulated app " + ++counter)));
                futures.add(future);
            }
            List apps = (List)Futures.allAsList((Iterable)futures).get();
            for (StartableApplication app : apps) {
                Assert.assertEquals((Object)app.getAttribute(Startable.SERVICE_UP), (Object)true);
            }
            List<Duration> list = this.provisioningTimes;
            synchronized (list) {
                LOG.info("cycle=" + i + "; numApps=" + counter + ": provisioning times: " + this.provisioningTimes);
                this.provisioningTimes.clear();
            }
            LOG.info("cycle=" + i + "; numApps=" + counter + ": sleeping before next batch of apps");
            Thread.sleep(10000L);
        }
    }

    protected <T extends StartableApplication> Callable<T> newProvisionAppTask(final ManagementContext managementContext, final EntitySpec<T> entitySpec) {
        return new Callable<T>(){

            @Override
            public T call() {
                Stopwatch stopwatch = Stopwatch.createStarted();
                StartableApplication app = (StartableApplication)managementContext.getEntityManager().createEntity(entitySpec);
                Entities.startManagement((Application)app, (ManagementContext)managementContext);
                app.start((Collection)ImmutableList.of((Object)LoadTest.this.localhost));
                Duration duration = Duration.of((long)stopwatch.elapsed(TimeUnit.MILLISECONDS), (TimeUnit)TimeUnit.MILLISECONDS);
                LOG.info("Provisioning time: " + duration);
                LoadTest.this.provisioningTimes.add(duration);
                return app;
            }
        };
    }
}

