/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.ha;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.sensor.BasicNotificationSensor;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.policy.ha.AbstractFailureDetector;
import org.apache.brooklyn.policy.ha.HASensors;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Ssh Connectivity Failure Detector", description="HA policy for monitoring an SshMachine, emitting an event if the connection is lost/restored")
public class SshMachineFailureDetector
extends AbstractFailureDetector {
    private static final Logger LOG = LoggerFactory.getLogger(SshMachineFailureDetector.class);
    public static final String DEFAULT_UNIQUE_TAG = "failureDetector.sshMachine.tag";
    public static final BasicNotificationSensor<HASensors.FailureDescriptor> CONNECTION_FAILED = HASensors.CONNECTION_FAILED;
    public static final BasicNotificationSensor<HASensors.FailureDescriptor> CONNECTION_RECOVERED = HASensors.CONNECTION_RECOVERED;
    public static final ConfigKey<Duration> CONNECT_TIMEOUT = ConfigKeys.newDurationConfigKey((String)"ha.sshConnection.timeout", (String)"How long to wait for conneciton before declaring failure", (Duration)Duration.TEN_SECONDS);

    public void init() {
        super.init();
        if (this.config().getRaw(SENSOR_FAILED).isAbsent()) {
            this.config().set(SENSOR_FAILED, CONNECTION_FAILED);
        }
        if (this.config().getRaw(SENSOR_RECOVERED).isAbsent()) {
            this.config().set(SENSOR_RECOVERED, CONNECTION_RECOVERED);
        }
        if (this.config().getRaw(POLL_PERIOD).isAbsent()) {
            this.config().set(POLL_PERIOD, (Object)Duration.ONE_MINUTE);
        }
        this.uniqueTag = DEFAULT_UNIQUE_TAG;
    }

    @Override
    protected AbstractFailureDetector.CalculatedStatus calculateStatus() {
        Maybe sshMachineOption = Machines.findUniqueSshMachineLocation((Iterable)this.entity.getLocations());
        if (sshMachineOption.isPresent()) {
            SshMachineLocation sshMachine = (SshMachineLocation)sshMachineOption.get();
            try {
                Duration timeout = (Duration)this.config().get(CONNECT_TIMEOUT);
                ImmutableMap flags = ImmutableMap.of((Object)SshTool.PROP_CONNECT_TIMEOUT.getName(), (Object)timeout.toMilliseconds(), (Object)SshTool.PROP_SESSION_TIMEOUT.getName(), (Object)timeout.toMilliseconds(), (Object)SshTool.PROP_SSH_TRIES.getName(), (Object)1);
                int exitCode = sshMachine.execCommands((Map)flags, SshMachineFailureDetector.class.getName(), (List)ImmutableList.of((Object)"exit"));
                return new AbstractFailureDetector.BasicCalculatedStatus(exitCode == 0, sshMachine.toString());
            }
            catch (Exception e) {
                boolean isFirstFailure;
                Exceptions.propagateIfFatal((Throwable)e);
                boolean bl = isFirstFailure = this.lastPublished != AbstractFailureDetector.LastPublished.FAILED && this.currentFailureStartTime == null;
                if (isFirstFailure) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed connecting to machine " + sshMachine, (Throwable)e);
                    }
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace("Failed connecting to machine " + sshMachine, (Throwable)e);
                }
                return new AbstractFailureDetector.BasicCalculatedStatus(false, e.getMessage());
            }
        }
        return new AbstractFailureDetector.BasicCalculatedStatus(true, "no machine started, not complaining");
    }
}

