/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.ha;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.core.sensor.BasicNotificationSensor;
import org.apache.brooklyn.policy.ha.HASensors;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Service Restarter", description="HA policy for restarting a service automatically, and for emitting an events if the service repeatedly fails")
public class ServiceRestarter
extends AbstractPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceRestarter.class);
    public static final BasicNotificationSensor<HASensors.FailureDescriptor> ENTITY_RESTART_FAILED = new BasicNotificationSensor(HASensors.FailureDescriptor.class, "ha.entityFailed.restart", "Indicates that an entity restart attempt has failed");
    @SetFromFlag(value="failOnRecurringFailuresInThisDuration")
    public static final ConfigKey<Duration> FAIL_ON_RECURRING_FAILURES_IN_THIS_DURATION = ConfigKeys.newConfigKey(Duration.class, (String)"failOnRecurringFailuresInThisDuration", (String)"Reports entity as failed if it fails two or more times in this time window", (Object)Duration.minutes((Number)3));
    @SetFromFlag(value="setOnFireOnFailure")
    public static final ConfigKey<Boolean> SET_ON_FIRE_ON_FAILURE = ConfigKeys.newBooleanConfigKey((String)"setOnFireOnFailure", (String)"", (Boolean)true);
    @SetFromFlag(value="failureSensorToMonitor")
    public static final ConfigKey<Sensor<?>> FAILURE_SENSOR_TO_MONITOR = ConfigKeys.newConfigKey(Sensor.class, (String)"failureSensorToMonitor", (String)"", HASensors.ENTITY_FAILED);
    protected final AtomicReference<Long> lastFailureTime = new AtomicReference();

    public ServiceRestarter() {
        this(new ConfigBag());
    }

    public ServiceRestarter(Map<String, ?> flags) {
        this(new ConfigBag().putAll(flags));
    }

    public ServiceRestarter(ConfigBag configBag) {
        super(configBag.getAllConfigMutable());
        this.uniqueTag = JavaClassNames.simpleClassName(((Object)((Object)this)).getClass()) + ":" + ((Sensor)this.getConfig(FAILURE_SENSOR_TO_MONITOR)).getName();
    }

    public ServiceRestarter(Sensor<?> failureSensorToMonitor) {
        this(new ConfigBag().configure(FAILURE_SENSOR_TO_MONITOR, failureSensorToMonitor));
    }

    public void setEntity(final EntityLocal entity) {
        Preconditions.checkArgument((boolean)(entity instanceof Startable), (Object)("Restarter must take a Startable, not " + entity));
        super.setEntity(entity);
        this.subscribe((Entity)entity, (Sensor)this.getConfig(FAILURE_SENSOR_TO_MONITOR), (SensorEventListener)new SensorEventListener<Object>(){

            public void onEvent(final SensorEvent<Object> event) {
                if (ServiceRestarter.this.isRunning()) {
                    LOG.info("ServiceRestarter notified; dispatching job for " + entity + " (" + event.getValue() + ")");
                    ((EntityInternal)entity).getExecutionContext().submit((Map)MutableMap.of(), new Runnable(){

                        @Override
                        public void run() {
                            ServiceRestarter.this.onDetectedFailure((SensorEvent<Object>)event);
                        }
                    });
                } else {
                    LOG.warn("ServiceRestarter not running, so not acting on failure detected at " + entity + " (" + event.getValue() + ")");
                }
            }
        });
    }

    protected synchronized void onDetectedFailure(SensorEvent<Object> event) {
        long elapsed;
        if (this.isSuspended()) {
            LOG.warn("ServiceRestarter suspended, so not acting on failure detected at " + this.entity + " (" + event.getValue() + ")");
            return;
        }
        LOG.warn("ServiceRestarter acting on failure detected at " + this.entity + " (" + event.getValue() + ")");
        long current = System.currentTimeMillis();
        Long last = this.lastFailureTime.getAndSet(current);
        long l = elapsed = last == null ? -1L : current - last;
        if (elapsed >= 0L && elapsed <= ((Duration)this.getConfig(FAIL_ON_RECURRING_FAILURES_IN_THIS_DURATION)).toMilliseconds()) {
            this.onRestartFailed("Restart failure (failed again after " + Time.makeTimeStringRounded((long)elapsed) + ") at " + this.entity + ": " + event.getValue());
            return;
        }
        try {
            ServiceStateLogic.setExpectedState((Entity)this.entity, (Lifecycle)Lifecycle.STARTING);
            Entities.invokeEffector((EntityLocal)this.entity, (Entity)this.entity, (Effector)Startable.RESTART).get();
        }
        catch (Exception e) {
            this.onRestartFailed("Restart failure (error " + e + ") at " + this.entity + ": " + event.getValue());
        }
    }

    protected void onRestartFailed(String msg) {
        LOG.warn("ServiceRestarter failed for " + this.entity + ": " + msg);
        if (((Boolean)this.getConfig(SET_ON_FIRE_ON_FAILURE)).booleanValue()) {
            ServiceStateLogic.setExpectedState((Entity)this.entity, (Lifecycle)Lifecycle.ON_FIRE);
        }
        this.entity.emit(ENTITY_RESTART_FAILED, (Object)new HASensors.FailureDescriptor(this.entity, msg));
    }
}

