/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.enricher;

import java.util.LinkedList;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.enricher.stock.AbstractTypeTransformingEnricher;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.javalang.JavaClassNames;

public class RollingMeanEnricher<T extends Number>
extends AbstractTypeTransformingEnricher<T, Double> {
    private LinkedList<T> values = new LinkedList();
    @SetFromFlag
    int windowSize;

    public RollingMeanEnricher() {
    }

    public RollingMeanEnricher(Entity producer, AttributeSensor<T> source, AttributeSensor<Double> target, int windowSize) {
        super(producer, source, target);
        this.windowSize = windowSize;
        if (source != null && target != null) {
            this.uniqueTag = JavaClassNames.simpleClassName(((Object)((Object)this)).getClass()) + ":" + source.getName() + "->" + target.getName();
        }
    }

    public Double getAverage() {
        this.pruneValues();
        return this.values.size() == 0 ? null : Double.valueOf(this.sum(this.values) / (double)this.values.size());
    }

    public void onEvent(SensorEvent<T> event) {
        this.values.addLast(event.getValue());
        this.pruneValues();
        this.entity.setAttribute((AttributeSensor)this.target, (Object)this.getAverage());
    }

    private void pruneValues() {
        while (this.windowSize > -1 && this.values.size() > this.windowSize) {
            this.values.removeFirst();
        }
    }

    private double sum(Iterable<? extends Number> vals) {
        double result = 0.0;
        for (Number number : vals) {
            result += number.doubleValue();
        }
        return result;
    }
}

