/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.autoscaling;

import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.TimeWindowedList;
import org.apache.brooklyn.util.collections.TimestampedValue;
import org.apache.brooklyn.util.time.Duration;

public class SizeHistory {
    private final TimeWindowedList<Number> recentDesiredResizes;

    public SizeHistory(long windowSize) {
        this.recentDesiredResizes = new TimeWindowedList((Map)MutableMap.of((Object)"timePeriod", (Object)windowSize, (Object)"minExpiredVals", (Object)1));
    }

    public void add(int val) {
        this.recentDesiredResizes.add((Object)val);
    }

    public void setWindowSize(Duration newWindowSize) {
        this.recentDesiredResizes.setTimePeriod(newWindowSize);
    }

    public WindowSummary summarizeWindow(Duration windowSize) {
        long now = System.currentTimeMillis();
        List windowVals = this.recentDesiredResizes.getValuesInWindow(now, windowSize);
        Object latestObj = this.latestInWindow(windowVals);
        long latest = latestObj == null ? -1L : ((Number)latestObj).longValue();
        long max = ((Number)this.maxInWindow(windowVals, windowSize)).longValue();
        long min = ((Number)this.minInWindow(windowVals, windowSize)).longValue();
        boolean stable = min == max;
        return new WindowSummary(latest, min, max, stable, stable);
    }

    private <T extends Number> T maxInWindow(List<TimestampedValue<T>> vals, Duration timeWindow) {
        long now = System.currentTimeMillis();
        long epoch = now - timeWindow.toMilliseconds();
        Number result = null;
        double resultAsDouble = 2.147483647E9;
        for (TimestampedValue<T> val : vals) {
            double valAsDouble;
            Number valAsNum = (Number)val.getValue();
            double d = valAsDouble = valAsNum != null ? valAsNum.doubleValue() : 0.0;
            if (result == null && val.getTimestamp() > epoch) {
                result = this.withDefault(null, Integer.MAX_VALUE);
                resultAsDouble = result.doubleValue();
            }
            if (result != null && (valAsNum == null || !(valAsDouble > resultAsDouble))) continue;
            result = valAsNum;
            resultAsDouble = valAsDouble;
        }
        return (T)((Number)this.withDefault(result, Integer.MAX_VALUE));
    }

    private <T extends Number> T minInWindow(List<TimestampedValue<T>> vals, Duration timeWindow) {
        long now = System.currentTimeMillis();
        long epoch = now - timeWindow.toMilliseconds();
        Number result = null;
        double resultAsDouble = -2.147483648E9;
        for (TimestampedValue<T> val : vals) {
            double valAsDouble;
            Number valAsNum = (Number)val.getValue();
            double d = valAsDouble = valAsNum != null ? valAsNum.doubleValue() : 0.0;
            if (result == null && val.getTimestamp() > epoch) {
                result = this.withDefault(null, Integer.MIN_VALUE);
                resultAsDouble = result.doubleValue();
            }
            if (result != null && (val.getValue() == null || !(valAsDouble < resultAsDouble))) continue;
            result = valAsNum;
            resultAsDouble = valAsDouble;
        }
        return (T)((Number)this.withDefault(result, Integer.MIN_VALUE));
    }

    private <T> T withDefault(T result, Integer defaultValue) {
        return (T)(result != null ? result : defaultValue);
    }

    private <T extends Number> T latestInWindow(List<TimestampedValue<T>> vals) {
        return (T)(vals.isEmpty() ? (Number)null : (Number)((Number)vals.get(vals.size() - 1).getValue()));
    }

    public static class WindowSummary {
        public final long latest;
        public final long min;
        public final long max;
        public final boolean stableForGrowth;
        public final boolean stableForShrinking;

        public WindowSummary(long latest, long min, long max, boolean stableForGrowth, boolean stableForShrinking) {
            this.latest = latest;
            this.min = min;
            this.max = max;
            this.stableForGrowth = stableForGrowth;
            this.stableForShrinking = stableForShrinking;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("latest", this.latest).add("min", this.min).add("max", this.max).add("stableForGrowth", this.stableForGrowth).add("stableForShrinking", this.stableForShrinking).toString();
        }
    }
}

