/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.loadbalancing;

import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.Resizable;
import brooklyn.event.basic.BasicNotificationSensor;
import brooklyn.policy.loadbalancing.BalanceableContainer;
import brooklyn.policy.loadbalancing.BalanceableWorkerPoolImpl;
import com.google.common.base.Preconditions;
import java.io.Serializable;

@ImplementedBy(value=BalanceableWorkerPoolImpl.class)
public interface BalanceableWorkerPool
extends Entity,
Resizable {
    public static final BasicNotificationSensor<Entity> CONTAINER_ADDED = new BasicNotificationSensor(Entity.class, "balanceablepool.container.added", "Container added to balanceable pool");
    public static final BasicNotificationSensor<Entity> CONTAINER_REMOVED = new BasicNotificationSensor(Entity.class, "balanceablepool.container.removed", "Container removed from balanceable pool");
    public static final BasicNotificationSensor<ContainerItemPair> ITEM_ADDED = new BasicNotificationSensor(ContainerItemPair.class, "balanceablepool.item.added", "Item added to balanceable pool");
    public static final BasicNotificationSensor<ContainerItemPair> ITEM_REMOVED = new BasicNotificationSensor(ContainerItemPair.class, "balanceablepool.item.removed", "Item removed from balanceable pool");
    public static final BasicNotificationSensor<ContainerItemPair> ITEM_MOVED = new BasicNotificationSensor(ContainerItemPair.class, "balanceablepool.item.moved", "Item moved in balanceable pool to the given container");

    public void setResizable(Resizable var1);

    public void setContents(Group var1, Group var2);

    public Group getContainerGroup();

    public Group getItemGroup();

    public static class ContainerItemPair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final BalanceableContainer<?> container;
        public final Entity item;

        public ContainerItemPair(BalanceableContainer<?> container, Entity item) {
            this.container = container;
            this.item = (Entity)Preconditions.checkNotNull((Object)item);
        }

        public String toString() {
            return "" + this.item + " @ " + this.container;
        }
    }
}

