/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.ha;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.group.StopFailedRuntimeException;
import brooklyn.entity.trait.MemberReplaceable;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.event.basic.BasicNotificationSensor;
import brooklyn.policy.basic.AbstractPolicy;
import brooklyn.policy.ha.HASensors;
import brooklyn.policy.ha.ServiceRestarter;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Service Replacer", description="HA policy for replacing a failed member of a group")
public class ServiceReplacer
extends AbstractPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceReplacer.class);
    public static final BasicNotificationSensor<HASensors.FailureDescriptor> ENTITY_REPLACEMENT_FAILED = new BasicNotificationSensor(HASensors.FailureDescriptor.class, "ha.entityFailed.replacement", "Indicates that an entity replacement attempt has failed");
    @SetFromFlag(value="setOnFireOnFailure")
    public static final ConfigKey<Boolean> SET_ON_FIRE_ON_FAILURE = ConfigKeys.newBooleanConfigKey((String)"setOnFireOnFailure", (String)"", (Boolean)true);
    @SetFromFlag(value="failureSensorToMonitor")
    public static final ConfigKey<Sensor> FAILURE_SENSOR_TO_MONITOR = new BasicConfigKey(Sensor.class, "failureSensorToMonitor", "", ServiceRestarter.ENTITY_RESTART_FAILED);
    @SetFromFlag(value="failOnRecurringFailuresInThisDuration")
    public static final ConfigKey<Long> FAIL_ON_RECURRING_FAILURES_IN_THIS_DURATION = ConfigKeys.newLongConfigKey((String)"failOnRecurringFailuresInThisDuration", (String)"abandon replace if replacement has failed many times within this time interval", (Long)300000L);
    @SetFromFlag(value="failOnNumRecurringFailures")
    public static final ConfigKey<Integer> FAIL_ON_NUM_RECURRING_FAILURES = ConfigKeys.newIntegerConfigKey((String)"failOnNumRecurringFailures", (String)"abandon replace if replacement has failed this many times (100% of attempts) within the time interval", (Integer)5);
    @SetFromFlag(value="ticker")
    public static final ConfigKey<Ticker> TICKER = ConfigKeys.newConfigKey(Ticker.class, (String)"ticker", (String)"A time source (defaults to system-clock, which is almost certainly what's wanted, except in tests)", null);
    protected final List<Long> consecutiveReplacementFailureTimes = Lists.newCopyOnWriteArrayList();

    public ServiceReplacer() {
        this(new ConfigBag());
    }

    public ServiceReplacer(Map<String, ?> flags) {
        this(new ConfigBag().putAll(flags));
    }

    public ServiceReplacer(ConfigBag configBag) {
        super(configBag.getAllConfigMutable());
    }

    public ServiceReplacer(Sensor<?> failureSensorToMonitor) {
        this(new ConfigBag().configure(FAILURE_SENSOR_TO_MONITOR, failureSensorToMonitor));
    }

    public void setEntity(final EntityLocal entity) {
        Preconditions.checkArgument((boolean)(entity instanceof MemberReplaceable), (String)"ServiceReplacer must take a MemberReplaceable, not %s", (Object[])new Object[]{entity});
        Sensor failureSensorToMonitor = (Sensor)Preconditions.checkNotNull((Object)this.getConfig(FAILURE_SENSOR_TO_MONITOR), (Object)"failureSensorToMonitor");
        super.setEntity(entity);
        this.subscribeToMembers((Group)entity, failureSensorToMonitor, (SensorEventListener)new SensorEventListener<Object>(){

            public void onEvent(final SensorEvent<Object> event) {
                if (ServiceReplacer.this.isRunning()) {
                    LOG.warn("ServiceReplacer notified; dispatching job for " + entity + " (" + event.getValue() + ")");
                    ((EntityInternal)entity).getExecutionContext().submit((Map)MutableMap.of(), new Runnable(){

                        @Override
                        public void run() {
                            ServiceReplacer.this.onDetectedFailure((SensorEvent<Object>)event);
                        }
                    });
                } else {
                    LOG.warn("ServiceReplacer not running, so not acting on failure detected at " + entity + " (" + event.getValue() + ", child of " + entity + ")");
                }
            }
        });
    }

    protected synchronized void onDetectedFailure(SensorEvent<Object> event) {
        final Entity failedEntity = event.getSource();
        final Object reason = event.getValue();
        if (this.isSuspended()) {
            LOG.warn("ServiceReplacer suspended, so not acting on failure detected at " + failedEntity + " (" + reason + ", child of " + this.entity + ")");
            return;
        }
        if (this.isRepeatedlyFailingTooMuch()) {
            LOG.error("ServiceReplacer not acting on failure detected at " + failedEntity + " (" + reason + ", child of " + this.entity + "), because too many recent replacement failures");
            return;
        }
        LOG.warn("ServiceReplacer acting on failure detected at " + failedEntity + " (" + reason + ", child of " + this.entity + ")");
        ((EntityInternal)this.entity).getManagementSupport().getExecutionContext().submit((Map)MutableMap.of(), new Runnable(){

            @Override
            public void run() {
                try {
                    Entities.invokeEffectorWithArgs((EntityLocal)ServiceReplacer.this.entity, (Entity)ServiceReplacer.this.entity, (Effector)MemberReplaceable.REPLACE_MEMBER, (Object[])new Object[]{failedEntity.getId()}).get();
                    ServiceReplacer.this.consecutiveReplacementFailureTimes.clear();
                }
                catch (Exception e) {
                    if (Exceptions.getFirstThrowableOfType((Throwable)e, StopFailedRuntimeException.class) != null) {
                        LOG.info("ServiceReplacer: ignoring error reported from stopping failed node " + failedEntity);
                        return;
                    }
                    ServiceReplacer.this.onReplacementFailed("Replace failure (" + Exceptions.collapseText((Throwable)e) + ") at " + ServiceReplacer.this.entity + ": " + reason);
                }
            }
        });
    }

    private boolean isRepeatedlyFailingTooMuch() {
        Long timestamp;
        Integer failOnNumRecurringFailures = (Integer)this.getConfig(FAIL_ON_NUM_RECURRING_FAILURES);
        long failOnRecurringFailuresInThisDuration = (Long)this.getConfig(FAIL_ON_RECURRING_FAILURES_IN_THIS_DURATION);
        long oldestPermitted = this.currentTimeMillis() - failOnRecurringFailuresInThisDuration;
        Iterator<Long> iter = this.consecutiveReplacementFailureTimes.iterator();
        while (iter.hasNext() && (timestamp = iter.next()) < oldestPermitted) {
            iter.remove();
        }
        return this.consecutiveReplacementFailureTimes.size() >= failOnNumRecurringFailures;
    }

    protected long currentTimeMillis() {
        Ticker ticker = (Ticker)this.getConfig(TICKER);
        return ticker == null ? System.currentTimeMillis() : TimeUnit.NANOSECONDS.toMillis(ticker.read());
    }

    protected void onReplacementFailed(String msg) {
        LOG.warn("ServiceReplacer failed for " + this.entity + ": " + msg);
        this.consecutiveReplacementFailureTimes.add(this.currentTimeMillis());
        if (((Boolean)this.getConfig(SET_ON_FIRE_ON_FAILURE)).booleanValue()) {
            ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((EntityLocal)this.entity, (String)"ServiceReplacer", (Object)("replacement failed: " + msg));
        }
        this.entity.emit(ENTITY_REPLACEMENT_FAILED, (Object)new HASensors.FailureDescriptor(this.entity, msg));
    }
}

