/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.ha;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.trait.Changeable;
import brooklyn.entity.trait.Startable;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.policy.basic.AbstractPolicy;
import brooklyn.policy.ha.HASensors;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Time;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberFailureDetectionPolicy
extends AbstractPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(MemberFailureDetectionPolicy.class);
    @SetFromFlag(value="onlyReportIfPreviouslyUp")
    public static final ConfigKey<Boolean> ONLY_REPORT_IF_PREVIOUSLY_UP = ConfigKeys.newBooleanConfigKey((String)"onlyReportIfPreviouslyUp", (String)"", (Boolean)true);
    @SetFromFlag(value="useServiceStateRunning")
    public static final ConfigKey<Boolean> USE_SERVICE_STATE_RUNNING = ConfigKeys.newBooleanConfigKey((String)"useServiceStateRunning", (String)"", (Boolean)true);
    @SetFromFlag(value="memberFilter")
    public static final ConfigKey<Predicate<? super Entity>> MEMBER_FILTER = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Predicate<? super Entity>>(){}, (String)"memberFilter", (String)"", (Object)Predicates.alwaysTrue());
    private final Map<Entity, Long> memberFailures = Maps.newLinkedHashMap();
    private final Map<Entity, Long> memberLastUps = Maps.newLinkedHashMap();
    private final Map<Entity, Boolean> memberIsUps = Maps.newLinkedHashMap();
    private final Map<Entity, Lifecycle> memberStates = Maps.newLinkedHashMap();

    public MemberFailureDetectionPolicy() {
        this((Map<String, ?>)MutableMap.of());
    }

    public MemberFailureDetectionPolicy(Map<String, ?> flags) {
        super(flags);
    }

    protected boolean acceptsMember(Entity member) {
        return ((Predicate)this.getConfig(MEMBER_FILTER)).apply((Object)member);
    }

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        if (((Boolean)this.getConfig(USE_SERVICE_STATE_RUNNING)).booleanValue()) {
            this.subscribeToMembers((Group)entity, (Sensor)Attributes.SERVICE_STATE_ACTUAL, (SensorEventListener)new SensorEventListener<Lifecycle>(){

                public void onEvent(SensorEvent<Lifecycle> event) {
                    if (!MemberFailureDetectionPolicy.this.acceptsMember(event.getSource())) {
                        return;
                    }
                    MemberFailureDetectionPolicy.this.onMemberStatus(event.getSource(), (Lifecycle)event.getValue());
                }
            });
        }
        this.subscribeToMembers((Group)entity, (Sensor)Startable.SERVICE_UP, (SensorEventListener)new SensorEventListener<Boolean>(){

            public void onEvent(SensorEvent<Boolean> event) {
                if (!MemberFailureDetectionPolicy.this.acceptsMember(event.getSource())) {
                    return;
                }
                MemberFailureDetectionPolicy.this.onMemberIsUp(event.getSource(), (Boolean)event.getValue());
            }
        });
        this.subscribe((Entity)entity, (Sensor)Changeable.MEMBER_REMOVED, (SensorEventListener)new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                MemberFailureDetectionPolicy.this.onMemberRemoved((Entity)event.getValue());
            }
        });
        this.subscribe((Entity)entity, (Sensor)Changeable.MEMBER_ADDED, (SensorEventListener)new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                if (!MemberFailureDetectionPolicy.this.acceptsMember(event.getSource())) {
                    return;
                }
                MemberFailureDetectionPolicy.this.onMemberAdded((Entity)event.getValue());
            }
        });
        for (Entity member : ((Group)entity).getMembers()) {
            if (!this.acceptsMember(member)) continue;
            this.onMemberAdded(member);
        }
    }

    private synchronized void onMemberIsUp(Entity member, Boolean isUp) {
        if (isUp != null) {
            Boolean old = this.memberIsUps.put(member, isUp);
            if (isUp.booleanValue()) {
                this.memberLastUps.put(member, System.currentTimeMillis());
            }
            if (!Objects.equal((Object)old, (Object)isUp)) {
                this.checkMemberHealth(member);
            }
        }
    }

    private synchronized void onMemberStatus(Entity member, Lifecycle status) {
        Lifecycle old;
        if (status != null && !Objects.equal((Object)(old = this.memberStates.put(member, status)), (Object)status)) {
            this.checkMemberHealth(member);
        }
    }

    private synchronized void onMemberAdded(Entity member) {
        if (((Boolean)this.getConfig(USE_SERVICE_STATE_RUNNING)).booleanValue()) {
            Lifecycle status = (Lifecycle)member.getAttribute(Attributes.SERVICE_STATE_ACTUAL);
            this.onMemberStatus(member, status);
        }
        Boolean isUp = (Boolean)member.getAttribute(Startable.SERVICE_UP);
        this.onMemberIsUp(member, isUp);
    }

    private synchronized void onMemberRemoved(Entity member) {
        this.memberStates.remove(member);
        this.memberIsUps.remove(member);
        this.memberLastUps.remove(member);
        this.memberFailures.remove(member);
    }

    private synchronized void checkMemberHealth(Entity member) {
        Long lastUpTime = this.memberLastUps.get(member);
        Boolean isUp = this.memberIsUps.get(member);
        Lifecycle status = this.memberStates.get(member);
        boolean failed = (Boolean)this.getConfig(USE_SERVICE_STATE_RUNNING) != false && status == Lifecycle.ON_FIRE || Boolean.FALSE.equals(isUp) && ((Boolean)this.getConfig(USE_SERVICE_STATE_RUNNING) == false || status == Lifecycle.RUNNING) && ((Boolean)this.getConfig(ONLY_REPORT_IF_PREVIOUSLY_UP) == false || lastUpTime != null);
        boolean recovered = ((Boolean)this.getConfig(USE_SERVICE_STATE_RUNNING) == false || status == Lifecycle.RUNNING) && Boolean.TRUE.equals(isUp);
        String description = String.format("location=%s; isUp=%s; status=%s; lastReportedUp=%s; timeNow=%s", member.getLocations(), isUp != null ? isUp : "<unreported>", status != null ? status : "<unreported>", lastUpTime != null ? Time.makeDateString((long)lastUpTime) : "<never>", Time.makeDateString((long)System.currentTimeMillis()));
        if (this.memberFailures.containsKey(member)) {
            if (recovered) {
                LOG.info("{} health-check for {}, component recovered (from failure at {}): {}", new Object[]{this, member, Time.makeDateString((long)this.memberFailures.get(member)), description});
                this.entity.emit(HASensors.ENTITY_RECOVERED, (Object)new HASensors.FailureDescriptor(member, description));
                this.memberFailures.remove(member);
            } else if (failed) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} health-check for {}, confirmed still failed: {}", new Object[]{this, member, description});
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("{} health-check for {}, in unconfirmed sate (previously failed): {}", new Object[]{this, member, description});
            }
        } else if (failed) {
            LOG.info("{} health-check for {}, component failed: {}", new Object[]{this, member, description});
            this.memberFailures.put(member, System.currentTimeMillis());
            this.entity.emit(HASensors.ENTITY_FAILED, (Object)new HASensors.FailureDescriptor(member, description));
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("{} health-check for {}, either healthy or insufficient data: {}", new Object[]{this, member, description});
        }
    }
}

