/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.ha;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.Sensor;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.policy.basic.AbstractPolicy;
import brooklyn.policy.ha.HASensors;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.task.BasicTask;
import brooklyn.util.task.ScheduledTask;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFailureDetector
extends AbstractPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFailureDetector.class);
    private static final long MIN_PERIOD_BETWEEN_EXECS_MILLIS = 100L;
    public static final ConfigKey<Duration> POLL_PERIOD = ConfigKeys.newDurationConfigKey((String)"failureDetector.pollPeriod", (String)"", (Duration)Duration.ONE_SECOND);
    @SetFromFlag(value="failedStabilizationDelay")
    public static final ConfigKey<Duration> FAILED_STABILIZATION_DELAY = ConfigKeys.newDurationConfigKey((String)"failureDetector.serviceFailedStabilizationDelay", (String)"Time period for which the health check consistently fails (e.g. doesn't report failed-ok-faled) before concluding failure.", (Duration)Duration.ZERO);
    @SetFromFlag(value="recoveredStabilizationDelay")
    public static final ConfigKey<Duration> RECOVERED_STABILIZATION_DELAY = ConfigKeys.newDurationConfigKey((String)"failureDetector.serviceRecoveredStabilizationDelay", (String)"Time period for which the health check succeeds continiually (e.g. doesn't report ok-failed-ok) before concluding recovered", (Duration)Duration.ZERO);
    public static final ConfigKey<Sensor<HASensors.FailureDescriptor>> SENSOR_FAILED = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Sensor<HASensors.FailureDescriptor>>(){}, (String)"failureDetector.sensor.fail", (String)"A sensor which will indicate failure when set", HASensors.ENTITY_FAILED);
    public static final ConfigKey<Sensor<HASensors.FailureDescriptor>> SENSOR_RECOVERED = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Sensor<HASensors.FailureDescriptor>>(){}, (String)"failureDetector.sensor.recover", (String)"A sensor which will indicate recovery from failure when set", HASensors.ENTITY_RECOVERED);
    protected final AtomicReference<Long> stateLastGood = new AtomicReference();
    protected final AtomicReference<Long> stateLastFail = new AtomicReference();
    protected Long currentFailureStartTime = null;
    protected Long currentRecoveryStartTime = null;
    protected LastPublished lastPublished = LastPublished.NONE;
    private final AtomicBoolean executorQueued = new AtomicBoolean(false);
    private volatile long executorTime = 0L;
    private Callable<Task<?>> pollingTaskFactory = new HealthPollingTaskFactory();
    private Task<?> scheduledTask;

    protected abstract CalculatedStatus calculateStatus();

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        if (this.isRunning()) {
            this.doStartPolling();
        }
    }

    public void suspend() {
        this.scheduledTask.cancel(true);
        super.suspend();
    }

    public void resume() {
        this.currentFailureStartTime = null;
        this.currentRecoveryStartTime = null;
        this.lastPublished = LastPublished.NONE;
        this.executorQueued.set(false);
        this.executorTime = 0L;
        super.resume();
        this.doStartPolling();
    }

    protected void doStartPolling() {
        if (this.scheduledTask == null || this.scheduledTask.isDone()) {
            ScheduledTask task = new ScheduledTask((Map)MutableMap.of((Object)"period", (Object)this.getPollPeriod(), (Object)"displayName", (Object)this.getTaskName()), this.pollingTaskFactory);
            this.scheduledTask = ((EntityInternal)this.entity).getExecutionContext().submit((TaskAdaptable)task);
        }
    }

    private String getTaskName() {
        return this.getDisplayName();
    }

    protected Duration getPollPeriod() {
        return (Duration)this.getConfig(POLL_PERIOD);
    }

    protected Duration getFailedStabilizationDelay() {
        return (Duration)this.getConfig(FAILED_STABILIZATION_DELAY);
    }

    protected Duration getRecoveredStabilizationDelay() {
        return (Duration)this.getConfig(RECOVERED_STABILIZATION_DELAY);
    }

    protected Sensor<HASensors.FailureDescriptor> getSensorFailed() {
        return (Sensor)this.getConfig(SENSOR_FAILED);
    }

    protected Sensor<HASensors.FailureDescriptor> getSensorRecovered() {
        return (Sensor)this.getConfig(SENSOR_RECOVERED);
    }

    private synchronized void checkHealth() {
        CalculatedStatus status = this.calculateStatus();
        boolean healthy = status.isHealthy();
        long now = System.currentTimeMillis();
        if (healthy) {
            this.stateLastGood.set(now);
            if (this.lastPublished == LastPublished.FAILED) {
                if (this.currentRecoveryStartTime == null) {
                    LOG.info("{} check for {}, now recovering: {}", new Object[]{this, this.entity, this.getDescription(status)});
                    this.currentRecoveryStartTime = now;
                    this.schedulePublish();
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace("{} check for {}, continuing recovering: {}", new Object[]{this, this.entity, this.getDescription(status)});
                }
            } else if (this.currentFailureStartTime != null) {
                LOG.info("{} check for {}, now healthy: {}", new Object[]{this, this.entity, this.getDescription(status)});
                this.currentFailureStartTime = null;
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("{} check for {}, still healthy: {}", new Object[]{this, this.entity, this.getDescription(status)});
            }
        } else {
            this.stateLastFail.set(now);
            if (this.lastPublished != LastPublished.FAILED) {
                if (this.currentFailureStartTime == null) {
                    LOG.info("{} check for {}, now failing: {}", new Object[]{this, this.entity, this.getDescription(status)});
                    this.currentFailureStartTime = now;
                    this.schedulePublish();
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace("{} check for {}, continuing failing: {}", new Object[]{this, this.entity, this.getDescription(status)});
                }
            } else if (this.currentRecoveryStartTime != null) {
                LOG.info("{} check for {}, now failing: {}", new Object[]{this, this.entity, this.getDescription(status)});
                this.currentRecoveryStartTime = null;
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("{} check for {}, still failed: {}", new Object[]{this, this.entity, this.getDescription(status)});
            }
        }
    }

    protected void schedulePublish() {
        this.schedulePublish(0L);
    }

    protected void schedulePublish(long delay) {
        if (this.isRunning() && this.executorQueued.compareAndSet(false, true)) {
            long now = System.currentTimeMillis();
            delay = Math.max(0L, Math.max(delay, this.executorTime + 100L - now));
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} scheduling publish in {}ms", (Object)this, (Object)delay);
            }
            PublishJob job = new PublishJob();
            ScheduledTask task = new ScheduledTask((Map)MutableMap.of((Object)"delay", (Object)Duration.of((long)delay, (TimeUnit)TimeUnit.MILLISECONDS)), (Task)new BasicTask((Runnable)job));
            ((EntityInternal)this.entity).getExecutionContext().submit((TaskAdaptable)task);
        }
    }

    private synchronized void publishNow() {
        if (!this.isRunning()) {
            return;
        }
        CalculatedStatus calculatedStatus = this.calculateStatus();
        boolean healthy = calculatedStatus.isHealthy();
        Long lastUpTime = this.stateLastGood.get();
        Long lastDownTime = this.stateLastFail.get();
        long serviceFailedStabilizationDelay = this.getFailedStabilizationDelay().toMilliseconds();
        long serviceRecoveredStabilizationDelay = this.getRecoveredStabilizationDelay().toMilliseconds();
        long now = System.currentTimeMillis();
        if (healthy) {
            if (this.lastPublished == LastPublished.FAILED) {
                long currentRecoveryPeriod = this.getTimeDiff(now, this.currentRecoveryStartTime);
                long sinceLastDownPeriod = this.getTimeDiff(now, lastDownTime);
                if (currentRecoveryPeriod > serviceRecoveredStabilizationDelay && sinceLastDownPeriod > serviceRecoveredStabilizationDelay) {
                    String description = this.getDescription(calculatedStatus);
                    LOG.warn("{} check for {}, publishing recovered: {}", new Object[]{this, this.entity, description});
                    this.entity.emit(this.getSensorRecovered(), (Object)new HASensors.FailureDescriptor(this.entity, description));
                    this.lastPublished = LastPublished.RECOVERED;
                    this.currentFailureStartTime = null;
                } else {
                    long nextAttemptTime = Math.max(serviceRecoveredStabilizationDelay - currentRecoveryPeriod, serviceRecoveredStabilizationDelay - sinceLastDownPeriod);
                    this.schedulePublish(nextAttemptTime);
                }
            }
        } else if (this.lastPublished != LastPublished.FAILED) {
            long currentFailurePeriod = this.getTimeDiff(now, this.currentFailureStartTime);
            long sinceLastUpPeriod = this.getTimeDiff(now, lastUpTime);
            if (currentFailurePeriod > serviceFailedStabilizationDelay && sinceLastUpPeriod > serviceFailedStabilizationDelay) {
                String description = this.getDescription(calculatedStatus);
                LOG.warn("{} connectivity-check for {}, publishing failed: {}", new Object[]{this, this.entity, description});
                this.entity.emit(this.getSensorFailed(), (Object)new HASensors.FailureDescriptor(this.entity, description));
                this.lastPublished = LastPublished.FAILED;
                this.currentRecoveryStartTime = null;
            } else {
                long nextAttemptTime = Math.max(serviceFailedStabilizationDelay - currentFailurePeriod, serviceFailedStabilizationDelay - sinceLastUpPeriod);
                this.schedulePublish(nextAttemptTime);
            }
        }
    }

    protected String getDescription(CalculatedStatus status) {
        Long lastUpTime = this.stateLastGood.get();
        Long lastDownTime = this.stateLastGood.get();
        Duration serviceFailedStabilizationDelay = this.getFailedStabilizationDelay();
        Duration serviceRecoveredStabilizationDelay = this.getRecoveredStabilizationDelay();
        return String.format("%s; healthy=%s; timeNow=%s; lastUp=%s; lastDown=%s; lastPublished=%s; currentFailurePeriod=%s; currentRecoveryPeriod=%s", new Object[]{status.getDescription(), status.isHealthy(), Time.makeDateString((long)System.currentTimeMillis()), lastUpTime != null ? Time.makeDateString((long)lastUpTime) : "<never>", lastDownTime != null ? Time.makeDateString((long)lastDownTime) : "<never>", this.lastPublished, (this.currentFailureStartTime != null ? this.getTimeStringSince(this.currentFailureStartTime) : "<none>") + " (stabilization " + Time.makeTimeStringRounded((Duration)serviceFailedStabilizationDelay) + ")", (this.currentRecoveryStartTime != null ? this.getTimeStringSince(this.currentRecoveryStartTime) : "<none>") + " (stabilization " + Time.makeTimeStringRounded((Duration)serviceRecoveredStabilizationDelay) + ")"});
    }

    private long getTimeDiff(Long recent, Long previous) {
        return previous == null ? recent : recent - previous;
    }

    private String getTimeStringSince(Long time) {
        return time == null ? null : Time.makeTimeStringRounded((long)(System.currentTimeMillis() - time));
    }

    public static enum LastPublished {
        NONE,
        FAILED,
        RECOVERED;

    }

    protected static class BasicCalculatedStatus
    implements CalculatedStatus {
        private boolean healthy;
        private String description;

        public BasicCalculatedStatus(boolean healthy, String description) {
            this.healthy = healthy;
            this.description = description;
        }

        @Override
        public boolean isHealthy() {
            return this.healthy;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private final class HealthPollingTaskFactory
    implements Callable<Task<?>> {
        private HealthPollingTaskFactory() {
        }

        @Override
        public Task<?> call() {
            BasicTask task = new BasicTask((Runnable)new HealthPoller());
            BrooklynTaskTags.setTransient((Task)task);
            return task;
        }
    }

    private final class HealthPoller
    implements Runnable {
        private HealthPoller() {
        }

        @Override
        public void run() {
            AbstractFailureDetector.this.checkHealth();
        }
    }

    private final class PublishJob
    implements Runnable {
        private PublishJob() {
        }

        @Override
        public void run() {
            try {
                AbstractFailureDetector.this.executorTime = System.currentTimeMillis();
                AbstractFailureDetector.this.executorQueued.set(false);
                AbstractFailureDetector.this.publishNow();
            }
            catch (Exception e) {
                if (AbstractFailureDetector.this.isRunning()) {
                    LOG.error("Problem resizing: " + e, (Throwable)e);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Problem resizing, but no longer running: " + e, (Throwable)e);
                }
            }
            catch (Throwable t) {
                LOG.error("Problem in service-failure-detector: " + t, t);
                throw Exceptions.propagate((Throwable)t);
            }
        }
    }

    public static interface CalculatedStatus {
        public boolean isHealthy();

        public String getDescription();
    }
}

