/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.brooklyn;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.brooklyn.BrooklynMetrics;
import brooklyn.management.ManagementContext;
import brooklyn.management.internal.LocalSubscriptionManager;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.util.task.BasicExecutionManager;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class BrooklynMetricsImpl
extends AbstractEntity
implements BrooklynMetrics {
    private ScheduledExecutorService executor;

    public void onManagementBecomingMaster() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("brooklyn-brooklynmetrics-poller-%d").build();
        this.executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                BrooklynMetricsImpl.this.refreshSensors();
            }
        }, 0L, (Long)this.getConfig((ConfigKey.HasConfigKey)UPDATE_PERIOD), TimeUnit.MILLISECONDS);
    }

    public void onManagementNoLongerMaster() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    private void refreshSensors() {
        ManagementContext managementContext = this.getManagementContext();
        BasicExecutionManager execManager = (BasicExecutionManager)(managementContext != null ? managementContext.getExecutionManager() : null);
        LocalSubscriptionManager subsManager = (LocalSubscriptionManager)(managementContext != null ? managementContext.getSubscriptionManager() : null);
        if (managementContext != null) {
            this.setAttribute(TOTAL_EFFECTORS_INVOKED, ((ManagementContextInternal)managementContext).getTotalEffectorInvocations());
        }
        if (execManager != null) {
            this.setAttribute(TOTAL_TASKS_SUBMITTED, execManager.getTotalTasksSubmitted());
            this.setAttribute(NUM_INCOMPLETE_TASKS, execManager.getNumIncompleteTasks());
            this.setAttribute(NUM_ACTIVE_TASKS, execManager.getNumActiveTasks());
        }
        if (subsManager != null) {
            this.setAttribute(TOTAL_EVENTS_PUBLISHED, subsManager.getTotalEventsPublished());
            this.setAttribute(TOTAL_EVENTS_DELIVERED, subsManager.getTotalEventsDelivered());
            this.setAttribute(NUM_SUBSCRIPTIONS, subsManager.getNumSubscriptions());
        }
    }
}

