/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.AbstractTypeTransformingEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.event.AttributeSensor;
import brooklyn.event.SensorEvent;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.javalang.JavaClassNames;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedList;

@Beta
public class RollingTimeWindowMeanEnricher<T extends Number>
extends AbstractTypeTransformingEnricher<T, Double> {
    public static ConfigKey<Double> CONFIDENCE_REQUIRED_TO_PUBLISH = ConfigKeys.newDoubleConfigKey((String)"confidenceRequired", (String)"Minimum confidence level (ie period covered) required to publish a rolling average", (Double)0.8);
    private final LinkedList<T> values = new LinkedList();
    private final LinkedList<Long> timestamps = new LinkedList();
    volatile ConfidenceQualifiedNumber lastAverage = new ConfidenceQualifiedNumber(0.0, 0.0);
    @SetFromFlag
    Duration timePeriod;

    public RollingTimeWindowMeanEnricher() {
    }

    public RollingTimeWindowMeanEnricher(Entity producer, AttributeSensor<T> source, AttributeSensor<Double> target, Duration timePeriod) {
        super(producer, source, target);
        this.timePeriod = (Duration)Preconditions.checkNotNull((Object)timePeriod, (Object)"timePeriod");
        if (source != null && target != null) {
            this.uniqueTag = JavaClassNames.simpleClassName(((Object)((Object)this)).getClass()) + ":" + source.getName() + "/" + timePeriod + "->" + target.getName();
        }
    }

    public RollingTimeWindowMeanEnricher(Entity producer, AttributeSensor<T> source, AttributeSensor<Double> target, long timePeriod) {
        this(producer, source, target, Duration.millis((Number)timePeriod));
    }

    public void onEvent(SensorEvent<T> event) {
        this.onEvent(event, event.getTimestamp());
    }

    public void onEvent(SensorEvent<T> event, long eventTime) {
        this.values.addLast(event.getValue());
        this.timestamps.addLast(eventTime);
        if (eventTime > 0L) {
            ConfidenceQualifiedNumber average = this.getAverage(eventTime, 0L);
            if (average.confidence > (Double)this.getConfig(CONFIDENCE_REQUIRED_TO_PUBLISH)) {
                this.entity.setAttribute((AttributeSensor)this.target, (Object)average.value);
            }
        }
    }

    @Deprecated
    public ConfidenceQualifiedNumber getAverage() {
        return this.getAverage(System.currentTimeMillis(), 0L);
    }

    @Deprecated
    public ConfidenceQualifiedNumber getAverage(long fromTimeExact) {
        return this.getAverage(fromTimeExact, 0L);
    }

    public ConfidenceQualifiedNumber getAverage(long fromTime, long graceAllowed) {
        if (this.timestamps.isEmpty()) {
            this.lastAverage = new ConfidenceQualifiedNumber(this.lastAverage.value, 0.0);
            return this.lastAverage;
        }
        long firstTimestamp = -1L;
        Iterator ti = this.timestamps.iterator();
        while (ti.hasNext() && (firstTimestamp = ((Long)ti.next()).longValue()) <= 0L) {
        }
        if (firstTimestamp <= 0L) {
            this.lastAverage = new ConfidenceQualifiedNumber(((Number)this.values.get(this.values.size() - 1)).doubleValue(), 0.0);
            return this.lastAverage;
        }
        long lastTimestamp = this.timestamps.get(this.timestamps.size() - 1);
        long now = fromTime;
        if (lastTimestamp > fromTime - graceAllowed) {
            now = lastTimestamp;
        }
        this.pruneValues(now);
        long windowStart = Math.max(now - this.timePeriod.toMilliseconds(), firstTimestamp);
        long windowEnd = Math.max(now - this.timePeriod.toMilliseconds(), lastTimestamp);
        Double confidence = (double)(windowEnd - windowStart) / (double)this.timePeriod.toMilliseconds();
        if (confidence <= 1.0E-7) {
            double lastValue = ((Number)this.values.get(this.values.size() - 1)).doubleValue();
            this.lastAverage = new ConfidenceQualifiedNumber(lastValue, 0.0);
            return this.lastAverage;
        }
        long start = windowStart;
        double weightedAverage = 0.0;
        Iterator valuesIter = this.values.iterator();
        Iterator timestampsIter = this.timestamps.iterator();
        while (valuesIter.hasNext()) {
            Number val = (Number)valuesIter.next();
            Long timestamp = (Long)timestampsIter.next();
            if (val == null || timestamp < start) continue;
            long end = timestamp;
            weightedAverage += (double)(end - start) / (confidence * (double)this.timePeriod.toMilliseconds()) * val.doubleValue();
            start = timestamp;
        }
        this.lastAverage = new ConfidenceQualifiedNumber(weightedAverage, confidence);
        return this.lastAverage;
    }

    private void pruneValues(long now) {
        while (this.timestamps.size() > 1 && this.timestamps.get(1) < now - this.timePeriod.toMilliseconds()) {
            this.timestamps.removeFirst();
            this.values.removeFirst();
        }
    }

    public static class ConfidenceQualifiedNumber {
        final Double value;
        final double confidence;

        public ConfidenceQualifiedNumber(Double value, double confidence) {
            this.value = value;
            this.confidence = confidence;
        }

        public String toString() {
            return "" + this.value + " (" + (int)(this.confidence * 100.0) + "%)";
        }
    }
}

