/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.jclouds.os;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.test.BrooklynAppUnitTestSupport;
import org.apache.brooklyn.core.test.entity.TestEntity;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.policy.jclouds.os.CreateUserPolicy;
import org.apache.brooklyn.test.EntityTestUtils;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CreateUserPolicyTest
extends BrooklynAppUnitTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CreateUserPolicyTest.class);

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        RecordingSshMachineLocation.execScriptCalls.clear();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            RecordingSshMachineLocation.execScriptCalls.clear();
        }
    }

    @Test
    public void testCallsCreateUser() throws Exception {
        SshMachineLocation machine = (SshMachineLocation)this.mgmt.getLocationManager().createLocation(LocationSpec.create(RecordingSshMachineLocation.class).configure(SshTool.PROP_USER, (Object)"myuser").configure(SshTool.PROP_PASSWORD, (Object)"mypassword").configure((CharSequence)"address", (Object)"1.2.3.4").configure(SshTool.PROP_PORT, (Object)1234));
        String newUsername = "mynewuser";
        this.app.createAndManageChild(EntitySpec.create(TestEntity.class).policy(PolicySpec.create(CreateUserPolicy.class).configure(CreateUserPolicy.GRANT_SUDO, (Object)true).configure(CreateUserPolicy.VM_USERNAME, (Object)newUsername)));
        TestEntity entity = (TestEntity)Iterables.getOnlyElement((Iterable)this.app.getChildren());
        this.app.start((Collection)ImmutableList.of((Object)machine));
        String creds = (String)EntityTestUtils.assertAttributeEventuallyNonNull((Entity)entity, (AttributeSensor)CreateUserPolicy.VM_USER_CREDENTIALS);
        Pattern pattern = Pattern.compile("(.*) : (.*) @ (.*):(.*)");
        Matcher matcher = pattern.matcher(creds);
        Assert.assertTrue((boolean)matcher.matches());
        String username2 = matcher.group(1).trim();
        String password = matcher.group(2).trim();
        String hostname = matcher.group(3).trim();
        String port = matcher.group(4).trim();
        Assert.assertEquals((String)newUsername, (String)username2);
        Assert.assertEquals((String)hostname, (String)"1.2.3.4");
        Assert.assertEquals((int)password.length(), (int)12);
        Assert.assertEquals((String)port, (String)"1234");
        boolean found = false;
        for (List<String> cmds : RecordingSshMachineLocation.execScriptCalls) {
            if (!cmds.toString().contains("useradd")) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found, (String)("useradd not found in: " + RecordingSshMachineLocation.execScriptCalls));
    }

    public static class RecordingSshMachineLocation
    extends SshMachineLocation {
        private static final long serialVersionUID = 1641930081769106380L;
        public static List<List<String>> execScriptCalls = Lists.newArrayList();

        public int execScript(String summary, List<String> cmds) {
            execScriptCalls.add(cmds);
            return 0;
        }

        public int execScript(Map<String, ?> props, String summaryForLogging, List<String> cmds) {
            execScriptCalls.add(cmds);
            return 0;
        }

        public int execScript(String summaryForLogging, List<String> cmds, Map<String, ?> env) {
            execScriptCalls.add(cmds);
            return 0;
        }

        public int execScript(Map<String, ?> props, String summaryForLogging, List<String> cmds, Map<String, ?> env) {
            execScriptCalls.add(cmds);
            return 0;
        }
    }
}

