/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.jclouds.os;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.test.BrooklynAppLiveTestSupport;
import org.apache.brooklyn.core.test.entity.TestEntity;
import org.apache.brooklyn.location.localhost.LocalhostMachineProvisioningLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.policy.jclouds.os.CreateUserPolicy;
import org.apache.brooklyn.test.EntityTestUtils;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.text.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CreateUserPolicyLiveTest
extends BrooklynAppLiveTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CreateUserPolicyLiveTest.class);

    @Test(groups={"Integration", "WIP"})
    public void testIntegrationCreatesUser() throws Exception {
        LocalhostMachineProvisioningLocation loc = this.app.newLocalhostProvisioningLocation();
        this.runTestCreatesUser((MachineProvisioningLocation<SshMachineLocation>)loc);
    }

    @Test(groups={"Live"})
    public void testLiveCreatesUser() throws Exception {
        String locSpec = "jclouds:softlayer:ams01";
        ImmutableMap locArgs = ImmutableMap.of((Object)"imageId", (Object)"CENTOS_6_64");
        Location loc = this.mgmt.getLocationRegistry().resolve(locSpec, (Map)locArgs);
        this.runTestCreatesUser((MachineProvisioningLocation<SshMachineLocation>)((MachineProvisioningLocation)loc));
    }

    public void runTestCreatesUser(MachineProvisioningLocation<SshMachineLocation> loc) throws Exception {
        String newUsername = Identifiers.makeRandomId((int)16);
        SshMachineLocation machine = (SshMachineLocation)loc.obtain((Map)ImmutableMap.of());
        try {
            this.app.createAndManageChild(EntitySpec.create(TestEntity.class).policy(PolicySpec.create(CreateUserPolicy.class).configure(CreateUserPolicy.GRANT_SUDO, (Object)true).configure(CreateUserPolicy.VM_USERNAME, (Object)newUsername)));
            TestEntity entity = (TestEntity)Iterables.getOnlyElement((Iterable)this.app.getChildren());
            this.app.start((Collection)ImmutableList.of((Object)machine));
            String creds = (String)EntityTestUtils.assertAttributeEventuallyNonNull((Entity)entity, (AttributeSensor)CreateUserPolicy.VM_USER_CREDENTIALS);
            Pattern pattern = Pattern.compile("(.*) : (.*) @ (.*):(.*)");
            Matcher matcher = pattern.matcher(creds);
            Assert.assertTrue((boolean)matcher.matches());
            String username = matcher.group(1).trim();
            String password = matcher.group(2).trim();
            String hostname = matcher.group(3).trim();
            String port = matcher.group(4).trim();
            Assert.assertEquals((String)newUsername, (String)username);
            Assert.assertEquals((String)hostname, (String)machine.getAddress().getHostName());
            Assert.assertEquals((String)port, (String)("" + machine.getPort()));
            SshMachineLocation machine2 = (SshMachineLocation)this.mgmt.getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class).configure(SshTool.PROP_USER, (Object)newUsername).configure(SshMachineLocation.PASSWORD, (Object)password).configure((CharSequence)"address", (Object)hostname).configure(SshMachineLocation.SSH_PORT, (Object)Integer.parseInt(port)));
            LOG.info("Checking ssh'able for auto-generated user: machine=" + machine + "; creds=" + creds);
            Assert.assertTrue((boolean)machine2.isSshable(), (String)("machine=" + machine + "; creds=" + creds));
        }
        finally {
            LOG.info("Deleting auto-generated user " + newUsername);
            machine.execScript("delete-user-" + newUsername, (List)ImmutableList.of((Object)("sudo userdel -f " + newUsername)));
            loc.release((MachineLocation)machine);
        }
    }
}

