/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.zone;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.jclouds.zone.AwsAvailabilityZoneExtension;
import org.jclouds.domain.LocationScope;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AwsAvailabilityZoneExtensionTest {
    public static final String PROVIDER = "aws-ec2";
    public static final String REGION_NAME = "us-east-1";
    public static final String LOCATION_SPEC = "aws-ec2" + ("us-east-1" == null ? "" : ":us-east-1");
    public static final String SMALL_HARDWARE_ID = "m1.small";
    public static final String US_EAST_IMAGE_ID = "us-east-1/ami-7d7bfc14";
    private LocalManagementContext mgmt;
    private JcloudsLocation loc;
    private AwsAvailabilityZoneExtension zoneExtension;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.mgmt = new LocalManagementContext();
        this.loc = (JcloudsLocation)this.mgmt.getLocationRegistry().resolve(LOCATION_SPEC);
        this.zoneExtension = new AwsAvailabilityZoneExtension((ManagementContext)this.mgmt, this.loc);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.mgmt != null) {
            Entities.destroyAll((ManagementContext)this.mgmt);
        }
    }

    @Test(groups={"Live", "Sanity"})
    public void testFindsZones() throws Exception {
        List subLocations = this.zoneExtension.getSubLocations(Integer.MAX_VALUE);
        List<String> zoneNames = this.getRegionsOf(subLocations);
        Assert.assertTrue((subLocations.size() >= 3 ? 1 : 0) != 0, (String)("zones=" + subLocations));
        Assert.assertTrue((boolean)zoneNames.containsAll((Collection<?>)ImmutableList.of((Object)"us-east-1a", (Object)"us-east-1b", (Object)"us-east-1c")), (String)("zoneNames=" + zoneNames));
    }

    @Test(groups={"Live", "Sanity"})
    public void testFiltersZones() throws Exception {
        List subLocations = this.zoneExtension.getSubLocationsByName(Predicates.containsPattern((String)"us-east-1[ab]"), Integer.MAX_VALUE);
        List<String> zoneNames = this.getRegionsOf(subLocations);
        Assert.assertTrue((subLocations.size() == 2 ? 1 : 0) != 0, (String)("zones=" + subLocations));
        Assert.assertTrue((boolean)zoneNames.containsAll((Collection<?>)ImmutableList.of((Object)"us-east-1a", (Object)"us-east-1b")), (String)("zoneNames=" + zoneNames));
    }

    @Test(groups={"Live"})
    public void testSubLocationIsUsable() throws Exception {
        String zoneName = "us-east-1b";
        List subLocations = this.zoneExtension.getSubLocationsByName(Predicates.equalTo((Object)zoneName), Integer.MAX_VALUE);
        JcloudsLocation subLocation = (JcloudsLocation)Iterables.getOnlyElement((Iterable)subLocations);
        JcloudsSshMachineLocation machine = null;
        try {
            machine = (JcloudsSshMachineLocation)subLocation.obtain((Map)ImmutableMap.builder().put((Object)JcloudsLocation.IMAGE_ID, (Object)US_EAST_IMAGE_ID).put((Object)JcloudsLocation.HARDWARE_ID, (Object)SMALL_HARDWARE_ID).put((Object)JcloudsLocation.INBOUND_PORTS, (Object)ImmutableList.of((Object)22)).build());
            org.jclouds.domain.Location machineLoc = machine.getNode().getLocation();
            Assert.assertEquals((Object)machineLoc.getScope(), (Object)LocationScope.ZONE, (String)("machineLoc=" + machineLoc));
            Assert.assertEquals((String)machineLoc.getId(), (String)zoneName, (String)("machineLoc=" + machineLoc));
        }
        catch (Throwable throwable) {
            if (machine != null) {
                subLocation.release(machine);
            }
            throw throwable;
        }
        if (machine != null) {
            subLocation.release((MachineLocation)machine);
        }
    }

    protected List<String> getRegionsOf(List<Location> locs) {
        ArrayList result = Lists.newArrayList();
        for (Location loc : locs) {
            result.add(((JcloudsLocation)loc).getRegion());
        }
        return result;
    }
}

