/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.provider;

import java.util.Map;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.jclouds.provider.AbstractJcloudsLocationTest;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class RackspaceLocationLiveTest
extends AbstractJcloudsLocationTest {
    private static final Logger LOG = LoggerFactory.getLogger(RackspaceLocationLiveTest.class);
    private static final String PROVIDER = "rackspace-cloudservers-uk";
    private static final String REGION_NAME = null;
    private static final String IMAGE_ID = "LON/f70ed7c7-b42e-4d77-83d8-40fa29825b85";
    private static final String IMAGE_NAME_PATTERN = "CentOS 6.4";
    private static final String IMAGE_OWNER = null;

    public RackspaceLocationLiveTest() {
        super(PROVIDER);
    }

    @Override
    @DataProvider(name="fromImageId")
    public Object[][] cloudAndImageIds() {
        return new Object[][]{{REGION_NAME, IMAGE_ID, IMAGE_OWNER}};
    }

    @Override
    @DataProvider(name="fromImageNamePattern")
    public Object[][] cloudAndImageNamePatterns() {
        return new Object[][]{{REGION_NAME, IMAGE_NAME_PATTERN, IMAGE_OWNER}};
    }

    @Override
    @DataProvider(name="fromImageDescriptionPattern")
    public Object[][] cloudAndImageDescriptionPatterns() {
        return new Object[0][0];
    }

    @Test(groups={"Live"})
    public void testVmMetadata() {
        this.loc = (JcloudsLocation)this.ctx.getLocationRegistry().resolve(PROVIDER + (REGION_NAME == null ? "" : ":" + REGION_NAME));
        SshMachineLocation machine = this.obtainMachine((Map)MutableMap.of((Object)"imageId", (Object)IMAGE_ID, (Object)"userMetadata", (Object)MutableMap.of((Object)"mykey", (Object)"myval"), (Object)JcloudsLocation.MACHINE_CREATE_ATTEMPTS, (Object)2));
        LOG.info("Provisioned {} vm {}; checking metadata and if ssh'able", (Object)PROVIDER, (Object)machine);
        Map userMetadata = ((JcloudsSshMachineLocation)machine).getNode().getUserMetadata();
        Assert.assertEquals((String)((String)userMetadata.get("mykey")), (String)"myval", (String)("metadata=" + userMetadata));
        Assert.assertTrue((boolean)machine.isSshable());
    }
}

