/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.provider;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.testng.collections.Lists;

public abstract class AbstractJcloudsLocationTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJcloudsLocationTest.class);
    private final String provider;
    protected JcloudsLocation loc;
    protected List<SshMachineLocation> machines = MutableList.of();
    protected ManagementContext ctx;

    protected AbstractJcloudsLocationTest(String provider) {
        this.provider = provider;
    }

    @DataProvider(name="fromImageId")
    public abstract Object[][] cloudAndImageIds();

    @DataProvider(name="fromFirstImageId")
    public Object[][] cloudAndImageFirstId() {
        Object[][] objectArray;
        Object[][] all = this.cloudAndImageIds();
        if (all != null) {
            Object[][] objectArrayArray = new Object[1][];
            objectArray = objectArrayArray;
            objectArrayArray[0] = all[0];
        } else {
            objectArray = new Object[][]{};
        }
        return objectArray;
    }

    @DataProvider(name="fromImageNamePattern")
    public abstract Object[][] cloudAndImageNamePatterns();

    @DataProvider(name="fromImageDescriptionPattern")
    public abstract Object[][] cloudAndImageDescriptionPatterns();

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        BrooklynProperties props = BrooklynProperties.Factory.newDefault().addFromMap((Map)ImmutableMap.of((Object)"provider", (Object)this.provider));
        this.ctx = Entities.newManagementContext((Map)props.asMapWithStringKeys());
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        List exceptions = Lists.newArrayList();
        for (SshMachineLocation machine : this.machines) {
            try {
                this.loc.release((MachineLocation)machine);
            }
            catch (Exception e) {
                LOG.warn("Error releasing {}: {}; continuing...", (Object)machine, (Object)e.getMessage());
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            LOG.info("Exception during tearDown: {}", (Object)Exceptions.collapseText((Throwable)((Throwable)exceptions.get(0))));
        }
        this.machines.clear();
        if (this.ctx != null) {
            Entities.destroyAllCatching((ManagementContext)this.ctx);
        }
    }

    @Test(dataProvider="fromImageId")
    public void testTagMapping(String regionName, String imageId, String imageOwner) {
        ImmutableMap dummy = ImmutableMap.of((Object)"identity", (Object)"DUMMY", (Object)"credential", (Object)"DUMMY");
        this.loc = (JcloudsLocation)this.ctx.getLocationRegistry().resolve(String.valueOf(this.provider) + (regionName == null ? "" : ":" + regionName), (Map)dummy);
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"imageId", (Object)imageId);
        if (imageOwner != null) {
            builder.put((Object)"imageOwner", (Object)imageOwner);
        }
        ImmutableMap tagMapping = builder.build();
        this.loc.setTagMapping((Map)ImmutableMap.of((Object)"MyEntityType", (Object)tagMapping));
        Map flags = this.loc.getProvisioningFlags((Collection)ImmutableList.of((Object)"MyEntityType"));
        Assert.assertTrue((boolean)Maps.difference((Map)flags, (Map)tagMapping).entriesOnlyOnRight().isEmpty(), (String)("flags=" + flags));
    }

    @Test(groups={"Live"}, dataProvider="fromImageId")
    public void testProvisionVmUsingImageId(String regionName, String imageId, String imageOwner) {
        this.loc = (JcloudsLocation)this.ctx.getLocationRegistry().resolve(String.valueOf(this.provider) + (regionName == null ? "" : ":" + regionName));
        SshMachineLocation machine = this.obtainMachine((Map)MutableMap.of((Object)"imageId", (Object)imageId, (Object)"imageOwner", (Object)imageOwner, (Object)JcloudsLocation.MACHINE_CREATE_ATTEMPTS, (Object)2));
        LOG.info("Provisioned {} vm {}; checking if ssh'able", (Object)this.provider, (Object)machine);
        Assert.assertTrue((boolean)machine.isSshable());
    }

    @Test(groups={"Live"}, dataProvider="fromImageNamePattern")
    public void testProvisionVmUsingImageNamePattern(String regionName, String imageNamePattern, String imageOwner) {
        this.loc = (JcloudsLocation)this.ctx.getLocationRegistry().resolve(String.valueOf(this.provider) + (regionName == null ? "" : ":" + regionName));
        SshMachineLocation machine = this.obtainMachine((Map)MutableMap.of((Object)"imageNameRegex", (Object)imageNamePattern, (Object)"imageOwner", (Object)imageOwner, (Object)JcloudsLocation.MACHINE_CREATE_ATTEMPTS, (Object)2));
        LOG.info("Provisioned {} vm {}; checking if ssh'able", (Object)this.provider, (Object)machine);
        Assert.assertTrue((boolean)machine.isSshable());
    }

    @Test(groups={"Live"}, dataProvider="fromImageDescriptionPattern")
    public void testProvisionVmUsingImageDescriptionPattern(String regionName, String imageDescriptionPattern, String imageOwner) {
        this.loc = (JcloudsLocation)this.ctx.getLocationRegistry().resolve(String.valueOf(this.provider) + (regionName == null ? "" : ":" + regionName));
        SshMachineLocation machine = this.obtainMachine((Map)MutableMap.of((Object)"imageDescriptionRegex", (Object)imageDescriptionPattern, (Object)"imageOwner", (Object)imageOwner, (Object)JcloudsLocation.MACHINE_CREATE_ATTEMPTS, (Object)2));
        LOG.info("Provisioned {} vm {}; checking if ssh'able", (Object)this.provider, (Object)machine);
        Assert.assertTrue((boolean)machine.isSshable());
    }

    protected SshMachineLocation obtainMachine(Map flags) {
        try {
            SshMachineLocation result = (SshMachineLocation)this.loc.obtain(flags);
            this.machines.add(result);
            return result;
        }
        catch (NoMachinesAvailableException nmae) {
            LOG.warn("No machines available", (Throwable)nmae);
            throw Exceptions.propagate((Throwable)nmae);
        }
    }

    protected SshMachineLocation release(SshMachineLocation machine) {
        this.machines.remove(machine);
        this.loc.release((MachineLocation)machine);
        return machine;
    }
}

