/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.networking;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.core.location.access.PortForwardManager;
import org.apache.brooklyn.core.location.access.PortForwardManagerImpl;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsStubbedLiveTest;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.jclouds.networking.JcloudsPortForwarderExtension;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.net.Protocol;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.LoginCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JcloudsPortForwardingStubbedLiveTest
extends AbstractJcloudsStubbedLiveTest {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsPortForwardingStubbedLiveTest.class);

    @Override
    protected AbstractJcloudsStubbedLiveTest.NodeCreator newNodeCreator() {
        return new AbstractJcloudsStubbedLiveTest.NodeCreator(){
            int nextIpSuffix = 2;

            @Override
            protected NodeMetadata newNode(String group, Template template) {
                int ipSuffix = this.nextIpSuffix++;
                NodeMetadata result = new NodeMetadataBuilder().id("myid-" + ipSuffix).credentials(LoginCredentials.builder().identity("myuser").credential("mypassword").build()).loginPort(22).status(NodeMetadata.Status.RUNNING).publicAddresses((Iterable)ImmutableList.of((Object)("173.194.32." + ipSuffix))).privateAddresses((Iterable)ImmutableList.of((Object)("172.168.10." + ipSuffix))).build();
                return result;
            }
        };
    }

    @Test(groups={"Live", "Live-sanity"})
    protected void testPortForwardingCallsForwarder() throws Exception {
        PortForwardManagerImpl pfm = new PortForwardManagerImpl();
        RecordingJcloudsPortForwarderExtension portForwarder = new RecordingJcloudsPortForwarderExtension((PortForwardManager)pfm);
        JcloudsSshMachineLocation machine = this.obtainMachine((Map<?, ?>)ImmutableMap.of((Object)JcloudsLocation.USE_PORT_FORWARDING, (Object)true, (Object)JcloudsLocation.PORT_FORWARDER, (Object)portForwarder));
        NodeMetadata created = this.nodeCreator.created.get(0);
        Assert.assertEquals((int)this.nodeCreator.created.size(), (int)1, (String)("created=" + this.nodeCreator.created + "; machine=" + machine));
        Assert.assertEquals((Object)machine.getNode(), (Object)created);
        Assert.assertEquals((int)portForwarder.opens.size(), (int)1, (String)("opens=" + portForwarder.opens + "; machine=" + machine));
        Assert.assertEquals((Object)portForwarder.opens.get(0).get(0), (Object)created);
        Assert.assertEquals((Object)portForwarder.opens.get(0).get(1), (Object)22);
        Assert.assertEquals((Object)portForwarder.opens.get(0).get(3), (Object)Protocol.TCP);
        Assert.assertEquals((Object)portForwarder.opens.get(0).get(4), (Object)Cidr.UNIVERSAL);
        Assert.assertEquals((Object)machine.getSshHostAndPort(), (Object)HostAndPort.fromParts((String)"1.2.3.4", (int)12345));
        this.releaseMachine(machine);
        String destroyed = this.nodeCreator.destroyed.get(0);
        Assert.assertEquals((int)this.nodeCreator.destroyed.size(), (int)1, (String)("destroyed=" + this.nodeCreator.destroyed + "; machine=" + machine));
        Assert.assertEquals((String)destroyed, (String)created.getId());
        Assert.assertEquals((int)portForwarder.closes.size(), (int)1, (String)("closes=" + portForwarder.closes + "; machine=" + machine));
        Assert.assertEquals((Object)portForwarder.closes.get(0).get(0), (Object)created);
        Assert.assertEquals((Object)portForwarder.closes.get(0).get(1), (Object)22);
        Assert.assertEquals((Object)portForwarder.closes.get(0).get(2), (Object)HostAndPort.fromParts((String)"1.2.3.4", (int)12345));
        Assert.assertEquals((Object)portForwarder.closes.get(0).get(3), (Object)Protocol.TCP);
    }

    @Test(groups={"Live", "Live-sanity"})
    protected void testDeregistersWithPortForwardManagerOnRelease() throws Exception {
        PortForwardManagerImpl pfm = new PortForwardManagerImpl();
        RecordingJcloudsPortForwarderExtension portForwarder = new RecordingJcloudsPortForwarderExtension((PortForwardManager)pfm);
        JcloudsSshMachineLocation machine = this.obtainMachine((Map<?, ?>)ImmutableMap.of((Object)JcloudsLocation.PORT_FORWARDER, (Object)portForwarder, (Object)JcloudsLocation.PORT_FORWARDING_MANAGER, (Object)pfm));
        HostAndPort publicHostAndPort = HostAndPort.fromParts((String)"1.2.3.4", (int)1234);
        pfm.associate("mypublicip", publicHostAndPort, (Location)machine, 80);
        Assert.assertEquals((Object)pfm.lookup((Location)machine, 80), (Object)publicHostAndPort);
        Assert.assertEquals((Object)pfm.lookup("mypublicip", 80), (Object)publicHostAndPort);
        this.releaseMachine(machine);
        Assert.assertNull((Object)pfm.lookup((Location)machine, 80));
        Assert.assertNull((Object)pfm.lookup("mypublicip", 80));
        Assert.assertEquals((int)portForwarder.closes.size(), (int)1, (String)("closes=" + portForwarder.closes + "; machine=" + machine));
        Assert.assertEquals((Object)portForwarder.closes.get(0).get(1), (Object)80);
        Assert.assertEquals((Object)portForwarder.closes.get(0).get(2), (Object)HostAndPort.fromParts((String)"1.2.3.4", (int)1234));
        Assert.assertEquals((Object)portForwarder.closes.get(0).get(3), (Object)Protocol.TCP);
    }

    @Test(groups={"Live", "Live-sanity"})
    protected void testReleaseVmDoesNotImpactOtherVms() throws Exception {
        PortForwardManagerImpl pfm = new PortForwardManagerImpl();
        RecordingJcloudsPortForwarderExtension portForwarder = new RecordingJcloudsPortForwarderExtension((PortForwardManager)pfm);
        JcloudsSshMachineLocation machine1 = this.obtainMachine((Map<?, ?>)ImmutableMap.of((Object)JcloudsLocation.USE_PORT_FORWARDING, (Object)true, (Object)JcloudsLocation.PORT_FORWARDER, (Object)portForwarder, (Object)JcloudsLocation.PORT_FORWARDING_MANAGER, (Object)pfm));
        JcloudsSshMachineLocation machine2 = this.obtainMachine((Map<?, ?>)ImmutableMap.of((Object)JcloudsLocation.USE_PORT_FORWARDING, (Object)true, (Object)JcloudsLocation.PORT_FORWARDER, (Object)portForwarder, (Object)JcloudsLocation.PORT_FORWARDING_MANAGER, (Object)pfm));
        NodeMetadata node1 = this.nodeCreator.created.get(0);
        HostAndPort publicHostAndPort = HostAndPort.fromParts((String)"1.2.3.4", (int)1234);
        pfm.associate("mypublicip", publicHostAndPort, (Location)machine2, 80);
        this.releaseMachine(machine1);
        Assert.assertEquals((Object)pfm.lookup((Location)machine2, 80), (Object)publicHostAndPort);
        Assert.assertEquals((Object)pfm.lookup("mypublicip", 80), (Object)publicHostAndPort);
        Assert.assertEquals((int)portForwarder.closes.size(), (int)1, (String)("closes=" + portForwarder.closes + "; machine1=" + machine1));
        Assert.assertEquals((Object)portForwarder.closes.get(0).get(0), (Object)node1);
        Assert.assertEquals((Object)portForwarder.closes.get(0).get(1), (Object)22);
    }

    static class RecordingJcloudsPortForwarderExtension
    implements JcloudsPortForwarderExtension {
        final PortForwardManager pfm;
        final List<List<Object>> opens = Lists.newCopyOnWriteArrayList();
        final List<List<Object>> closes = Lists.newCopyOnWriteArrayList();
        int nextPublicPort = 12345;

        RecordingJcloudsPortForwarderExtension(PortForwardManager pfm) {
            this.pfm = pfm;
        }

        public HostAndPort openPortForwarding(NodeMetadata node, int targetPort, Optional<Integer> optionalPublicPort, Protocol protocol, Cidr accessingCidr) {
            this.opens.add((List<Object>)ImmutableList.of((Object)node, (Object)targetPort, optionalPublicPort, (Object)protocol, (Object)accessingCidr));
            HostAndPort result = HostAndPort.fromParts((String)"1.2.3.4", (int)this.nextPublicPort++);
            this.pfm.associate(node.getId(), result, targetPort);
            return result;
        }

        public void closePortForwarding(NodeMetadata node, int targetPort, HostAndPort publicHostAndPort, Protocol protocol) {
            this.closes.add((List<Object>)ImmutableList.of((Object)node, (Object)targetPort, (Object)publicHostAndPort, (Object)protocol));
            this.pfm.forgetPortMapping(node.getId(), publicHostAndPort.getPort());
        }
    }
}

