/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.networking;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.networking.JcloudsLocationSecurityGroupCustomizer;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.net.Cidr;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JcloudsLocationSecurityGroupCustomizerTest {
    JcloudsLocationSecurityGroupCustomizer customizer;
    ComputeService computeService;
    Location location;
    SecurityGroupExtension securityApi;

    @BeforeMethod
    public void setUp() {
        this.customizer = new JcloudsLocationSecurityGroupCustomizer("testapp", (Supplier)new TestCidrSupplier());
        this.location = (Location)Mockito.mock(Location.class);
        this.securityApi = (SecurityGroupExtension)Mockito.mock(SecurityGroupExtension.class);
        this.computeService = (ComputeService)Mockito.mock(ComputeService.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        Mockito.when((Object)this.computeService.getSecurityGroupExtension()).thenReturn((Object)Optional.of((Object)this.securityApi));
    }

    @Test
    public void testSameInstanceReturnedForSameApplication() {
        Assert.assertEquals((Object)JcloudsLocationSecurityGroupCustomizer.getInstance((String)"a"), (Object)JcloudsLocationSecurityGroupCustomizer.getInstance((String)"a"));
        Assert.assertNotEquals((Object)JcloudsLocationSecurityGroupCustomizer.getInstance((String)"a"), (Object)JcloudsLocationSecurityGroupCustomizer.getInstance((String)"b"));
    }

    @Test
    public void testSecurityGroupAddedWhenJcloudsLocationCustomised() {
        Template template = (Template)Mockito.mock(Template.class);
        TemplateOptions templateOptions = (TemplateOptions)Mockito.mock(TemplateOptions.class);
        Mockito.when((Object)template.getLocation()).thenReturn((Object)this.location);
        Mockito.when((Object)template.getOptions()).thenReturn((Object)templateOptions);
        SecurityGroup group = this.newGroup("id");
        Mockito.when((Object)this.securityApi.createSecurityGroup(Matchers.anyString(), (Location)Matchers.eq((Object)this.location))).thenReturn((Object)group);
        JcloudsLocation jcloudsLocationA = new JcloudsLocation((Map)MutableMap.of((Object)"deferConstruction", (Object)true));
        JcloudsLocation jcloudsLocationB = new JcloudsLocation((Map)MutableMap.of((Object)"deferConstruction", (Object)true));
        this.customizer.customize(jcloudsLocationA, this.computeService, template);
        this.customizer.customize(jcloudsLocationB, this.computeService, template);
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi)).createSecurityGroup(Matchers.anyString(), (Location)Matchers.eq((Object)this.location));
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.times((int)4))).addIpPermission((IpPermission)Matchers.any(IpPermission.class), (SecurityGroup)Matchers.eq((Object)group));
        ((TemplateOptions)Mockito.verify((Object)templateOptions, (VerificationMode)Mockito.times((int)2))).securityGroups(new String[]{Matchers.anyString()});
    }

    @Test
    public void testSharedGroupLoadedWhenItExistsButIsNotCached() {
        Template template = (Template)Mockito.mock(Template.class);
        TemplateOptions templateOptions = (TemplateOptions)Mockito.mock(TemplateOptions.class);
        Mockito.when((Object)template.getLocation()).thenReturn((Object)this.location);
        Mockito.when((Object)template.getOptions()).thenReturn((Object)templateOptions);
        JcloudsLocation jcloudsLocation = new JcloudsLocation((Map)MutableMap.of((Object)"deferConstruction", (Object)true));
        SecurityGroup shared = this.newGroup(this.customizer.getNameForSharedSecurityGroup());
        SecurityGroup irrelevant = this.newGroup("irrelevant");
        Mockito.when((Object)this.securityApi.listSecurityGroupsInLocation(this.location)).thenReturn((Object)ImmutableSet.of((Object)irrelevant, (Object)shared));
        this.customizer.customize(jcloudsLocation, this.computeService, template);
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi)).listSecurityGroupsInLocation(this.location);
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.never())).createSecurityGroup(Matchers.anyString(), (Location)Matchers.any(Location.class));
    }

    @Test
    public void testAddPermissionsToNode() {
        IpPermission ssh = this.newPermission(22);
        IpPermission jmx = this.newPermission(31001);
        String nodeId = "node";
        SecurityGroup sharedGroup = this.newGroup(this.customizer.getNameForSharedSecurityGroup());
        SecurityGroup group = this.newGroup("id");
        Mockito.when((Object)this.securityApi.listSecurityGroupsForNode(nodeId)).thenReturn((Object)ImmutableSet.of((Object)sharedGroup, (Object)group));
        Mockito.when((Object)this.computeService.getContext().unwrap().getId()).thenReturn((Object)"aws-ec2");
        this.customizer.addPermissionsToLocation((Iterable)ImmutableList.of((Object)ssh, (Object)jmx), nodeId, this.computeService);
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.never())).createSecurityGroup(Matchers.anyString(), (Location)Matchers.any(Location.class));
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.times((int)1))).addIpPermission(ssh, group);
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.times((int)1))).addIpPermission(jmx, group);
    }

    @Test
    public void testAddPermissionsToNodeUsesUncachedSecurityGroup() {
        JcloudsLocation jcloudsLocation = new JcloudsLocation((Map)MutableMap.of((Object)"deferConstruction", (Object)true));
        IpPermission ssh = this.newPermission(22);
        String nodeId = "nodeId";
        SecurityGroup sharedGroup = this.newGroup(this.customizer.getNameForSharedSecurityGroup());
        SecurityGroup uniqueGroup = this.newGroup("unique");
        Template template = (Template)Mockito.mock(Template.class);
        TemplateOptions templateOptions = (TemplateOptions)Mockito.mock(TemplateOptions.class);
        Mockito.when((Object)template.getLocation()).thenReturn((Object)this.location);
        Mockito.when((Object)template.getOptions()).thenReturn((Object)templateOptions);
        Mockito.when((Object)this.securityApi.createSecurityGroup(Matchers.anyString(), (Location)Matchers.eq((Object)this.location))).thenReturn((Object)sharedGroup);
        Mockito.when((Object)this.computeService.getContext().unwrap().getId()).thenReturn((Object)"aws-ec2");
        this.customizer.customize(jcloudsLocation, this.computeService, template);
        Mockito.reset((Object[])new SecurityGroupExtension[]{this.securityApi});
        Mockito.when((Object)this.securityApi.listSecurityGroupsForNode(nodeId)).thenReturn((Object)ImmutableSet.of((Object)uniqueGroup, (Object)sharedGroup));
        this.customizer.addPermissionsToLocation((Iterable)ImmutableSet.of((Object)ssh), nodeId, this.computeService);
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi)).addIpPermission(ssh, uniqueGroup);
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.never())).addIpPermission((IpPermission)Matchers.any(IpPermission.class), (SecurityGroup)Matchers.eq((Object)sharedGroup));
    }

    @Test
    public void testSecurityGroupsLoadedWhenAddingPermissionsToUncachedNode() {
        IpPermission ssh = this.newPermission(22);
        String nodeId = "nodeId";
        SecurityGroup sharedGroup = this.newGroup(this.customizer.getNameForSharedSecurityGroup());
        SecurityGroup uniqueGroup = this.newGroup("unique");
        Mockito.when((Object)this.securityApi.listSecurityGroupsForNode(nodeId)).thenReturn((Object)ImmutableSet.of((Object)sharedGroup, (Object)uniqueGroup));
        Mockito.when((Object)this.computeService.getContext().unwrap().getId()).thenReturn((Object)"aws-ec2");
        this.customizer.addPermissionsToLocation((Iterable)ImmutableSet.of((Object)ssh), nodeId, this.computeService);
        this.customizer.addPermissionsToLocation((Iterable)ImmutableSet.of((Object)ssh), nodeId, this.computeService);
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.times((int)1))).listSecurityGroupsForNode(nodeId);
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.times((int)2))).addIpPermission(ssh, uniqueGroup);
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.never())).addIpPermission((IpPermission)Matchers.any(IpPermission.class), (SecurityGroup)Matchers.eq((Object)sharedGroup));
    }

    @Test
    public void testAddRuleNotRetriedByDefault() {
        IpPermission ssh = this.newPermission(22);
        String nodeId = "node";
        SecurityGroup sharedGroup = this.newGroup(this.customizer.getNameForSharedSecurityGroup());
        SecurityGroup uniqueGroup = this.newGroup("unique");
        Mockito.when((Object)this.securityApi.listSecurityGroupsForNode(nodeId)).thenReturn((Object)ImmutableSet.of((Object)sharedGroup, (Object)uniqueGroup));
        Mockito.when((Object)this.securityApi.addIpPermission((IpPermission)Matchers.eq((Object)ssh), (SecurityGroup)Matchers.eq((Object)uniqueGroup))).thenThrow(new Throwable[]{new RuntimeException("exception creating " + ssh)});
        Mockito.when((Object)this.computeService.getContext().unwrap().getId()).thenReturn((Object)"aws-ec2");
        try {
            this.customizer.addPermissionsToLocation((Iterable)ImmutableList.of((Object)ssh), nodeId, this.computeService);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("repeated errors from provider"), (String)("message=" + e.getMessage()));
        }
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.never())).createSecurityGroup(Matchers.anyString(), (Location)Matchers.any(Location.class));
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.times((int)1))).addIpPermission(ssh, uniqueGroup);
    }

    @Test
    public void testCustomExceptionRetryablePredicate() {
        Predicate<Exception> messageChecker = new Predicate<Exception>(){

            public boolean apply(Exception input) {
                Throwable t = input;
                while (t != null) {
                    if (t.getMessage().contains("testCustomExceptionRetryablePredicate")) {
                        return true;
                    }
                    t = t.getCause();
                }
                return false;
            }
        };
        this.customizer.setRetryExceptionPredicate((Predicate)messageChecker);
        Mockito.when((Object)this.computeService.getContext().unwrap().getId()).thenReturn((Object)"aws-ec2");
        IpPermission ssh = this.newPermission(22);
        String nodeId = "node";
        SecurityGroup sharedGroup = this.newGroup(this.customizer.getNameForSharedSecurityGroup());
        SecurityGroup uniqueGroup = this.newGroup("unique");
        Mockito.when((Object)this.securityApi.listSecurityGroupsForNode(nodeId)).thenReturn((Object)ImmutableSet.of((Object)sharedGroup, (Object)uniqueGroup));
        Mockito.when((Object)this.securityApi.addIpPermission((IpPermission)Matchers.eq((Object)ssh), (SecurityGroup)Matchers.eq((Object)uniqueGroup))).thenThrow(new Throwable[]{new RuntimeException(new Exception("testCustomExceptionRetryablePredicate"))}).thenThrow(new Throwable[]{new RuntimeException(new Exception("testCustomExceptionRetryablePredicate"))}).thenReturn((Object)sharedGroup);
        this.customizer.addPermissionsToLocation((Iterable)ImmutableList.of((Object)ssh), nodeId, this.computeService);
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.never())).createSecurityGroup(Matchers.anyString(), (Location)Matchers.any(Location.class));
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.times((int)3))).addIpPermission(ssh, uniqueGroup);
    }

    @Test
    public void testAddRuleRetriedOnAwsFailure() {
        IpPermission ssh = this.newPermission(22);
        String nodeId = "nodeId";
        SecurityGroup sharedGroup = this.newGroup(this.customizer.getNameForSharedSecurityGroup());
        SecurityGroup uniqueGroup = this.newGroup("unique");
        this.customizer.setRetryExceptionPredicate(JcloudsLocationSecurityGroupCustomizer.newAwsExceptionRetryPredicate());
        Mockito.when((Object)this.securityApi.listSecurityGroupsForNode(nodeId)).thenReturn((Object)ImmutableSet.of((Object)sharedGroup, (Object)uniqueGroup));
        Mockito.when((Object)this.securityApi.addIpPermission((IpPermission)Matchers.any(IpPermission.class), (SecurityGroup)Matchers.eq((Object)uniqueGroup))).thenThrow(new Throwable[]{this.newAwsResponseExceptionWithCode("InvalidGroup.InUse")}).thenThrow(new Throwable[]{this.newAwsResponseExceptionWithCode("DependencyViolation")}).thenThrow(new Throwable[]{this.newAwsResponseExceptionWithCode("RequestLimitExceeded")}).thenThrow(new Throwable[]{this.newAwsResponseExceptionWithCode("Blocked")}).thenReturn((Object)sharedGroup);
        Mockito.when((Object)this.computeService.getContext().unwrap().getId()).thenReturn((Object)"aws-ec2");
        try {
            this.customizer.addPermissionsToLocation((Iterable)ImmutableList.of((Object)ssh), nodeId, this.computeService);
        }
        catch (Exception e) {
            String expected = "repeated errors from provider";
            Assert.assertTrue((boolean)e.getMessage().contains(expected), (String)("expected exception message to contain " + expected + ", was: " + e.getMessage()));
        }
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.never())).createSecurityGroup(Matchers.anyString(), (Location)Matchers.any(Location.class));
        ((SecurityGroupExtension)Mockito.verify((Object)this.securityApi, (VerificationMode)Mockito.times((int)4))).addIpPermission(ssh, uniqueGroup);
    }

    private SecurityGroup newGroup(String id) {
        URI uri = null;
        String ownerId = null;
        return new SecurityGroup("providerId", id, id, this.location, uri, Collections.emptyMap(), (Set)ImmutableSet.of(), (Iterable)ImmutableSet.of(), ownerId);
    }

    private IpPermission newPermission(int port) {
        return IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(port).toPort(port).cidrBlock("0.0.0.0/0").build();
    }

    private AWSError newAwsErrorWithCode(String code) {
        AWSError e = new AWSError();
        e.setCode(code);
        return e;
    }

    private Exception newAwsResponseExceptionWithCode(String code) {
        AWSResponseException e = new AWSResponseException("irrelevant message", null, null, this.newAwsErrorWithCode(code));
        return new RuntimeException((Throwable)e);
    }

    private static class TestCidrSupplier
    implements Supplier<Cidr> {
        private TestCidrSupplier() {
        }

        public Cidr get() {
            return new Cidr("192.168.10.10/32");
        }
    }
}

