/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.util.text.Identifiers;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StandaloneJcloudsLiveTest {
    public static final Logger LOG = LoggerFactory.getLogger(StandaloneJcloudsLiveTest.class);
    private static final String PROVIDER = "aws-ec2";
    private static final String REGION = "us-east-1";
    private static final String PRIVATE_IMAGE_ID = "us-east-1/ami-f95cf390";
    static BrooklynProperties globals = BrooklynProperties.Factory.newDefault();
    String identity = globals.getFirst(new String[]{"brooklyn.location.jclouds.aws-ec2.identity"});
    String credential = globals.getFirst(new String[]{"brooklyn.location.jclouds.aws-ec2.credential"});

    @Test(enabled=false, groups={"WIP", "Live"})
    public void createVm() {
        String groupId = "mygroup-" + System.getProperty("user.name") + "-" + UUID.randomUUID().toString();
        Properties properties = new Properties();
        properties.setProperty("jclouds.trust-all-certs", Boolean.toString(true));
        properties.setProperty("jclouds.relax-hostname", Boolean.toString(true));
        ComputeServiceContext computeServiceContext = (ComputeServiceContext)ContextBuilder.newBuilder((String)PROVIDER).modules(Arrays.asList(new SshjSshClientModule(), new SLF4JLoggingModule())).credentials(this.identity, this.credential).overrides(properties).build(ComputeServiceContext.class);
        ComputeService computeService = computeServiceContext.getComputeService();
        NodeMetadata node = null;
        try {
            try {
                LOG.info("Creating VM for " + this.identity);
                TemplateBuilder templateBuilder = computeService.templateBuilder();
                templateBuilder.locationId(REGION);
                Template template = templateBuilder.build();
                Set nodes = computeService.createNodesInGroup(groupId, 1, template);
                node = (NodeMetadata)Iterables.getOnlyElement((Iterable)nodes, null);
                if (node == null) {
                    throw new IllegalStateException("No nodes returned");
                }
                Assert.assertNotNull((Object)node.getOperatingSystem());
                LoginCredentials nodeCredentials = node.getCredentials();
                LoginCredentials expectedCredentials = LoginCredentials.fromCredentials((Credentials)nodeCredentials);
                LOG.info("Started VM, waiting for it to be sshable");
                boolean reachable = false;
                int i = 0;
                while (i < 120) {
                    try {
                        Statement statement = Statements.newStatementList((Statement[])new Statement[]{Statements.exec((String)"date")});
                        ExecResponse response = computeService.runScriptOnNode(node.getId(), statement, RunScriptOptions.Builder.overrideLoginCredentials((LoginCredentials)expectedCredentials));
                        if (response.getExitStatus() == 0) {
                            LOG.info("ssh 'date' succeeded");
                            reachable = true;
                            break;
                        }
                        LOG.info("ssh 'date' failed, exit " + response.getExitStatus() + ", but still in retry loop");
                    }
                    catch (Exception e) {
                        if (i < 120) {
                            LOG.info("ssh 'date' failed, but still in retry loop: " + e);
                        }
                        LOG.error("ssh 'date' failed after timeout: " + e, (Throwable)e);
                        Throwables.propagate((Throwable)e);
                    }
                    Thread.sleep(1000L);
                    ++i;
                }
                if (!reachable) {
                    throw new IllegalStateException("SSH failed, never reachable");
                }
            }
            catch (RunNodesException e) {
                if (e.getNodeErrors().size() > 0) {
                    node = (NodeMetadata)Iterables.get(e.getNodeErrors().keySet(), (int)0);
                }
                LOG.error("Failed to start VM: " + (Object)((Object)e), (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
            catch (Exception e) {
                LOG.error("Failed to start VM: " + e, (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            LOG.info("Now destroying VM: " + node);
            computeService.destroyNode(node.getId());
            computeService.getContext().close();
            throw throwable;
        }
        LOG.info("Now destroying VM: " + node);
        computeService.destroyNode(node.getId());
        computeService.getContext().close();
    }

    @Test(enabled=false, groups={"WIP", "Live"})
    public void createVmWithAdminUser() {
        String groupId = "mygroup-" + System.getProperty("user.name") + "-" + UUID.randomUUID().toString();
        Properties properties = new Properties();
        properties.setProperty("jclouds.trust-all-certs", Boolean.toString(true));
        properties.setProperty("jclouds.relax-hostname", Boolean.toString(true));
        ComputeServiceContext computeServiceContext = (ComputeServiceContext)ContextBuilder.newBuilder((String)PROVIDER).modules(Arrays.asList(new SshjSshClientModule(), new SLF4JLoggingModule())).credentials(this.identity, this.credential).overrides(properties).build(ComputeServiceContext.class);
        ComputeService computeService = computeServiceContext.getComputeService();
        NodeMetadata node = null;
        try {
            try {
                LOG.info("Creating VM for " + this.identity);
                String myPubKey = Files.toString((File)new File(String.valueOf(System.getProperty("user.home")) + "/.ssh/aws-id_rsa.pub"), (Charset)Charset.defaultCharset());
                String myPrivKey = Files.toString((File)new File(String.valueOf(System.getProperty("user.home")) + "/.ssh/aws-id_rsa"), (Charset)Charset.defaultCharset());
                TemplateBuilder templateBuilder = computeService.templateBuilder();
                templateBuilder.locationId(REGION);
                TemplateOptions opts = new TemplateOptions();
                templateBuilder.imageId(PRIVATE_IMAGE_ID);
                opts.overrideLoginUser("ec2-user");
                AdminAccess.Builder adminBuilder = AdminAccess.builder().adminUsername("bob").grantSudoToAdminUser(true).authorizeAdminPublicKey(true).adminPublicKey(myPubKey).lockSsh(true).adminPassword(Identifiers.makeRandomId((int)12)).resetLoginPassword(false).loginPassword(Identifiers.makeRandomId((int)12)).installAdminPrivateKey(false).adminPrivateKey("ignored");
                opts.runScript((Statement)adminBuilder.build());
                templateBuilder.options(opts);
                Template template = templateBuilder.build();
                Set nodes = computeService.createNodesInGroup(groupId, 1, template);
                node = (NodeMetadata)Iterables.getOnlyElement((Iterable)nodes, null);
                if (node == null) {
                    throw new IllegalStateException("No nodes returned");
                }
                LOG.info("Started VM, waiting for it to be sshable on " + node.getPublicAddresses());
                LoginCredentials crds = LoginCredentials.builder().user("bob").privateKey(myPrivKey).build();
                boolean reachable = false;
                int i = 0;
                while (i < 120) {
                    try {
                        Statement statement = Statements.newStatementList((Statement[])new Statement[]{Statements.exec((String)"date")});
                        ExecResponse response = computeService.runScriptOnNode(node.getId(), statement, RunScriptOptions.Builder.overrideLoginCredentials((LoginCredentials)crds));
                        if (response.getExitStatus() == 0) {
                            LOG.info("ssh 'date' succeeded");
                            reachable = true;
                            break;
                        }
                        LOG.info("ssh 'date' failed, exit " + response.getExitStatus() + ", but still in retry loop");
                    }
                    catch (Exception e) {
                        if (i < 120) {
                            LOG.info("ssh 'date' failed, but still in retry loop: " + e);
                        }
                        LOG.error("ssh 'date' failed after timeout: " + e, (Throwable)e);
                        Throwables.propagate((Throwable)e);
                    }
                    Thread.sleep(1000L);
                    ++i;
                }
                if (!reachable) {
                    throw new IllegalStateException("SSH failed, never reachable");
                }
            }
            catch (RunNodesException e) {
                if (e.getNodeErrors().size() > 0) {
                    node = (NodeMetadata)Iterables.get(e.getNodeErrors().keySet(), (int)0);
                }
                LOG.error("Failed to start VM: " + (Object)((Object)e), (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
            catch (Exception e) {
                LOG.error("Failed to start VM: " + e, (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            LOG.info("Now destroying VM: " + node);
            computeService.destroyNode(node.getId());
            computeService.getContext().close();
            throw throwable;
        }
        LOG.info("Now destroying VM: " + node);
        computeService.destroyNode(node.getId());
        computeService.getContext().close();
    }
}

