/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import java.util.Map;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.location.byon.SingleMachineProvisioningLocation;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsLiveTest;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SingleMachineProvisioningLocationJcloudsLiveTest
extends AbstractJcloudsLiveTest {
    private static final Logger log = LoggerFactory.getLogger(SingleMachineProvisioningLocation.class);
    private SingleMachineProvisioningLocation<JcloudsSshMachineLocation> location;
    private static final String JCLOUDS_LOCATION_SPEC = "jclouds:aws-ec2:us-east-1";

    @Test(groups={"Live"})
    public void testJcloudsSingle() throws Exception {
        this.location = this.resolve("single:(target='jclouds:aws-ec2:us-east-1')");
        JcloudsSshMachineLocation m1 = this.obtainMachine();
        Assert.assertNotNull((Object)m1);
        log.info("GOT " + m1);
    }

    @Test(groups={"Live"})
    public void testJcloudsSingleRelease() throws Exception {
        this.location = this.resolve("single:(target='jclouds:aws-ec2:us-east-1')");
        JcloudsSshMachineLocation m1 = this.obtainMachine();
        log.info("GOT " + m1);
        JcloudsSshMachineLocation m2 = this.obtainMachine();
        log.info("GOT " + m2);
        Assert.assertSame((Object)m1, (Object)m2);
        this.location.release((MachineLocation)m1);
        Assert.assertTrue((boolean)m2.isSshable());
        this.location.release((MachineLocation)m2);
        Assert.assertFalse((boolean)m2.isSshable());
    }

    @Test(groups={"Live"})
    public void testJcloudsSingleObtainReleaseObtain() throws Exception {
        this.location = this.resolve("single:(target='jclouds:aws-ec2:us-east-1')");
        JcloudsSshMachineLocation m1 = this.obtainMachine();
        log.info("GOT " + m1);
        this.location.release((MachineLocation)m1);
        Assert.assertFalse((boolean)m1.isSshable());
        JcloudsSshMachineLocation m2 = this.obtainMachine();
        Assert.assertTrue((boolean)m2.isSshable());
        Assert.assertNotEquals((Object)m1, (Object)m2);
        this.location.release((MachineLocation)m2);
        Assert.assertFalse((boolean)m2.isSshable());
    }

    @Test(groups={"Live"})
    public void testJCloudsNamedSingle() throws Exception {
        this.brooklynProperties.put(ConfigKeys.newStringConfigKey((String)"brooklyn.location.named.FooServers"), (Object)JCLOUDS_LOCATION_SPEC);
        this.location = this.resolve("single:(target='named:FooServers')");
        JcloudsSshMachineLocation m1 = this.obtainMachine();
        Assert.assertTrue((boolean)m1.isSshable());
        this.location.release((MachineLocation)m1);
        Assert.assertFalse((boolean)m1.isSshable());
    }

    @Override
    protected JcloudsSshMachineLocation obtainMachine(Map<?, ?> conf) throws Exception {
        JcloudsSshMachineLocation result = (JcloudsSshMachineLocation)this.location.obtain(conf);
        this.machines.add(result);
        return result;
    }

    @Override
    protected void releaseMachine(JcloudsSshMachineLocation machine) {
        if (this.location.getChildren().contains(machine)) {
            this.machines.remove(machine);
            this.location.release((MachineLocation)machine);
        }
    }

    private SingleMachineProvisioningLocation<JcloudsSshMachineLocation> resolve(String spec) {
        SingleMachineProvisioningLocation result = (SingleMachineProvisioningLocation)this.managementContext.getLocationRegistry().resolve(spec);
        return result;
    }
}

