/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsLiveTest;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SimpleJcloudsLocationUserLoginAndConfigLiveTest
extends AbstractJcloudsLiveTest {
    private static final String LOCATION_SPEC = "aws-ec2:us-east-1";
    private static final Logger log = LoggerFactory.getLogger(SimpleJcloudsLocationUserLoginAndConfigLiveTest.class);
    public static final String EC2_CENTOS_IMAGE = "us-east-1/ami-f95cf390";

    @Override
    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.jcloudsLocation = this.resolve(LOCATION_SPEC);
    }

    @Test(groups={"Live"})
    public void testJcloudsCreateBogStandard() throws Exception {
        log.info("TEST testJcloudsCreateBogStandard");
        JcloudsSshMachineLocation m1 = this.obtainMachine((Map<?, ?>)ImmutableMap.of());
        MutableMap details = MutableMap.of((Object)"id", (Object)m1.getJcloudsId(), (Object)"hostname", (Object)m1.getAddress().getHostAddress(), (Object)"user", (Object)m1.getUser());
        log.info("got machine " + m1 + " at " + this.jcloudsLocation + ": " + details + "; now trying to rebind");
        String result = this.execWithOutput((SshMachineLocation)m1, Arrays.asList("echo trying  m1", "hostname", "date"));
        Assert.assertTrue((boolean)result.contains("trying m1"));
        log.info("now trying rebind " + m1);
        JcloudsSshMachineLocation m2 = this.jcloudsLocation.rebindMachine((Map)details);
        result = this.execWithOutput((SshMachineLocation)m2, Arrays.asList("echo trying  m2", "hostname", "date"));
        Assert.assertTrue((boolean)result.contains("trying m2"));
    }

    @Test(groups={"Live"})
    public void testJcloudsCreateBogStandardWithUserBrooklyn() throws Exception {
        log.info("TEST testJcloudsCreateBogStandardWithUserBrooklyn");
        JcloudsSshMachineLocation m1 = this.obtainMachine((Map<?, ?>)MutableMap.of((Object)"user", (Object)"brooklyn"));
        MutableMap details = MutableMap.of((Object)"id", (Object)m1.getJcloudsId(), (Object)"hostname", (Object)m1.getAddress().getHostAddress(), (Object)"user", (Object)m1.getUser());
        log.info("got machine " + m1 + " at " + this.jcloudsLocation + ": " + details + "; now trying to rebind");
        String result = this.execWithOutput((SshMachineLocation)m1, Arrays.asList("echo trying  m1", "hostname", "date"));
        Assert.assertTrue((boolean)result.contains("trying m1"));
        log.info("now trying rebind " + m1);
        JcloudsSshMachineLocation m2 = this.jcloudsLocation.rebindMachine((Map)details);
        result = this.execWithOutput((SshMachineLocation)m2, Arrays.asList("echo trying  m2", "hostname", "date"));
        Assert.assertTrue((boolean)result.contains("trying m2"));
        Assert.assertEquals((String)m2.getUser(), (String)"brooklyn");
    }

    @Test(groups={"Live"})
    public void testJcloudsCreateUserMetadata() throws Exception {
        log.info("TEST testJcloudsCreateBogStandard");
        String key = "brooklyn-test-user-data";
        String value = "test-" + Identifiers.makeRandomId((int)4);
        JcloudsSshMachineLocation m1 = this.obtainMachine((Map<?, ?>)MutableMap.of((Object)"userMetadata", (Object)(String.valueOf(key) + "=" + value)));
        MutableMap details = MutableMap.of((Object)"id", (Object)m1.getJcloudsId(), (Object)"hostname", (Object)m1.getAddress().getHostAddress(), (Object)"user", (Object)m1.getUser(), (Object)"userMetadata", (Object)(String.valueOf(key) + "=" + value));
        Assert.assertEquals((String)((String)m1.node.getUserMetadata().get(key)), (String)value);
        log.info("got machine " + m1 + " at " + this.jcloudsLocation + ": " + details + "; now trying to rebind");
        String result = this.execWithOutput((SshMachineLocation)m1, Arrays.asList("echo trying  m1", "hostname", "date"));
        Assert.assertTrue((boolean)result.contains("trying m1"));
        log.info("now trying rebind " + m1);
        JcloudsSshMachineLocation m2 = this.jcloudsLocation.rebindMachine((Map)details);
        result = this.execWithOutput((SshMachineLocation)m2, Arrays.asList("echo trying  m2", "hostname", "date"));
        Assert.assertTrue((boolean)result.contains("trying m2"));
        Assert.assertEquals((String)((String)m2.node.getUserMetadata().get(key)), (String)value);
    }

    @Test(groups={"Live"})
    public void testJcloudsMissingUser() throws Exception {
        log.info("TEST testJcloudsMissingUser");
        try {
            this.obtainMachine((Map<?, ?>)MutableMap.of((Object)"imageId", (Object)EC2_CENTOS_IMAGE, (Object)"waitForSshable", (Object)30000));
            log.info("whoops we logged in");
        }
        catch (NoMachinesAvailableException e) {
            log.info("got error as expected, for missing user: " + (Object)((Object)e));
        }
    }

    @Test(groups={"Live"})
    public void testJcloudsWithSpecificLoginUserAndSameUser() throws Exception {
        log.info("TEST testJcloudsWithSpecificLoginUserAndSameUser");
        JcloudsSshMachineLocation m1 = this.obtainMachine((Map<?, ?>)MutableMap.of((Object)"imageId", (Object)EC2_CENTOS_IMAGE, (Object)"loginUser", (Object)"ec2-user", (Object)"user", (Object)"ec2-user", (Object)"waitForSshable", (Object)30000));
        MutableMap details = MutableMap.of((Object)"id", (Object)m1.getJcloudsId(), (Object)"hostname", (Object)m1.getAddress().getHostAddress(), (Object)"user", (Object)m1.getUser());
        log.info("got machine " + m1 + " at " + this.jcloudsLocation + ": " + details + "; now trying to rebind");
        String result = this.execWithOutput((SshMachineLocation)m1, Arrays.asList("echo trying  m1", "hostname", "date"));
        Assert.assertTrue((boolean)result.contains("trying m1"));
        log.info("now trying rebind " + m1);
        JcloudsSshMachineLocation m2 = this.jcloudsLocation.rebindMachine((Map)details);
        result = this.execWithOutput((SshMachineLocation)m2, Arrays.asList("echo trying  m2", "hostname", "date"));
        Assert.assertTrue((boolean)result.contains("trying m2"));
        Assert.assertEquals((String)m2.getUser(), (String)"ec2-user");
    }

    @Test(groups={"Live"})
    public void testJcloudsWithSpecificLoginUserAndNewUser() throws Exception {
        log.info("TEST testJcloudsWithSpecificLoginUserAndNewUser");
        JcloudsSshMachineLocation m1 = this.obtainMachine((Map<?, ?>)MutableMap.of((Object)"imageId", (Object)EC2_CENTOS_IMAGE, (Object)"loginUser", (Object)"ec2-user", (Object)"user", (Object)"newbob", (Object)"waitForSshable", (Object)30000));
        MutableMap details = MutableMap.of((Object)"id", (Object)m1.getJcloudsId(), (Object)"hostname", (Object)m1.getAddress().getHostAddress(), (Object)"user", (Object)m1.getUser());
        log.info("got machine " + m1 + " at " + this.jcloudsLocation + ": " + details + "; now trying to rebind");
        String result = this.execWithOutput((SshMachineLocation)m1, Arrays.asList("echo trying  m1", "hostname", "date"));
        Assert.assertTrue((boolean)result.contains("trying m1"));
        log.info("now trying rebind " + m1);
        JcloudsSshMachineLocation m2 = this.jcloudsLocation.rebindMachine((Map)details);
        result = this.execWithOutput((SshMachineLocation)m2, Arrays.asList("echo trying  m2", "hostname", "date"));
        Assert.assertTrue((boolean)result.contains("trying m2"));
        Assert.assertEquals((String)m2.getUser(), (String)"newbob");
    }

    @Test(groups={"Live"})
    public void testJcloudsWithSpecificLoginUserAndDefaultUser() throws Exception {
        log.info("TEST testJcloudsWithSpecificLoginUserAndDefaultUser");
        JcloudsSshMachineLocation m1 = this.obtainMachine((Map<?, ?>)MutableMap.of((Object)"imageId", (Object)EC2_CENTOS_IMAGE, (Object)"loginUser", (Object)"ec2-user", (Object)"waitForSshable", (Object)30000));
        MutableMap details = MutableMap.of((Object)"id", (Object)m1.getJcloudsId(), (Object)"hostname", (Object)m1.getAddress().getHostAddress(), (Object)"user", (Object)m1.getUser());
        log.info("got machine " + m1 + " at " + this.jcloudsLocation + ": " + details + "; now trying to rebind");
        String result = this.execWithOutput((SshMachineLocation)m1, Arrays.asList("echo trying  m1", "hostname", "date"));
        Assert.assertTrue((boolean)result.contains("trying m1"));
        log.info("now trying rebind " + m1);
        JcloudsSshMachineLocation m2 = this.jcloudsLocation.rebindMachine((Map)details);
        result = this.execWithOutput((SshMachineLocation)m2, Arrays.asList("echo trying  m2", "hostname", "date"));
        Assert.assertTrue((boolean)result.contains("trying m2"));
    }

    @Test(groups={"Live"})
    public void testJcloudsCreateWithNoSudoGranted() throws Exception {
        log.info("TEST testJcloudsCreateWithNoSudoGranted");
        JcloudsSshMachineLocation m = this.obtainMachine((Map<?, ?>)MutableMap.of((Object)"grantUserSudo", (Object)false, (Object)"waitForSshable", (Object)30000));
        int exitCode = this.execWithExitCode((SshMachineLocation)m, (List<String>)ImmutableList.of((Object)BashCommands.sudo((String)"echo yes")));
        Assert.assertFalse((exitCode == 0 ? 1 : 0) != 0, (String)"exit code for sudo command should not have been 0");
    }

    private String execWithOutput(SshMachineLocation m, List<String> commands) {
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        this.exec(m, commands, stdout, stderr);
        return new String(stdout.toByteArray());
    }

    private int execWithExitCode(SshMachineLocation m, List<String> commands) {
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        return this.exec(m, commands, stdout, stderr);
    }

    private int exec(SshMachineLocation m, List<String> commands, ByteArrayOutputStream stdout, ByteArrayOutputStream stderr) {
        LinkedHashMap flags = Maps.newLinkedHashMap();
        flags.put("out", stdout);
        flags.put("err", stderr);
        int exitCode = m.execCommands((Map)flags, "test", commands);
        log.info("stdout from " + commands + ":\n" + new String(stdout.toByteArray()));
        log.info("stderr from " + commands + ":\n" + new String(stderr.toByteArray()));
        log.info("exit code: " + exitCode);
        return exitCode;
    }

    private JcloudsLocation resolve(String spec) {
        return (JcloudsLocation)this.managementContext.getLocationRegistry().resolve("jclouds:" + spec);
    }
}

