/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.net.HostAndPort;
import org.apache.brooklyn.core.mgmt.rebind.RebindTestFixtureWithApp;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.jclouds.domain.LoginCredentials;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RebindJcloudsLocationTest
extends RebindTestFixtureWithApp {
    public static final String LOC_SPEC = "jclouds:aws-ec2:us-east-1";
    private JcloudsLocation origLoc;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.origLoc = (JcloudsLocation)this.origManagementContext.getLocationRegistry().resolve(LOC_SPEC);
    }

    @Test
    public void testReboundConfigDoesNotContainId() throws Exception {
        this.rebind();
        JcloudsLocation newLoc = (JcloudsLocation)this.newManagementContext.getLocationManager().getLocation(this.origLoc.getId());
        ConfigBag newLocConfig = newLoc.config().getBag();
        ConfigBag config = ConfigBag.newInstanceCopying((ConfigBag)newLocConfig);
        Assert.assertNull((Object)newLocConfig.getStringKey("id"));
        SshMachineLocation tempMachine = newLoc.createTemporarySshMachineLocation(HostAndPort.fromParts((String)"localhost", (int)1234), LoginCredentials.builder().identity("myuser").password("mypass").noPrivateKey().build(), config);
        Assert.assertNotEquals((Object)tempMachine.getId(), (Object)newLoc.getId());
    }
}

