/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.factory.ApplicationBuilder;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.rebind.RebindTestUtils;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsLiveTest;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.jclouds.LiveTestEntity;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RebindJcloudsLocationLiveTest
extends AbstractJcloudsLiveTest {
    public static final String AWS_EC2_REGION_NAME = "us-east-1";
    public static final String AWS_EC2_LOCATION_SPEC = "jclouds:aws-ec2:us-east-1";
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private TestApplication origApp;
    private LiveTestEntity origEntity;
    private File mementoDir;

    @Override
    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.origApp = (TestApplication)ApplicationBuilder.newManagedApp((EntitySpec)EntitySpec.create(TestApplication.class), (ManagementContext)this.managementContext);
        this.origEntity = (LiveTestEntity)this.origApp.createAndManageChild(EntitySpec.create(LiveTestEntity.class));
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(AWS_EC2_LOCATION_SPEC);
        this.jcloudsLocation.setConfig(JcloudsLocation.HARDWARE_ID, (Object)"m1.small");
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.origApp != null) {
            Entities.destroyAll((ManagementContext)this.origApp.getManagementContext());
        }
        if (this.mementoDir != null) {
            RebindTestUtils.deleteMementoDir((File)this.mementoDir);
        }
    }

    @Override
    protected LocalManagementContext newManagementContext() {
        this.mementoDir = Files.createTempDir();
        return RebindTestUtils.newPersistingManagementContext((File)this.mementoDir, (ClassLoader)this.classLoader, (long)1L);
    }

    @Test(groups={"Live"})
    public void testRebindsToJcloudsMachine() throws Exception {
        this.origApp.start((Collection)ImmutableList.of((Object)this.jcloudsLocation));
        JcloudsLocation origJcloudsLocation = this.jcloudsLocation;
        System.out.println("orig locations: " + this.origEntity.getLocations());
        JcloudsSshMachineLocation origMachine = (JcloudsSshMachineLocation)Iterables.find((Iterable)this.origEntity.getLocations(), (Predicate)Predicates.instanceOf(JcloudsSshMachineLocation.class));
        TestApplication newApp = this.rebind();
        LiveTestEntity newEntity = (LiveTestEntity)Iterables.find((Iterable)newApp.getChildren(), (Predicate)Predicates.instanceOf(LiveTestEntity.class));
        JcloudsSshMachineLocation newMachine = (JcloudsSshMachineLocation)Iterables.find((Iterable)newEntity.getLocations(), (Predicate)Predicates.instanceOf(JcloudsSshMachineLocation.class));
        this.assertMachineEquals(newMachine, origMachine);
        Assert.assertTrue((boolean)newMachine.isSshable());
        JcloudsLocation newJcloudsLoction = newMachine.getParent();
        this.assertJcloudsLocationEquals(newJcloudsLoction, origJcloudsLocation);
    }

    private void assertMachineEquals(JcloudsSshMachineLocation actual, JcloudsSshMachineLocation expected) {
        String errmsg = "actual=" + actual.toVerboseString() + "; expected=" + expected.toVerboseString();
        Assert.assertEquals((String)actual.getId(), (String)expected.getId(), (String)errmsg);
        Assert.assertEquals((String)actual.getJcloudsId(), (String)expected.getJcloudsId(), (String)errmsg);
        this.assertOsDetailEquals(actual.getOsDetails(), expected.getOsDetails());
        Assert.assertEquals((Object)actual.getSshHostAndPort(), (Object)expected.getSshHostAndPort());
        Assert.assertEquals((Object)actual.getPrivateAddress(), (Object)expected.getPrivateAddress());
        this.assertConfigBagEquals(actual.config().getBag(), expected.config().getBag(), errmsg);
    }

    private void assertOsDetailEquals(OsDetails actual, OsDetails expected) {
        String errmsg = "actual=" + actual + "; expected=" + expected;
        if (actual == null) {
            Assert.assertNull((Object)expected, (String)errmsg);
        }
        Assert.assertEquals((boolean)actual.isWindows(), (boolean)expected.isWindows());
        Assert.assertEquals((boolean)actual.isLinux(), (boolean)expected.isLinux());
        Assert.assertEquals((boolean)actual.isMac(), (boolean)expected.isMac());
        Assert.assertEquals((String)actual.getName(), (String)expected.getName());
        Assert.assertEquals((String)actual.getArch(), (String)expected.getArch());
        Assert.assertEquals((String)actual.getVersion(), (String)expected.getVersion());
        Assert.assertEquals((boolean)actual.is64bit(), (boolean)expected.is64bit());
    }

    private void assertJcloudsLocationEquals(JcloudsLocation actual, JcloudsLocation expected) {
        String errmsg = "actual=" + actual.toVerboseString() + "; expected=" + expected.toVerboseString();
        Assert.assertEquals((String)actual.getId(), (String)expected.getId(), (String)errmsg);
        Assert.assertEquals((String)actual.getProvider(), (String)expected.getProvider(), (String)errmsg);
        Assert.assertEquals((String)actual.getRegion(), (String)expected.getRegion(), (String)errmsg);
        Assert.assertEquals((String)actual.getIdentity(), (String)expected.getIdentity(), (String)errmsg);
        Assert.assertEquals((String)actual.getCredential(), (String)expected.getCredential(), (String)errmsg);
        Assert.assertEquals((Object)actual.getHostGeoInfo(), (Object)expected.getHostGeoInfo(), (String)errmsg);
        this.assertConfigBagEquals(actual.config().getBag(), expected.config().getBag(), errmsg);
    }

    private void assertConfigBagEquals(ConfigBag actual, ConfigBag expected, String errmsg) {
    }

    private TestApplication rebind() throws Exception {
        RebindTestUtils.waitForPersisted((Application)this.origApp);
        return (TestApplication)RebindTestUtils.rebind((File)this.mementoDir, (ClassLoader)this.getClass().getClassLoader());
    }
}

