/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.test.entity.TestEntity;
import org.apache.brooklyn.core.test.entity.TestEntityImpl;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ImplementedBy(value=LiveTestEntityImpl.class)
public interface LiveTestEntity
extends TestEntity {
    public MachineProvisioningLocation<?> getProvisioningLocation();

    public JcloudsSshMachineLocation getObtainedLocation();

    public static class LiveTestEntityImpl
    extends TestEntityImpl
    implements LiveTestEntity {
        private static final Logger LOG = LoggerFactory.getLogger(LiveTestEntityImpl.class);
        private JcloudsLocation provisioningLocation;
        private JcloudsSshMachineLocation obtainedLocation;

        public void start(Collection<? extends Location> locs) {
            LOG.trace("Starting {}", (Object)this);
            this.callHistory.add("start");
            this.setAttribute(SERVICE_STATE, Lifecycle.STARTING);
            this.counter.incrementAndGet();
            this.addLocations(locs);
            this.provisioningLocation = (JcloudsLocation)Iterables.find(locs, (Predicate)Predicates.instanceOf(JcloudsLocation.class));
            try {
                this.obtainedLocation = (JcloudsSshMachineLocation)this.provisioningLocation.obtain(this.provisioningLocation.config().getBag().getAllConfig());
            }
            catch (NoMachinesAvailableException e) {
                throw Throwables.propagate((Throwable)e);
            }
            this.addLocations((Collection)ImmutableList.of((Object)this.obtainedLocation));
            this.setAttribute(SERVICE_STATE, Lifecycle.RUNNING);
        }

        public void stop() {
            LOG.trace("Stopping {}", (Object)this);
            this.callHistory.add("stop");
            this.setAttribute(SERVICE_STATE, Lifecycle.STOPPING);
            this.counter.decrementAndGet();
            if (this.provisioningLocation != null && this.obtainedLocation != null) {
                this.provisioningLocation.release((MachineLocation)this.obtainedLocation);
            }
            this.setAttribute(SERVICE_STATE, Lifecycle.STOPPED);
        }

        @Override
        public MachineProvisioningLocation<?> getProvisioningLocation() {
            return this.provisioningLocation;
        }

        @Override
        public JcloudsSshMachineLocation getObtainedLocation() {
            return this.obtainedLocation;
        }
    }
}

