/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsLiveTest;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JcloudsSshingLiveTest
extends AbstractJcloudsLiveTest {
    public static final String SOFTLAYER_REGION_NAME = "ams01";
    public static final String SOTLAYER_LOCATION_SPEC = "jclouds:softlayer" + ("ams01" == null ? "" : ":ams01");
    protected JcloudsSshMachineLocation machine;

    @Test(groups={"Live"})
    public void testCreatesUserUsingJcloudsTemplateOptions() throws Exception {
        this.runCreatesUser(true);
    }

    @Test(groups={"Live"})
    public void testCreatesUserWithoutUsingJcloudsTemplateOptions() throws Exception {
        this.runCreatesUser(false);
    }

    protected void runCreatesUser(boolean useJcloudsSshInit) throws Exception {
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USE_JCLOUDS_SSH_INIT.getName()), (Object)Boolean.toString(useJcloudsSshInit));
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USER.getName()), (Object)"myname");
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(SOTLAYER_LOCATION_SPEC);
        JcloudsSshMachineLocation machine = this.obtainMachine((Map<?, ?>)MutableMap.builder().putIfAbsent((Object)"inboundPorts", (Object)ImmutableList.of((Object)22)).build());
        this.assertSshable((SshMachineLocation)machine);
        Assert.assertEquals((String)machine.getUser(), (String)"myname");
    }
}

