/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.brooklyn.location.jclouds.JcloudsPropertiesFromBrooklynProperties;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JcloudsPropertiesFromBrooklynPropertiesTest {
    private JcloudsPropertiesFromBrooklynProperties parser;

    protected static Map<String, Object> sampleProviderOrApiProps() {
        HashMap map = Maps.newHashMap();
        map.put("brooklyn.location.jclouds.FooServers.identity", "bob");
        map.put("brooklyn.location.jclouds.FooServers.credential", "s3cr3t");
        map.put("brooklyn.location.jclouds.FooServers.jclouds.ssh.max-retries", "100");
        return map;
    }

    protected static Map<String, Object> sampleNamedProps() {
        HashMap map = Maps.newHashMap();
        map.put("brooklyn.location.named.cloudfirst", "jclouds:openstack-nova");
        map.put("brooklyn.location.named.cloudfirst.identity", "myId");
        map.put("brooklyn.location.named.cloudfirst.credential", "password");
        map.put("brooklyn.location.named.cloudfirst.imageId", "RegionOne/1");
        map.put("brooklyn.location.named.cloudfirst.securityGroups", "universal");
        return map;
    }

    protected static Map<String, Object> unsupportedSampleProviderOrApiProps() {
        HashMap map = Maps.newHashMap();
        map.put("brooklyn.location.jclouds.FooServers.image-id", "invalid-image-id");
        return map;
    }

    protected static Map<String, Object> unsupportedNamedProps() {
        HashMap map = Maps.newHashMap();
        map.put("brooklyn.location.named.cloudfirst", "jclouds:openstack-nova");
        map.put("brooklyn.location.named.cloudfirst.hardware-id", "invalid-hardware-id");
        return map;
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.parser = new JcloudsPropertiesFromBrooklynProperties();
    }

    @Test
    public void testProviderOrApiProperties() {
        Map map = this.parser.getJcloudsProperties("FooServers", null, null, JcloudsPropertiesFromBrooklynPropertiesTest.sampleProviderOrApiProps());
        Assert.assertEquals(map.get("identity"), (Object)"bob");
        Assert.assertEquals(map.get("credential"), (Object)"s3cr3t");
        Assert.assertEquals(map.get("provider"), (Object)"FooServers");
    }

    @Test
    public void testNamedProperties() {
        Map map = this.parser.getJcloudsProperties("openstack-nova", null, "cloudfirst", JcloudsPropertiesFromBrooklynPropertiesTest.sampleNamedProps());
        Assert.assertEquals(map.get("provider"), (Object)"openstack-nova");
        Assert.assertEquals(map.get("identity"), (Object)"myId");
        Assert.assertEquals(map.get("credential"), (Object)"password");
        Assert.assertEquals(map.get("imageId"), (Object)"RegionOne/1");
        Assert.assertEquals(map.get("securityGroups"), (Object)"universal");
    }

    @Test
    public void testOrderOfPreference() {
        HashMap allProperties = Maps.newHashMap();
        allProperties.putAll(JcloudsPropertiesFromBrooklynPropertiesTest.sampleProviderOrApiProps());
        allProperties.putAll(JcloudsPropertiesFromBrooklynPropertiesTest.sampleNamedProps());
        Map map = this.parser.getJcloudsProperties("openstack-nova", null, "cloudfirst", (Map)allProperties);
        Assert.assertEquals(map.get("provider"), (Object)"openstack-nova");
        Assert.assertEquals(map.get("identity"), (Object)"myId");
        Assert.assertEquals(map.get("credential"), (Object)"password");
        Assert.assertEquals(map.get("imageId"), (Object)"RegionOne/1");
        Assert.assertEquals(map.get("securityGroups"), (Object)"universal");
    }
}

