/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.JcloudsMachineNamer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JcloudsMachineNamerTest {
    private static final Logger log = LoggerFactory.getLogger(JcloudsMachineNamerTest.class);

    @Test
    public void testGenerateGroupIdInVcloud() {
        ConfigBag cfg = new ConfigBag().configure(JcloudsLocationConfig.CLOUD_PROVIDER, (Object)"vcloud").configure(JcloudsLocationConfig.CALLER_CONTEXT, (Object)"!mycontext!");
        String result = new JcloudsMachineNamer().generateNewGroupId(cfg);
        log.info("test mycontext vcloud group id gives: " + result);
        Assert.assertTrue((result.length() <= 19 ? 1 : 0) != 0, (String)("result: " + result));
        String user = System.getProperty("user.name");
        String userExt = Strings.maxlen((String)user, (int)2).toLowerCase();
        if (user.length() <= 4) {
            Assert.assertTrue((result.indexOf(userExt) >= 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((result.indexOf("-myc") >= 0 ? 1 : 0) != 0);
    }
}

