/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.File;
import java.util.Map;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsLiveTest;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JcloudsLoginLiveTest
extends AbstractJcloudsLiveTest {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsLoginLiveTest.class);
    public static final String AWS_EC2_REGION_NAME = "us-east-1";
    public static final String AWS_EC2_LOCATION_SPEC = "jclouds:aws-ec2" + ("us-east-1" == null ? "" : ":us-east-1");
    public static final String AWS_EC2_CENTOS_IMAGE_ID = "us-east-1/ami-7d7bfc14";
    public static final String AWS_EC2_UBUNTU_IMAGE_ID = "us-east-1/ami-d0f89fb9";
    public static final String AWS_EC2_UBUNTU_10_IMAGE_ID = "us-east-1/ami-5e008437";
    public static final String RACKSPACE_LOCATION_SPEC = "jclouds:rackspace-cloudservers-uk";
    public static final String RACKSPACE_CENTOS_IMAGE_NAME_REGEX = "CentOS 6.0";
    public static final String RACKSPACE_DEBIAN_IMAGE_NAME_REGEX = "Debian 6";
    protected JcloudsSshMachineLocation machine;
    private File privateRsaFile = new File(Os.tidyPath((String)"~/.ssh/id_rsa"));
    private File privateDsaFile = new File(Os.tidyPath((String)"~/.ssh/id_dsa"));
    private File privateRsaFileTmp = new File(this.privateRsaFile.getAbsoluteFile() + ".tmp");
    private File privateDsaFileTmp = new File(this.privateDsaFile.getAbsoluteFile() + ".tmp");
    private File publicRsaFile = new File(Os.tidyPath((String)"~/.ssh/id_rsa.pub"));
    private File publicDsaFile = new File(Os.tidyPath((String)"~/.ssh/id_dsa.pub"));
    private File publicRsaFileTmp = new File(this.publicRsaFile.getAbsoluteFile() + ".tmp");
    private File publicDsaFileTmp = new File(this.publicDsaFile.getAbsoluteFile() + ".tmp");
    private boolean privateRsaFileMoved;
    private boolean privateDsaFileMoved;
    private boolean publicRsaFileMoved;
    private boolean publicDsaFileMoved;

    @Test(groups={"Live"})
    protected void testAwsEc2SpecifyingJustPrivateSshKeyInDeprecatedForm() throws Exception {
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USER.getName()), (Object)"myname");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.LEGACY_PRIVATE_KEY_FILE.getName()), (Object)"~/.ssh/id_rsa");
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(AWS_EC2_LOCATION_SPEC);
        this.machine = this.createEc2Machine((Map<String, ? extends Object>)ImmutableMap.of());
        this.assertSshable((SshMachineLocation)this.machine);
        this.assertSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"myname").put((Object)SshMachineLocation.PRIVATE_KEY_FILE, (Object)Os.tidyPath((String)"~/.ssh/id_rsa")).build());
    }

    @Test(groups={"Live"})
    protected void testAwsEc2SpecifyingPrivateAndPublicSshKeyInDeprecatedForm() throws Exception {
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USER.getName()), (Object)"myname");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.LEGACY_PRIVATE_KEY_FILE.getName()), (Object)"~/.ssh/id_rsa");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.LEGACY_PUBLIC_KEY_FILE.getName()), (Object)"~/.ssh/id_rsa.pub");
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(AWS_EC2_LOCATION_SPEC);
        this.machine = this.createEc2Machine((Map<String, ? extends Object>)ImmutableMap.of());
        this.assertSshable((SshMachineLocation)this.machine);
        this.assertSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"myname").put((Object)SshMachineLocation.PRIVATE_KEY_FILE, (Object)Os.tidyPath((String)"~/.ssh/id_rsa")).build());
    }

    @Test(groups={"Live"})
    protected void testAwsEc2SpecifyingNoKeyFiles() throws Exception {
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USER.getName()), (Object)"myname");
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(AWS_EC2_LOCATION_SPEC);
        this.machine = this.createEc2Machine((Map<String, ? extends Object>)ImmutableMap.of());
        this.assertSshable((SshMachineLocation)this.machine);
        this.assertSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"myname").put((Object)SshMachineLocation.PRIVATE_KEY_FILE, (Object)Os.tidyPath((String)"~/.ssh/id_rsa")).build());
    }

    @Test(groups={"Live"})
    public void testSpecifyingPasswordAndNoDefaultKeyFilesExist() throws Exception {
        try {
            this.moveSshKeyFiles();
            this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USER.getName()), (Object)"myname");
            this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PASSWORD.getName()), (Object)"mypassword");
            this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(RACKSPACE_LOCATION_SPEC);
            this.machine = this.createRackspaceMachine((Map<String, ? extends Object>)ImmutableMap.of((Object)"imageNameRegex", (Object)RACKSPACE_DEBIAN_IMAGE_NAME_REGEX));
            this.assertSshable((SshMachineLocation)this.machine);
            this.assertSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"myname").put((Object)SshMachineLocation.PASSWORD, (Object)"mypassword").build());
        }
        finally {
            this.restoreSshKeyFiles();
        }
    }

    @Test(groups={"Live"})
    protected void testSpecifyingNothingAndNoDefaultKeyFilesExist() throws Exception {
        try {
            this.moveSshKeyFiles();
            this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USER.getName()), (Object)"myname");
            this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(RACKSPACE_LOCATION_SPEC);
            this.machine = this.createRackspaceMachine((Map<String, ? extends Object>)ImmutableMap.of((Object)"imageNameRegex", (Object)RACKSPACE_DEBIAN_IMAGE_NAME_REGEX));
            this.assertSshable((SshMachineLocation)this.machine);
            Assert.assertEquals((String)this.machine.getUser(), (String)"myname");
        }
        finally {
            this.restoreSshKeyFiles();
        }
    }

    @Test(groups={"Live"})
    protected void testSpecifyingPasswordAndSshKeysPrefersKeys() throws Exception {
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USER.getName()), (Object)"myname");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PRIVATE_KEY_FILE.getName()), (Object)"~/.ssh/id_rsa");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PUBLIC_KEY_FILE.getName()), (Object)"~/.ssh/id_rsa.pub");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PASSWORD.getName()), (Object)"mypassword");
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(RACKSPACE_LOCATION_SPEC);
        this.machine = this.createRackspaceMachine((Map<String, ? extends Object>)ImmutableMap.of((Object)"imageNameRegex", (Object)RACKSPACE_DEBIAN_IMAGE_NAME_REGEX));
        this.assertSshable((SshMachineLocation)this.machine);
        this.assertSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"myname").put((Object)SshMachineLocation.PRIVATE_KEY_FILE, (Object)Os.tidyPath((String)"~/.ssh/id_rsa")).build());
        this.assertSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"myname").put((Object)SshMachineLocation.PASSWORD, (Object)"mypassword").build());
    }

    @Test(groups={"Live"})
    protected void testSpecifyingPasswordIgnoresDefaultSshKeys() throws Exception {
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USER.getName()), (Object)"myname");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PASSWORD.getName()), (Object)"mypassword");
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(RACKSPACE_LOCATION_SPEC);
        this.machine = this.createRackspaceMachine((Map<String, ? extends Object>)ImmutableMap.of((Object)"imageNameRegex", (Object)RACKSPACE_DEBIAN_IMAGE_NAME_REGEX));
        this.assertSshable((SshMachineLocation)this.machine);
        this.assertSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"myname").put((Object)SshMachineLocation.PASSWORD, (Object)"mypassword").build());
        this.assertNotSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"myname").put((Object)SshMachineLocation.PRIVATE_KEY_FILE, (Object)Os.tidyPath((String)"~/.ssh/id_rsa")).build());
    }

    @Test(groups={"Live"})
    protected void testSpecifyingPasswordWithPublicKeyAllowsKeyAccess() throws Exception {
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USER.getName()), (Object)"myname");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PASSWORD.getName()), (Object)"mypassword");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PUBLIC_KEY_FILE.getName()), (Object)"~/.ssh/id_rsa.pub");
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(RACKSPACE_LOCATION_SPEC);
        this.machine = this.createRackspaceMachine((Map<String, ? extends Object>)ImmutableMap.of((Object)"imageNameRegex", (Object)RACKSPACE_DEBIAN_IMAGE_NAME_REGEX));
        this.assertSshable((SshMachineLocation)this.machine);
        this.assertSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"myname").put((Object)SshMachineLocation.PRIVATE_KEY_FILE, (Object)Os.tidyPath((String)"~/.ssh/id_rsa")).build());
        this.assertSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"myname").put((Object)SshMachineLocation.PASSWORD, (Object)"mypassword").build());
    }

    @Test(groups={"Live"})
    protected void testSpecifyingPasswordWhenNoDefaultKeyFilesExistWithRootUser() throws Exception {
        try {
            this.moveSshKeyFiles();
            this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USER.getName()), (Object)"root");
            this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PASSWORD.getName()), (Object)"mypassword");
            this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(RACKSPACE_LOCATION_SPEC);
            this.machine = this.createRackspaceMachine((Map<String, ? extends Object>)ImmutableMap.of((Object)"imageNameRegex", (Object)RACKSPACE_DEBIAN_IMAGE_NAME_REGEX));
            this.assertSshable((SshMachineLocation)this.machine);
            this.assertSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"root").put((Object)SshMachineLocation.PASSWORD, (Object)"mypassword").build());
        }
        finally {
            this.restoreSshKeyFiles();
        }
    }

    @Test(groups={"Live"})
    protected void testAwsEc2SpecifyingRootUser() throws Exception {
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USER.getName()), (Object)"root");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PRIVATE_KEY_FILE.getName()), (Object)"~/.ssh/id_rsa");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PUBLIC_KEY_FILE.getName()), (Object)"~/.ssh/id_rsa.pub");
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(AWS_EC2_LOCATION_SPEC);
        this.machine = this.createEc2Machine((Map<String, ? extends Object>)ImmutableMap.of((Object)"imageId", (Object)AWS_EC2_UBUNTU_10_IMAGE_ID));
        this.assertSshable((SshMachineLocation)this.machine);
        this.assertSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"root").put((Object)SshMachineLocation.PRIVATE_KEY_FILE, (Object)Os.tidyPath((String)"~/.ssh/id_rsa")).build());
    }

    @Test(groups={"Live"})
    protected void testAwsEc2WhenBlankUserSoUsesRootLoginUser() throws Exception {
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USER.getName()), (Object)"");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PRIVATE_KEY_FILE.getName()), (Object)"~/.ssh/id_rsa");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PUBLIC_KEY_FILE.getName()), (Object)"~/.ssh/id_rsa.pub");
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(AWS_EC2_LOCATION_SPEC);
        this.machine = this.createEc2Machine((Map<String, ? extends Object>)ImmutableMap.of((Object)"imageId", (Object)AWS_EC2_UBUNTU_10_IMAGE_ID));
        this.assertSshable((SshMachineLocation)this.machine);
        this.assertSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"root").put((Object)SshMachineLocation.PRIVATE_KEY_FILE, (Object)Os.tidyPath((String)"~/.ssh/id_rsa")).build());
    }

    @Test(groups={"Live"})
    protected void testAwsEc2SpecifyingSpecialUser() throws Exception {
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.USER.getName()), (Object)"ec2-user");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PRIVATE_KEY_FILE.getName()), (Object)"~/.ssh/id_rsa");
        this.brooklynProperties.put((Object)("brooklyn.location.jclouds." + JcloudsLocationConfig.PUBLIC_KEY_FILE.getName()), (Object)"~/.ssh/id_rsa.pub");
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(AWS_EC2_LOCATION_SPEC);
        this.machine = this.createEc2Machine((Map<String, ? extends Object>)ImmutableMap.of((Object)"imageId", (Object)AWS_EC2_UBUNTU_10_IMAGE_ID));
        this.assertSshable((SshMachineLocation)this.machine);
        this.assertSshable((Map<?, ?>)ImmutableMap.builder().put((Object)"address", (Object)this.machine.getAddress()).put((Object)"user", (Object)"ec2-user").put((Object)SshMachineLocation.PRIVATE_KEY_FILE, (Object)Os.tidyPath((String)"~/.ssh/id_rsa")).build());
    }

    @Override
    protected void releaseMachine(JcloudsSshMachineLocation machine) {
        this.jcloudsLocation.release((MachineLocation)machine);
    }

    private JcloudsSshMachineLocation createEc2Machine(Map<String, ? extends Object> conf) throws Exception {
        return this.obtainMachine((Map<?, ?>)MutableMap.builder().putAll(conf).putIfAbsent((Object)"imageId", (Object)AWS_EC2_CENTOS_IMAGE_ID).putIfAbsent((Object)"hardwareId", (Object)"m1.small").putIfAbsent((Object)"inboundPorts", (Object)ImmutableList.of((Object)22)).build());
    }

    private JcloudsSshMachineLocation createRackspaceMachine(Map<String, ? extends Object> conf) throws Exception {
        return this.obtainMachine((Map<?, ?>)MutableMap.builder().putAll(conf).putIfAbsent((Object)"inboundPorts", (Object)ImmutableList.of((Object)22)).build());
    }

    protected void assertSshable(Map<?, ?> machineConfig) {
        SshMachineLocation machineWithThatConfig = (SshMachineLocation)this.managementContext.getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class).configure(machineConfig));
        try {
            this.assertSshable(machineWithThatConfig);
        }
        finally {
            Streams.closeQuietly((Closeable)machineWithThatConfig);
        }
    }

    protected void assertNotSshable(Map<?, ?> machineConfig) {
        try {
            this.assertSshable(machineConfig);
            Assert.fail((String)("ssh should not have succeeded " + machineConfig));
        }
        catch (Exception exception) {
            LOG.debug("Exception as expected when testing sshable " + machineConfig);
        }
    }

    private void moveSshKeyFiles() throws Exception {
        this.privateRsaFileMoved = false;
        this.privateDsaFileMoved = false;
        this.publicRsaFileMoved = false;
        this.publicDsaFileMoved = false;
        if (this.privateRsaFile.exists()) {
            LOG.info("Moving {} to {}", (Object)this.privateRsaFile, (Object)this.privateRsaFileTmp);
            Runtime.getRuntime().exec("mv " + this.privateRsaFile.getAbsolutePath() + " " + this.privateRsaFileTmp.getAbsolutePath());
            this.privateRsaFileMoved = true;
        }
        if (this.privateDsaFile.exists()) {
            LOG.info("Moving {} to {}", (Object)this.privateDsaFile, (Object)this.privateDsaFileTmp);
            Runtime.getRuntime().exec("mv " + this.privateDsaFile.getAbsolutePath() + " " + this.privateDsaFileTmp.getAbsolutePath());
            this.privateDsaFileMoved = true;
        }
        if (this.publicRsaFile.exists()) {
            LOG.info("Moving {} to {}", (Object)this.publicRsaFile, (Object)this.publicRsaFileTmp);
            Runtime.getRuntime().exec("mv " + this.publicRsaFile.getAbsolutePath() + " " + this.publicRsaFileTmp.getAbsolutePath());
            this.publicRsaFileMoved = true;
        }
        if (this.publicDsaFile.exists()) {
            LOG.info("Moving {} to {}", (Object)this.publicDsaFile, (Object)this.publicDsaFileTmp);
            Runtime.getRuntime().exec("mv " + this.publicDsaFile.getAbsolutePath() + " " + this.publicDsaFileTmp.getAbsolutePath());
            this.publicDsaFileMoved = true;
        }
    }

    private void restoreSshKeyFiles() throws Exception {
        if (this.privateRsaFileMoved) {
            LOG.info("Restoring {} form {}", (Object)this.privateRsaFile, (Object)this.privateRsaFileTmp);
            Runtime.getRuntime().exec("mv " + this.privateRsaFileTmp.getAbsolutePath() + " " + this.privateRsaFile.getAbsolutePath());
            this.privateRsaFileMoved = false;
        }
        if (this.privateDsaFileMoved) {
            LOG.info("Restoring {} form {}", (Object)this.privateDsaFile, (Object)this.privateDsaFileTmp);
            Runtime.getRuntime().exec("mv " + this.privateDsaFileTmp.getAbsolutePath() + " " + this.privateDsaFile.getAbsolutePath());
            this.privateDsaFileMoved = false;
        }
        if (this.publicRsaFileMoved) {
            LOG.info("Restoring {} form {}", (Object)this.publicRsaFile, (Object)this.publicRsaFileTmp);
            Runtime.getRuntime().exec("mv " + this.publicRsaFileTmp.getAbsolutePath() + " " + this.publicRsaFile.getAbsolutePath());
            this.publicRsaFileMoved = false;
        }
        if (this.publicDsaFileMoved) {
            LOG.info("Restoring {} form {}", (Object)this.publicDsaFile, (Object)this.publicDsaFileTmp);
            Runtime.getRuntime().exec("mv " + this.publicDsaFileTmp.getAbsolutePath() + " " + this.publicDsaFile.getAbsolutePath());
            this.publicDsaFileMoved = false;
        }
    }
}

