/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineLocationCustomizer;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.cloud.names.CustomMachineNamer;
import org.apache.brooklyn.core.location.geo.HostGeoInfo;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.location.jclouds.BailOutJcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.JcloudsLocationCustomizer;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.location.jclouds.JcloudsPropertiesFromBrooklynProperties;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JcloudsLocationTest
implements JcloudsLocationConfig {
    private static final Logger log = LoggerFactory.getLogger(JcloudsLocationTest.class);
    private LocalManagementContext managementContext;

    public static Predicate<ConfigBag> checkerFor(final String user, final Integer minRam, final Integer minCores) {
        return new Predicate<ConfigBag>(){

            public boolean apply(@Nullable ConfigBag input) {
                Assert.assertEquals((String)((String)input.get(USER)), (String)user);
                Assert.assertEquals((Object)input.get(MIN_RAM), (Object)minRam);
                Assert.assertEquals((Object)input.get(MIN_CORES), (Object)minCores);
                return true;
            }
        };
    }

    public static Predicate<ConfigBag> templateCheckerFor(final String ports) {
        return new Predicate<ConfigBag>(){

            public boolean apply(@Nullable ConfigBag input) {
                Assert.assertEquals((Object)input.get(INBOUND_PORTS), (Object)ports);
                return false;
            }
        };
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.managementContext = LocalManagementContextForTests.newInstance((BrooklynProperties)BrooklynProperties.Factory.builderEmpty().build());
    }

    @AfterMethod(alwaysRun=true)
    public void tearUp() throws Exception {
        if (this.managementContext != null) {
            Entities.destroyAll((ManagementContext)this.managementContext);
        }
    }

    @Test
    public void testCreateWithFlagsDirectly() throws Exception {
        BailOutJcloudsLocation jcl = BailOutJcloudsLocation.newBailOutJcloudsLocation((ManagementContext)this.managementContext);
        jcl.tryObtainAndCheck((Map<?, ?>)MutableMap.of((Object)MIN_CORES, (Object)2), (Predicate<? super ConfigBag>)JcloudsLocationTest.checkerFor("fred", 16, 2));
    }

    @Test
    public void testCreateWithFlagsDirectlyAndOverride() throws Exception {
        BailOutJcloudsLocation jcl = BailOutJcloudsLocation.newBailOutJcloudsLocation((ManagementContext)this.managementContext);
        jcl.tryObtainAndCheck((Map<?, ?>)MutableMap.of((Object)MIN_CORES, (Object)2, (Object)MIN_RAM, (Object)8), (Predicate<? super ConfigBag>)JcloudsLocationTest.checkerFor("fred", 8, 2));
    }

    @Test
    public void testCreateWithFlagsSubLocation() throws Exception {
        BailOutJcloudsLocation jcl = BailOutJcloudsLocation.newBailOutJcloudsLocation((ManagementContext)this.managementContext);
        jcl = (BailOutJcloudsLocation)jcl.newSubLocation((Map)MutableMap.of((Object)USER, (Object)"jon", (Object)MIN_CORES, (Object)2));
        jcl.tryObtainAndCheck((Map<?, ?>)MutableMap.of((Object)MIN_CORES, (Object)3), (Predicate<? super ConfigBag>)JcloudsLocationTest.checkerFor("jon", 16, 3));
    }

    @Test
    public void testStringListToIntArray() {
        String listString = "[1, 2, 3, 4]";
        int[] intArray = new int[]{1, 2, 3, 4};
        Assert.assertEquals((Object)JcloudsLocation.toIntArray((Object)listString), (Object)intArray);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMalformedStringListToIntArray() {
        String listString = "1, 2, 3, 4";
        JcloudsLocation.toIntArray((Object)listString);
    }

    @Test
    public void testEmptyStringListToIntArray() {
        String listString = "[]";
        int[] intArray = new int[]{};
        Assert.assertEquals((Object)JcloudsLocation.toIntArray((Object)listString), (Object)intArray);
    }

    @Test
    public void testIntArrayToIntArray() {
        int[] intArray = new int[]{1, 2, 3, 4};
        Assert.assertEquals((Object)JcloudsLocation.toIntArray((Object)intArray), (Object)intArray);
    }

    @Test
    public void testObjectArrayToIntArray() {
        Object[] longArray = new Object[]{1, 2, 3, 4};
        int[] intArray = new int[]{1, 2, 3, 4};
        Assert.assertEquals((Object)JcloudsLocation.toIntArray((Object)longArray), (Object)intArray);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void testInvalidObjectArrayToIntArray() {
        String[] stringArray = new String[]{"1", "2", "3"};
        JcloudsLocation.toIntArray((Object)stringArray);
    }

    @Test
    public void testVMCreationIsRetriedOnFailure() {
        final AtomicInteger count = new AtomicInteger();
        Function<ConfigBag, Void> countingInterceptor = new Function<ConfigBag, Void>(){

            public Void apply(ConfigBag input) {
                count.incrementAndGet();
                return null;
            }
        };
        BailOutJcloudsLocation loc = BailOutJcloudsLocation.newBailOutJcloudsLocation((ManagementContext)this.managementContext, ImmutableMap.of((Object)MACHINE_CREATE_ATTEMPTS, (Object)3, BailOutJcloudsLocation.BUILD_TEMPLATE_INTERCEPTOR, (Object)countingInterceptor));
        loc.tryObtain();
        Assert.assertEquals((int)count.get(), (int)3);
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testCreateWithInboundPorts() {
        BailOutJcloudsLocation jcloudsLocation = BailOutJcloudsLocation.newBailOutJcloudsLocationForLiveTest(this.managementContext);
        jcloudsLocation = (BailOutJcloudsLocation)jcloudsLocation.newSubLocation((Map)MutableMap.of());
        jcloudsLocation.tryObtainAndCheck((Map<?, ?>)MutableMap.of(), (Predicate<? super ConfigBag>)JcloudsLocationTest.templateCheckerFor("[22, 80, 9999]"));
        int[] ports = new int[]{22, 80, 9999};
        Assert.assertEquals((Object)jcloudsLocation.getTemplate().getOptions().getInboundPorts(), (Object)ports);
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testCreateWithInboundPortsOverride() {
        BailOutJcloudsLocation jcloudsLocation = BailOutJcloudsLocation.newBailOutJcloudsLocationForLiveTest(this.managementContext);
        jcloudsLocation = (BailOutJcloudsLocation)jcloudsLocation.newSubLocation((Map)MutableMap.of());
        jcloudsLocation.tryObtainAndCheck((Map<?, ?>)MutableMap.of((Object)INBOUND_PORTS, (Object)"[23, 81, 9998]"), (Predicate<? super ConfigBag>)JcloudsLocationTest.templateCheckerFor("[23, 81, 9998]"));
        int[] ports = new int[]{23, 81, 9998};
        Assert.assertEquals((Object)jcloudsLocation.getTemplate().getOptions().getInboundPorts(), (Object)ports);
    }

    @Test
    public void testCreateWithMaxConcurrentCallsUnboundedByDefault() throws Exception {
        ConcurrencyTracker interceptor = new ConcurrencyTracker();
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            final BailOutJcloudsLocation jcloudsLocation = BailOutJcloudsLocation.newBailOutJcloudsLocation((ManagementContext)this.managementContext, ImmutableMap.of(BailOutJcloudsLocation.BUILD_TEMPLATE_INTERCEPTOR, (Object)interceptor));
            int i = 0;
            while (i < 20) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        jcloudsLocation.tryObtain();
                    }
                });
                ++i;
            }
            interceptor.assertCallCountEventually(20);
            interceptor.unblock();
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test(groups={"Integration"})
    public void testCreateWithMaxConcurrentCallsRespectsConfig() throws Exception {
        ConcurrencyTracker interceptor = new ConcurrencyTracker();
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            final BailOutJcloudsLocation jcloudsLocation = BailOutJcloudsLocation.newBailOutJcloudsLocation((ManagementContext)this.managementContext, ImmutableMap.of(BailOutJcloudsLocation.BUILD_TEMPLATE_INTERCEPTOR, (Object)interceptor, (Object)MAX_CONCURRENT_MACHINE_CREATIONS, (Object)2));
            int i = 0;
            while (i < 4) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        jcloudsLocation.tryObtain();
                    }
                });
                ++i;
            }
            interceptor.assertCallCountEventually(2);
            interceptor.assertCallCountContinually(2);
            interceptor.unblock();
            interceptor.assertCallCountEventually(4);
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test(groups={"Integration"})
    public void testCreateWithMaxConcurrentCallsAppliesToSubLocations() throws Exception {
        ConcurrencyTracker interceptor = new ConcurrencyTracker();
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            BailOutJcloudsLocation jcloudsLocation = BailOutJcloudsLocation.newBailOutJcloudsLocation((ManagementContext)this.managementContext, ImmutableMap.of(BailOutJcloudsLocation.BUILD_TEMPLATE_INTERCEPTOR, (Object)interceptor, (Object)MAX_CONCURRENT_MACHINE_CREATIONS, (Object)2));
            int i = 0;
            while (i < 4) {
                final BailOutJcloudsLocation subLocation = (BailOutJcloudsLocation)jcloudsLocation.newSubLocation((Map)MutableMap.of());
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        subLocation.tryObtain();
                    }
                });
                ++i;
            }
            interceptor.assertCallCountEventually(2);
            interceptor.assertCallCountContinually(2);
            interceptor.unblock();
            interceptor.assertCallCountEventually(4);
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testCreateWithCustomMachineNamer() {
        final String machineNamerClass = CustomMachineNamer.class.getName();
        BailOutJcloudsLocation jcloudsLocation = BailOutJcloudsLocation.newBailOutJcloudsLocation((ManagementContext)this.managementContext, ImmutableMap.of((Object)LocationConfigKeys.CLOUD_MACHINE_NAMER_CLASS, (Object)machineNamerClass));
        jcloudsLocation.tryObtainAndCheck((Map<?, ?>)ImmutableMap.of((Object)CustomMachineNamer.MACHINE_NAME_TEMPLATE, (Object)"ignored"), (Predicate<? super ConfigBag>)new Predicate<ConfigBag>(){

            public boolean apply(ConfigBag input) {
                Assert.assertEquals((String)((String)input.get(LocationConfigKeys.CLOUD_MACHINE_NAMER_CLASS)), (String)machineNamerClass);
                return true;
            }
        });
    }

    @Test
    public void testCreateWithCustomMachineNamerOnObtain() {
        final String machineNamerClass = CustomMachineNamer.class.getName();
        BailOutJcloudsLocation jcloudsLocation = BailOutJcloudsLocation.newBailOutJcloudsLocation((ManagementContext)this.managementContext);
        ImmutableMap flags = ImmutableMap.of((Object)CustomMachineNamer.MACHINE_NAME_TEMPLATE, (Object)"ignored", (Object)LocationConfigKeys.CLOUD_MACHINE_NAMER_CLASS, (Object)machineNamerClass);
        jcloudsLocation.tryObtainAndCheck((Map<?, ?>)flags, (Predicate<? super ConfigBag>)new Predicate<ConfigBag>(){

            public boolean apply(ConfigBag input) {
                Assert.assertEquals((String)((String)input.get(LocationConfigKeys.CLOUD_MACHINE_NAMER_CLASS)), (String)machineNamerClass);
                return true;
            }
        });
    }

    @Test
    public void testInheritsGeo() throws Exception {
        ConfigBag allConfig = ConfigBag.newInstance().configure(IMAGE_ID, (Object)"bogus").configure(CLOUD_PROVIDER, (Object)"aws-ec2").configure(CLOUD_REGION_ID, (Object)"bogus").configure(ACCESS_IDENTITY, (Object)"bogus").configure(ACCESS_CREDENTIAL, (Object)"bogus").configure(LocationConfigKeys.LATITUDE, (Object)42.0).configure(LocationConfigKeys.LONGITUDE, (Object)-20.0).configure(MACHINE_CREATE_ATTEMPTS, (Object)1);
        FakeLocalhostWithParentJcloudsLocation ll = (FakeLocalhostWithParentJcloudsLocation)this.managementContext.getLocationManager().createLocation(LocationSpec.create(FakeLocalhostWithParentJcloudsLocation.class).configure(allConfig.getAllConfig()));
        MachineLocation l = ll.obtain();
        log.info("loc:" + l);
        HostGeoInfo geo = HostGeoInfo.fromLocation((Location)l);
        log.info("geo: " + geo);
        Assert.assertEquals((double)geo.latitude, (double)42.0, (double)1.0E-5);
        Assert.assertEquals((double)geo.longitude, (double)-20.0, (double)1.0E-5);
    }

    @Test
    public void testInheritsGeoFromLocationMetadataProperties() throws Exception {
        ConfigBag allConfig = ConfigBag.newInstance().configure(IMAGE_ID, (Object)"bogus").configure(CLOUD_PROVIDER, (Object)"softlayer").configure(CLOUD_REGION_ID, (Object)"wdc01").configure(ACCESS_IDENTITY, (Object)"bogus").configure(ACCESS_CREDENTIAL, (Object)"bogus").configure(MACHINE_CREATE_ATTEMPTS, (Object)1);
        FakeLocalhostWithParentJcloudsLocation ll = (FakeLocalhostWithParentJcloudsLocation)this.managementContext.getLocationManager().createLocation(LocationSpec.create(FakeLocalhostWithParentJcloudsLocation.class).configure(new JcloudsPropertiesFromBrooklynProperties().getJcloudsProperties("softlayer", "wdc01", null, (Map)this.managementContext.getBrooklynProperties())).configure(allConfig.getAllConfig()));
        MachineLocation l = ll.obtain();
        log.info("loc:" + l);
        HostGeoInfo geo = HostGeoInfo.fromLocation((Location)l);
        log.info("geo: " + geo);
        Assert.assertEquals((double)geo.latitude, (double)38.909202, (double)1.0E-5);
        Assert.assertEquals((double)geo.longitude, (double)-77.47314, (double)1.0E-5);
    }

    @Test
    public void testInvokesCustomizerCallbacks() throws Exception {
        JcloudsLocationCustomizer customizer = (JcloudsLocationCustomizer)Mockito.mock(JcloudsLocationCustomizer.class);
        MachineLocationCustomizer machineCustomizer = (MachineLocationCustomizer)Mockito.mock(MachineLocationCustomizer.class);
        ConfigBag allConfig = ConfigBag.newInstance().configure(CLOUD_PROVIDER, (Object)"aws-ec2").configure(ACCESS_IDENTITY, (Object)"bogus").configure(ACCESS_CREDENTIAL, (Object)"bogus").configure(JcloudsLocationConfig.JCLOUDS_LOCATION_CUSTOMIZERS, (Object)ImmutableList.of((Object)customizer)).configure(JcloudsLocation.MACHINE_LOCATION_CUSTOMIZERS, (Object)ImmutableList.of((Object)machineCustomizer)).configure(MACHINE_CREATE_ATTEMPTS, (Object)1);
        FakeLocalhostWithParentJcloudsLocation ll = (FakeLocalhostWithParentJcloudsLocation)this.managementContext.getLocationManager().createLocation(LocationSpec.create(FakeLocalhostWithParentJcloudsLocation.class).configure(allConfig.getAllConfig()));
        JcloudsMachineLocation l = (JcloudsMachineLocation)ll.obtain();
        ((JcloudsLocationCustomizer)Mockito.verify((Object)customizer, (VerificationMode)Mockito.times((int)1))).customize((JcloudsLocation)ll, null, l);
        ((JcloudsLocationCustomizer)Mockito.verify((Object)customizer, (VerificationMode)Mockito.never())).preRelease(l);
        ((JcloudsLocationCustomizer)Mockito.verify((Object)customizer, (VerificationMode)Mockito.never())).postRelease(l);
        ((MachineLocationCustomizer)Mockito.verify((Object)machineCustomizer, (VerificationMode)Mockito.times((int)1))).customize((MachineLocation)l);
        ((MachineLocationCustomizer)Mockito.verify((Object)machineCustomizer, (VerificationMode)Mockito.never())).preRelease((MachineLocation)l);
        ll.release((MachineLocation)l);
        ((JcloudsLocationCustomizer)Mockito.verify((Object)customizer, (VerificationMode)Mockito.times((int)1))).preRelease(l);
        ((JcloudsLocationCustomizer)Mockito.verify((Object)customizer, (VerificationMode)Mockito.times((int)1))).postRelease(l);
        ((MachineLocationCustomizer)Mockito.verify((Object)machineCustomizer, (VerificationMode)Mockito.times((int)1))).preRelease((MachineLocation)l);
    }

    protected String getCreateUserStatementsFor(Map<ConfigKey<?>, ?> config) {
        BailOutJcloudsLocation jl = BailOutJcloudsLocation.newBailOutJcloudsLocation((ManagementContext)this.managementContext, MutableMap.builder().put((Object)JcloudsLocationConfig.LOGIN_USER, (Object)"root").put((Object)JcloudsLocationConfig.LOGIN_USER_PASSWORD, (Object)"m0ck").put((Object)JcloudsLocationConfig.USER, (Object)"bob").put((Object)JcloudsLocationConfig.LOGIN_USER_PASSWORD, (Object)"b0b").putAll(config).build());
        JcloudsLocation.UserCreation creation = jl.createUserStatements(null, jl.config().getBag());
        return new StatementList((Iterable)creation.statements).render(OsFamily.UNIX);
    }

    @Test
    public void testDisablesRoot() {
        String statements = this.getCreateUserStatementsFor((Map<ConfigKey<?>, ?>)ImmutableMap.of());
        Assert.assertTrue((boolean)statements.contains("PermitRootLogin"), (String)("Error:\n" + statements));
        Assert.assertTrue((boolean)statements.matches("(?s).*sudoers.*useradd.*bob.*wheel.*"), (String)("Error:\n" + statements));
    }

    @Test
    public void testDisableRootFalse() {
        String statements = this.getCreateUserStatementsFor((Map<ConfigKey<?>, ?>)ImmutableMap.of((Object)JcloudsLocationConfig.DISABLE_ROOT_AND_PASSWORD_SSH, (Object)false));
        Assert.assertFalse((boolean)statements.contains("PermitRootLogin"), (String)("Error:\n" + statements));
        Assert.assertTrue((boolean)statements.matches("(?s).*sudoers.*useradd.*bob.*wheel.*"), (String)("Error:\n" + statements));
    }

    @Test
    public void testDisableRootAndSudoFalse() {
        String statements = this.getCreateUserStatementsFor((Map<ConfigKey<?>, ?>)ImmutableMap.of((Object)JcloudsLocationConfig.DISABLE_ROOT_AND_PASSWORD_SSH, (Object)false, (Object)JcloudsLocationConfig.GRANT_USER_SUDO, (Object)false));
        Assert.assertFalse((boolean)statements.contains("PermitRootLogin"), (String)("Error:\n" + statements));
        Assert.assertFalse((boolean)statements.matches("(?s).*sudoers.*useradd.*bob.*wheel.*"), (String)("Error:\n" + statements));
    }

    public static class ConcurrencyTracker
    implements Function<ConfigBag, Void> {
        final AtomicInteger concurrentCallsCounter = new AtomicInteger();
        final CountDownLatch continuationLatch = new CountDownLatch(1);

        public Void apply(ConfigBag input) {
            this.concurrentCallsCounter.incrementAndGet();
            try {
                this.continuationLatch.await();
            }
            catch (InterruptedException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            return null;
        }

        public void unblock() {
            this.continuationLatch.countDown();
        }

        public void assertCallCountEventually(final int expected) {
            Asserts.succeedsEventually((Runnable)new Runnable(){

                @Override
                public void run() {
                    Assert.assertEquals((int)ConcurrencyTracker.this.concurrentCallsCounter.get(), (int)expected);
                }
            });
        }

        public void assertCallCountContinually(final int expected) {
            Asserts.succeedsContinually((Runnable)new Runnable(){

                @Override
                public void run() {
                    Assert.assertEquals((int)ConcurrencyTracker.this.concurrentCallsCounter.get(), (int)expected);
                }
            });
        }
    }

    public static class FakeLocalhostWithParentJcloudsLocation
    extends JcloudsLocation {
        public static final ConfigKey<Function<ConfigBag, Void>> BUILD_TEMPLATE_INTERCEPTOR = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Function<ConfigBag, Void>>(){}, (String)"buildtemplateinterceptor");
        ConfigBag lastConfigBag;

        public FakeLocalhostWithParentJcloudsLocation() {
        }

        public FakeLocalhostWithParentJcloudsLocation(Map<?, ?> conf) {
            super(conf);
        }

        public JcloudsSshMachineLocation obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
            JcloudsSshMachineLocation result = (JcloudsSshMachineLocation)this.getManagementContext().getLocationManager().createLocation(LocationSpec.create(JcloudsSshMachineLocation.class).configure((CharSequence)"address", (Object)"127.0.0.1").configure((CharSequence)"port", (Object)22).configure((CharSequence)"user", (Object)"bob").configure((CharSequence)"jcloudsParent", (Object)this));
            this.registerJcloudsMachineLocation("bogus", (JcloudsMachineLocation)result);
            for (JcloudsLocationCustomizer customizer : this.getCustomizers(this.config().getBag())) {
                customizer.customize((JcloudsLocation)this, null, (JcloudsMachineLocation)result);
            }
            for (JcloudsLocationCustomizer customizer : this.getMachineCustomizers(this.config().getBag())) {
                customizer.customize((MachineLocation)result);
            }
            return result;
        }

        protected void releaseNode(String instanceId) {
        }
    }
}

