/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsLiveTest;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JcloudsLocationTemplateOptionsCustomisersLiveTest
extends AbstractJcloudsLiveTest {
    private static final String LOCATION_SPEC = "aws-ec2:us-east-1";

    @Override
    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.jcloudsLocation = this.resolve(LOCATION_SPEC);
    }

    @Test(groups={"Live"})
    public void testGeneralPurposeTemplateOptionCustomisation() throws Exception {
        ConfigKey key = JcloudsLocationConfig.TEMPLATE_OPTIONS;
        ConfigBag config = ConfigBag.newInstance().configure(key, (Object)ImmutableMap.of((Object)"iamInstanceProfileName", (Object)"helloworld"));
        AWSEC2TemplateOptions templateOptions = (AWSEC2TemplateOptions)this.jcloudsLocation.getComputeService().templateOptions().as(AWSEC2TemplateOptions.class);
        this.invokeCustomizeTemplateOptions((TemplateOptions)templateOptions, JcloudsLocationConfig.TEMPLATE_OPTIONS, config);
        Assert.assertEquals((String)templateOptions.getIAMInstanceProfileName(), (String)"helloworld");
    }

    @Test(groups={"Live"})
    public void testGeneralPurposeTemplateOptionCustomisationWithList() throws Exception {
        ConfigKey key = JcloudsLocationConfig.TEMPLATE_OPTIONS;
        ConfigBag config = ConfigBag.newInstance().configure(key, (Object)ImmutableMap.of((Object)"iamInstanceProfileName", (Object)"helloworld", (Object)"mapNewVolumeToDeviceName", (Object)ImmutableList.of((Object)"/dev/sda1/", (Object)123, (Object)true)));
        AWSEC2TemplateOptions templateOptions = (AWSEC2TemplateOptions)this.jcloudsLocation.getComputeService().templateOptions().as(AWSEC2TemplateOptions.class);
        this.invokeCustomizeTemplateOptions((TemplateOptions)templateOptions, JcloudsLocationConfig.TEMPLATE_OPTIONS, config);
        Assert.assertEquals((String)templateOptions.getIAMInstanceProfileName(), (String)"helloworld");
        Assert.assertEquals((int)templateOptions.getBlockDeviceMappings().size(), (int)1);
        BlockDeviceMapping blockDeviceMapping = (BlockDeviceMapping)templateOptions.getBlockDeviceMappings().iterator().next();
        Assert.assertEquals((String)blockDeviceMapping.getDeviceName(), (String)"/dev/sda1/");
        Assert.assertEquals((Object)blockDeviceMapping.getEbsVolumeSize(), (Object)123);
        Assert.assertTrue((boolean)blockDeviceMapping.getEbsDeleteOnTermination());
    }

    private void invokeCustomizeTemplateOptions(TemplateOptions templateOptions, ConfigKey<?> keyToTest, ConfigBag locationConfig) {
        Preconditions.checkNotNull((Object)templateOptions, (Object)"templateOptions");
        Preconditions.checkNotNull(keyToTest, (Object)"keyToTest");
        Preconditions.checkNotNull((Object)locationConfig, (Object)"locationConfig");
        Preconditions.checkState((boolean)JcloudsLocation.SUPPORTED_TEMPLATE_OPTIONS_PROPERTIES.containsKey(keyToTest), (Object)("SUPPORTED_TEMPLATE_OPTIONS_PROPERTIES does not contain a customiser for the key " + keyToTest.getName()));
        Preconditions.checkState((boolean)locationConfig.containsKey(keyToTest), (Object)("location config does not contain the key " + keyToTest.getName()));
        JcloudsLocation.CustomizeTemplateOptions code = (JcloudsLocation.CustomizeTemplateOptions)JcloudsLocation.SUPPORTED_TEMPLATE_OPTIONS_PROPERTIES.get(keyToTest);
        code.apply(templateOptions, locationConfig, locationConfig.get(keyToTest));
    }

    private JcloudsLocation resolve(String spec) {
        return (JcloudsLocation)this.managementContext.getLocationRegistry().resolve("jclouds:" + spec);
    }
}

