/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsLiveTest;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JcloudsLocationSuspendResumeMachineLiveTest
extends AbstractJcloudsLiveTest {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsLocationSuspendResumeMachineLiveTest.class);
    private static final String EUWEST_IMAGE_ID = "eu-west-1/ami-ce7b6fba";

    @Override
    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve("aws-ec2:eu-west-1");
    }

    @Test(groups={"Live"})
    public void testObtainThenSuspendThenResumeMachine() throws Exception {
        JcloudsSshMachineLocation machine;
        JcloudsSshMachineLocation sshMachine = machine = this.obtainMachine((Map<?, ?>)ImmutableMap.of((Object)"imageId", (Object)EUWEST_IMAGE_ID));
        Assert.assertTrue((boolean)sshMachine.isSshable(), (String)("Cannot SSH to " + sshMachine));
        this.suspendMachine((MachineLocation)machine);
        Assert.assertFalse((boolean)sshMachine.isSshable(), (String)"Should not be able to SSH to suspended machine");
        MachineLocation machine2 = this.resumeMachine((Map<?, ?>)ImmutableMap.of((Object)"id", (Object)sshMachine.getJcloudsId()));
        Assert.assertTrue((boolean)(machine2 instanceof JcloudsSshMachineLocation));
        Assert.assertTrue((boolean)((JcloudsSshMachineLocation)machine2).isSshable(), (String)("Cannot SSH to " + machine2));
    }
}

