/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.config.SetConfigKey;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JcloudsLocationResolverTest {
    private static final Logger log = LoggerFactory.getLogger(JcloudsLocationResolverTest.class);
    private LocalManagementContext managementContext;
    private BrooklynProperties brooklynProperties;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.managementContext = LocalManagementContextForTests.newInstance();
        this.brooklynProperties = this.managementContext.getBrooklynProperties();
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.identity", (Object)"aws-ec2-id");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.credential", (Object)"aws-ec2-cred");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.rackspace-cloudservers-uk.identity", (Object)"cloudservers-uk-id");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.rackspace-cloudservers-uk.credential", (Object)"cloudservers-uk-cred");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.managementContext != null) {
            this.managementContext.terminate();
        }
    }

    @Test
    public void testJcloudsTakesDotSeparateProperty() {
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.loginUser.privateKeyFile", (Object)"myfile");
        String file = (String)this.resolve("jclouds:aws-ec2").getConfig(JcloudsLocation.LOGIN_USER_PRIVATE_KEY_FILE);
        Assert.assertEquals((String)file, (String)"myfile");
    }

    @Test
    public void testJcloudsTakesProviderScopedProperties() {
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.privateKeyFile", (Object)"myprivatekeyfile");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.publicKeyFile", (Object)"mypublickeyfile");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.privateKeyData", (Object)"myprivateKeyData");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.publicKeyData", (Object)"myPublicKeyData");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.privateKeyPassphrase", (Object)"myprivateKeyPassphrase");
        Map conf = this.resolve("jclouds:aws-ec2").config().getBag().getAllConfig();
        Assert.assertEquals(conf.get("privateKeyFile"), (Object)"myprivatekeyfile");
        Assert.assertEquals(conf.get("publicKeyFile"), (Object)"mypublickeyfile");
        Assert.assertEquals(conf.get("privateKeyData"), (Object)"myprivateKeyData");
        Assert.assertEquals(conf.get("publicKeyData"), (Object)"myPublicKeyData");
        Assert.assertEquals(conf.get("privateKeyPassphrase"), (Object)"myprivateKeyPassphrase");
    }

    @Test
    public void testJcloudsTakesGenericScopedProperties() {
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.privateKeyFile", (Object)"myprivatekeyfile");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.publicKeyFile", (Object)"mypublickeyfile");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.privateKeyData", (Object)"myprivateKeyData");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.publicKeyData", (Object)"myPublicKeyData");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.privateKeyPassphrase", (Object)"myprivateKeyPassphrase");
        Map conf = this.resolve("jclouds:aws-ec2").config().getBag().getAllConfig();
        Assert.assertEquals(conf.get("privateKeyFile"), (Object)"myprivatekeyfile");
        Assert.assertEquals(conf.get("publicKeyFile"), (Object)"mypublickeyfile");
        Assert.assertEquals(conf.get("privateKeyData"), (Object)"myprivateKeyData");
        Assert.assertEquals(conf.get("publicKeyData"), (Object)"myPublicKeyData");
        Assert.assertEquals(conf.get("privateKeyPassphrase"), (Object)"myprivateKeyPassphrase");
    }

    @Test
    public void testJcloudsTakesDeprecatedProperties() {
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.private-key-file", (Object)"myprivatekeyfile");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.public-key-file", (Object)"mypublickeyfile");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.private-key-data", (Object)"myprivateKeyData");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.public-key-data", (Object)"myPublicKeyData");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.private-key-passphrase", (Object)"myprivateKeyPassphrase");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.image-id", (Object)"myimageid");
        Map conf = this.resolve("jclouds:aws-ec2").config().getBag().getAllConfig();
        Assert.assertEquals(conf.get("privateKeyFile"), (Object)"myprivatekeyfile");
        Assert.assertEquals(conf.get("publicKeyFile"), (Object)"mypublickeyfile");
        Assert.assertEquals(conf.get("privateKeyData"), (Object)"myprivateKeyData");
        Assert.assertEquals(conf.get("publicKeyData"), (Object)"myPublicKeyData");
        Assert.assertEquals(conf.get("privateKeyPassphrase"), (Object)"myprivateKeyPassphrase");
        Assert.assertEquals(conf.get("imageId"), (Object)"myimageid");
    }

    @Test
    public void testJcloudsPropertiesPrecedence() {
        this.brooklynProperties.put((Object)"brooklyn.location.named.myaws-ec2", (Object)"jclouds:aws-ec2");
        this.brooklynProperties.put((Object)"brooklyn.location.named.myaws-ec2.privateKeyFile", (Object)"privateKeyFile-inNamed");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.privateKeyFile", (Object)"privateKeyFile-inProviderSpecific");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.privateKeyFile", (Object)"privateKeyFile-inJcloudsGeneric");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.publicKeyFile", (Object)"publicKeyFile-inProviderSpecific");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.publicKeyFile", (Object)"publicKeyFile-inJcloudsGeneric");
        this.brooklynProperties.put((Object)"brooklyn.location.named.myaws-ec2.private-key-data", (Object)"privateKeyData-inNamed");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.privateKeyData", (Object)"privateKeyData-inProviderSpecific");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.privateKeyData", (Object)"privateKeyData-inJcloudsGeneric");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.publicKeyData", (Object)"publicKeyData-inJcloudsGeneric");
        this.brooklynProperties.put((Object)"brooklyn.location.named.myaws-ec2.privateKeyPassphrase", (Object)"privateKeyPassphrase-inNamed");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.private-key-passphrase", (Object)"privateKeyPassphrase-inProviderSpecific");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.private-key-passphrase", (Object)"privateKeyPassphrase-inJcloudsGeneric");
        Map conf = this.resolve("named:myaws-ec2").config().getBag().getAllConfig();
        Assert.assertEquals(conf.get("privateKeyFile"), (Object)"privateKeyFile-inNamed");
        Assert.assertEquals(conf.get("publicKeyFile"), (Object)"publicKeyFile-inProviderSpecific");
        Assert.assertEquals(conf.get("privateKeyData"), (Object)"privateKeyData-inNamed");
        Assert.assertEquals(conf.get("publicKeyData"), (Object)"publicKeyData-inJcloudsGeneric");
        Assert.assertEquals(conf.get("privateKeyPassphrase"), (Object)"privateKeyPassphrase-inNamed");
    }

    @Test
    public void testJcloudsLoads() {
        Assert.assertTrue((boolean)(this.resolve("jclouds:aws-ec2") instanceof JcloudsLocation));
    }

    @Test
    public void testJcloudsImplicitLoads() {
        Assert.assertTrue((boolean)(this.resolve("aws-ec2") instanceof JcloudsLocation));
    }

    @Test
    public void testJcloudsLocationLoads() {
        Assert.assertTrue((boolean)(this.resolve("aws-ec2:eu-west-1") instanceof JcloudsLocation));
    }

    @Test
    public void testJcloudsRegionOnlyLoads() {
        Assert.assertTrue((boolean)(this.resolve("eu-west-1") instanceof JcloudsLocation));
    }

    @Test
    public void testJcloudsEndpointLoads() {
        JcloudsLocation loc = this.resolve("jclouds:openstack-nova:http://foo/api");
        Assert.assertEquals((String)loc.getProvider(), (String)"openstack-nova");
        Assert.assertEquals((String)loc.getEndpoint(), (String)"http://foo/api");
    }

    @Test
    public void testJcloudsEndpointLoadsAsProperty() {
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.openstack-nova.endpoint", (Object)"myendpoint");
        JcloudsLocation loc = this.resolve("jclouds:openstack-nova");
        Assert.assertEquals((Object)loc.config().getLocalBag().getStringKey("endpoint"), (Object)"myendpoint");
        Assert.assertEquals((String)((String)loc.getConfig(CloudLocationConfig.CLOUD_ENDPOINT)), (String)"myendpoint");
        Assert.assertEquals((String)loc.getEndpoint(), (String)"myendpoint");
    }

    @Test
    public void testJcloudsLegacyRandomProperty() {
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.openstack-nova.foo", (Object)"bar");
        JcloudsLocation loc = this.resolve("jclouds:openstack-nova");
        Assert.assertEquals((Object)loc.config().getLocalBag().getStringKey("foo"), (Object)"bar");
    }

    @Test
    public void testJcloudsRandomProperty() {
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.openstack-nova.foo", (Object)"bar");
        JcloudsLocation loc = this.resolve("jclouds:openstack-nova");
        Assert.assertEquals((Object)loc.config().getLocalBag().getStringKey("foo"), (Object)"bar");
    }

    @Test
    public void testThrowsOnInvalid() throws Exception {
        this.assertThrows("wrongprefix:aws-ec2:us-east-1", NoSuchElementException.class);
        this.assertThrows("jclouds", IllegalArgumentException.class);
        this.assertThrows("jclouds:", IllegalArgumentException.class);
        this.assertThrows("jclouds:doesnotexist", NoSuchElementException.class);
    }

    @Test
    public void testResolvesJclouds() throws Exception {
        this.assertJcloudsEquals(this.resolve("jclouds:aws-ec2:us-east-1"), "aws-ec2", "us-east-1");
        this.assertJcloudsEquals(this.resolve("jclouds:rackspace-cloudservers-uk"), "rackspace-cloudservers-uk", null);
    }

    @Test
    public void testJcloudsRegionOverridesParent() {
        this.brooklynProperties.put((Object)"brooklyn.location.named.softlayer-was", (Object)"jclouds:softlayer:was01");
        this.brooklynProperties.put((Object)"brooklyn.location.named.softlayer-was2", (Object)"jclouds:softlayer:was01");
        this.brooklynProperties.put((Object)"brooklyn.location.named.softlayer-was2.region", (Object)"was02");
        Map conf = this.resolve("named:softlayer-was").config().getBag().getAllConfig();
        Assert.assertEquals(conf.get("region"), (Object)"was01");
        conf = this.resolve("named:softlayer-was2").config().getBag().getAllConfig();
        Assert.assertEquals(conf.get("region"), (Object)"was02");
        conf = ((LocationInternal)this.managementContext.getLocationRegistry().resolve("named:softlayer-was2", (Map)MutableMap.of((Object)"region", (Object)"was03"))).config().getBag().getAllConfig();
        Assert.assertEquals(conf.get("region"), (Object)"was03");
    }

    @Test
    public void testLogsWarnings() throws Exception {
        this.assertJcloudsEquals(this.resolve("jclouds:jclouds:aws-ec2:us-east-1"), "aws-ec2", "us-east-1");
        this.assertJcloudsEquals(this.resolve("us-east-1"), "aws-ec2", "us-east-1");
    }

    @Test
    public void testResolvesJcloudsFromNamedOfNamedWithPropertiesOverriddenCorrectly() throws Exception {
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.softlayer.prop1", (Object)"1");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.softlayer.prop2", (Object)"1");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.softlayer.prop3", (Object)"1");
        this.brooklynProperties.put((Object)"brooklyn.location.named.foo", (Object)"jclouds:softlayer:138124");
        this.brooklynProperties.put((Object)"brooklyn.location.named.foo.prop2", (Object)"2");
        this.brooklynProperties.put((Object)"brooklyn.location.named.foo.prop3", (Object)"2");
        this.brooklynProperties.put((Object)"brooklyn.location.named.bar", (Object)"named:foo");
        this.brooklynProperties.put((Object)"brooklyn.location.named.bar.prop3", (Object)"3");
        JcloudsLocation l = this.resolve("named:bar");
        this.assertJcloudsEquals(l, "softlayer", "138124");
        Assert.assertEquals((Object)l.config().getLocalBag().getStringKey("prop3"), (Object)"3");
        Assert.assertEquals((Object)l.config().getLocalBag().getStringKey("prop2"), (Object)"2");
        Assert.assertEquals((Object)l.config().getLocalBag().getStringKey("prop1"), (Object)"1");
    }

    @Test
    public void testResolvesListAndMapProperties() throws Exception {
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.softlayer.prop1", (Object)"[ a, b ]");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.softlayer.prop2", (Object)"{ a: 1, b: 2 }");
        this.brooklynProperties.put((Object)"brooklyn.location.named.foo", (Object)"jclouds:softlayer:ams01");
        JcloudsLocation l = this.resolve("named:foo");
        this.assertJcloudsEquals(l, "softlayer", "ams01");
        Assert.assertEquals((Set)((Set)l.config().get((ConfigKey)new SetConfigKey(String.class, "prop1"))), (Set)MutableSet.of((Object)"a", (Object)"b"));
        Assert.assertEquals((Map)((Map)l.config().get((ConfigKey)new MapConfigKey(String.class, "prop2"))), (Map)MutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2));
    }

    @Test
    public void testResolvesListAndMapPropertiesWithoutMergeOnInheritance() throws Exception {
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.softlayer.prop1", (Object)"[ a, b ]");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.softlayer.prop2", (Object)"{ a: 1, b: 2 }");
        this.brooklynProperties.put((Object)"brooklyn.location.named.foo", (Object)"jclouds:softlayer:ams01");
        this.brooklynProperties.put((Object)"brooklyn.location.named.foo.prop1", (Object)"[ a: 1, c: 3 ]");
        this.brooklynProperties.put((Object)"brooklyn.location.named.foo.prop2", (Object)"{ b: 3, c: 3 }");
        this.brooklynProperties.put((Object)"brooklyn.location.named.bar", (Object)"named:foo");
        this.brooklynProperties.put((Object)"brooklyn.location.named.bar.prop2", (Object)"{ c: 4, d: 4 }");
        this.brooklynProperties.put((Object)"brooklyn.location.named.foo.prop2.z", (Object)"9");
        this.brooklynProperties.put((Object)"brooklyn.location.named.foo.prop3.z", (Object)"9");
        JcloudsLocation l = this.resolve("named:bar");
        this.assertJcloudsEquals(l, "softlayer", "ams01");
        Set prop1 = (Set)l.config().get((ConfigKey)new SetConfigKey(String.class, "prop1"));
        log.info("prop1: " + prop1);
        Assert.assertEquals((Set)prop1, (Set)MutableSet.of((Object)"a: 1", (Object)"c: 3"));
        Map prop2 = (Map)l.config().get((ConfigKey)new MapConfigKey(String.class, "prop2"));
        log.info("prop2: " + prop2);
        Assert.assertEquals((Map)prop2, (Map)MutableMap.of((Object)"c", (Object)4, (Object)"d", (Object)4));
        Map prop3 = (Map)l.config().get((ConfigKey)new MapConfigKey(String.class, "prop3"));
        log.info("prop3: " + prop3);
        Assert.assertEquals((Map)prop3, null);
    }

    private void assertJcloudsEquals(JcloudsLocation loc, String expectedProvider, String expectedRegion) {
        Assert.assertEquals((String)loc.getProvider(), (String)expectedProvider);
        Assert.assertEquals((String)loc.getRegion(), (String)expectedRegion);
    }

    private void assertThrows(String val, Class<?> expectedExceptionType) throws Exception {
        block2: {
            try {
                this.resolve(val);
                Assert.fail();
            }
            catch (Exception e) {
                if (expectedExceptionType.isInstance(e)) break block2;
                throw e;
            }
        }
    }

    @Test(expectedExceptions={NoSuchElementException.class, IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*insufficient.*")
    public void testJcloudsOnlyFails() {
        this.resolve("jclouds");
    }

    private JcloudsLocation resolve(String spec) {
        return (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(spec);
    }
}

