/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsLiveTest;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JcloudsLocationRegisterMachineLiveTest
extends AbstractJcloudsLiveTest {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsLocationRegisterMachineLiveTest.class);
    private static final String EUWEST_IMAGE_ID = "eu-west-1/ami-ce7b6fba";

    @Override
    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve("aws-ec2:eu-west-1");
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testRegisterWithIncorrectId() throws Exception {
        block2: {
            try {
                this.jcloudsLocation.registerMachine((Map)ImmutableMap.of((Object)"id", (Object)"incorrectid", (Object)"hostname", (Object)"myhostname", (Object)"user", (Object)"myusername"));
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("node not found")) break block2;
                throw e;
            }
        }
    }

    @Test(groups={"Live"})
    public void testRegisterVm() throws Exception {
        JcloudsSshMachineLocation machine = this.obtainMachine((Map<?, ?>)ImmutableMap.of((Object)"imageId", (Object)EUWEST_IMAGE_ID));
        Assert.assertTrue((boolean)machine.isSshable());
        LOG.info("obtained " + machine);
        String id = (String)Preconditions.checkNotNull((Object)machine.getJcloudsId(), (Object)"id");
        InetAddress address = (InetAddress)Preconditions.checkNotNull((Object)machine.getAddress(), (Object)"address");
        String hostname = (String)Preconditions.checkNotNull((Object)address.getHostName(), (Object)"hostname");
        String user = (String)Preconditions.checkNotNull((Object)machine.getUser(), (Object)"user");
        JcloudsLocation loc2 = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve("aws-ec2:eu-west-1");
        MachineLocation machineLocation = loc2.registerMachine((Map)ImmutableMap.of((Object)"id", (Object)id, (Object)"hostname", (Object)hostname, (Object)"user", (Object)user));
        Assert.assertTrue((boolean)(machineLocation instanceof SshMachineLocation));
        SshMachineLocation machine2 = (SshMachineLocation)machineLocation;
        LOG.info("Registered " + machine2);
        Assert.assertTrue((boolean)machine2.isSshable());
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)loc2.getChildren()), (Set)ImmutableSet.of((Object)machine2));
        loc2.release((MachineLocation)machine2);
        Assert.assertFalse((boolean)machine.isSshable());
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)loc2.getChildren()), Collections.emptySet());
    }

    @Test(groups={"Live"})
    public void testRegisterVmDeprecated() throws Exception {
        JcloudsSshMachineLocation machine = this.obtainMachine((Map<?, ?>)ImmutableMap.of((Object)"imageId", (Object)EUWEST_IMAGE_ID));
        Assert.assertTrue((boolean)machine.isSshable());
        String id = machine.getJcloudsId();
        InetAddress address = machine.getAddress();
        String hostname = address.getHostName();
        String username = machine.getUser();
        JcloudsLocation loc2 = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve("aws-ec2:eu-west-1");
        MachineLocation machineLocation = loc2.registerMachine((Map)ImmutableMap.of((Object)"id", (Object)id, (Object)"hostname", (Object)hostname, (Object)"userName", (Object)username));
        Assert.assertTrue((boolean)(machineLocation instanceof SshMachineLocation));
        SshMachineLocation machine2 = (SshMachineLocation)machineLocation;
        Assert.assertTrue((boolean)machine2.isSshable());
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)loc2.getChildren()), (Set)ImmutableSet.of((Object)machine2));
        loc2.release((MachineLocation)machine2);
        Assert.assertFalse((boolean)machine.isSshable());
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)loc2.getChildren()), Collections.emptySet());
    }

    @Test(enabled=false, groups={"Live"})
    public void testRegisterVmToHardcodedInstance() throws Exception {
        String id = "eu-west-1/i-5504f21d";
        InetAddress address = InetAddress.getByName("ec2-176-34-93-58.eu-west-1.compute.amazonaws.com");
        String hostname = address.getHostName();
        String username = "root";
        MachineLocation machineLocation = this.jcloudsLocation.registerMachine((Map)ImmutableMap.of((Object)"id", (Object)id, (Object)"hostname", (Object)hostname, (Object)"userName", (Object)username));
        Assert.assertTrue((boolean)(machineLocation instanceof SshMachineLocation));
        SshMachineLocation machine = (SshMachineLocation)machineLocation;
        Assert.assertTrue((boolean)machine.isSshable());
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)this.jcloudsLocation.getChildren()), (Set)ImmutableSet.of((Object)machine));
    }
}

